/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.fingerprint.ICountFingerprint;

public class IntArrayCountFingerprint
implements ICountFingerprint {
    private static final long serialVersionUID = 8656072054328822795L;
    int[] hitHashes;
    int[] numOfHits;
    private boolean behaveAsBitFingerprint;

    public IntArrayCountFingerprint() {
        this.hitHashes = new int[0];
        this.numOfHits = new int[0];
        this.behaveAsBitFingerprint = false;
    }

    public IntArrayCountFingerprint(Map<String, Integer> rawFingerprint) {
        HashMap<Integer, Integer> hashedFP = new HashMap<Integer, Integer>();
        for (String key : rawFingerprint.keySet()) {
            Integer hashedKey = key.hashCode();
            Integer count = (Integer)hashedFP.get(hashedKey);
            if (count == null) {
                count = 0;
            }
            hashedFP.put(hashedKey, count + rawFingerprint.get(key));
        }
        ArrayList keys = new ArrayList(hashedFP.keySet());
        Collections.sort(keys);
        this.hitHashes = new int[keys.size()];
        this.numOfHits = new int[keys.size()];
        int i = 0;
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            int key;
            this.hitHashes[i] = key = ((Integer)i$.next()).intValue();
            this.numOfHits[i] = (Integer)hashedFP.get(key);
            ++i;
        }
    }

    public IntArrayCountFingerprint(Map<String, Integer> rawFingerprint, boolean behaveAsBitFingerprint) {
        this(rawFingerprint);
        this.behaveAsBitFingerprint = behaveAsBitFingerprint;
    }

    @Override
    public long size() {
        return 0x100000000L;
    }

    @Override
    public int getCount(int index) {
        if (this.behaveAsBitFingerprint) {
            return this.numOfHits[index] == 0 ? 0 : 1;
        }
        return this.numOfHits[index];
    }

    @Override
    public int getHash(int index) {
        return this.hitHashes[index];
    }

    @Override
    public int numOfPopulatedbins() {
        return this.hitHashes.length;
    }

    @Override
    public void merge(ICountFingerprint fp) {
        int i;
        HashMap<Integer, Integer> newFp = new HashMap<Integer, Integer>();
        for (i = 0; i < this.hitHashes.length; ++i) {
            newFp.put(this.hitHashes[i], this.numOfHits[i]);
        }
        for (i = 0; i < fp.numOfPopulatedbins(); ++i) {
            Integer count = (Integer)newFp.get(fp.getHash(i));
            if (count == null) {
                count = 0;
            }
            newFp.put(fp.getHash(i), count + fp.getCount(i));
        }
        ArrayList keys = new ArrayList(newFp.keySet());
        Collections.sort(keys);
        this.hitHashes = new int[keys.size()];
        this.numOfHits = new int[keys.size()];
        int i2 = 0;
        for (Integer key : keys) {
            this.hitHashes[i2] = key;
            this.numOfHits[i2++] = (Integer)newFp.get(key);
        }
    }

    @Override
    public void setBehaveAsBitFingerprint(boolean behaveAsBitFingerprint) {
        this.behaveAsBitFingerprint = behaveAsBitFingerprint;
    }

    @Override
    public boolean hasHash(int hash) {
        return Arrays.binarySearch(this.hitHashes, hash) >= 0;
    }

    @Override
    public int getCountForHash(int hash) {
        int index = Arrays.binarySearch(this.hitHashes, hash);
        if (index >= 0) {
            return this.numOfHits[index];
        }
        return 0;
    }
}

