/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.BaseMapping;
import org.openscience.smsd.algorithm.single.SingleMappingHandler;
import org.openscience.smsd.algorithm.vflib.VF2Sub;
import org.openscience.smsd.algorithm.vflib.substructure.VF2;
import org.openscience.smsd.helper.MoleculeInitializer;

public final class Substructure
extends BaseMapping {
    private int vfMappingSize = -1;
    private final ILoggingTool Logger = LoggingToolFactory.createLoggingTool(Substructure.class);

    public Substructure(IAtomContainer query2, IAtomContainer target, boolean shouldMatchBonds, boolean matchRings, boolean matchAtomType, boolean findAllSubgraph) throws CDKException {
        super(query2, target, shouldMatchBonds, matchRings, matchAtomType);
        if (this.isMatchRings()) {
            try {
                MoleculeInitializer.initializeMolecule(this.getQuery());
                MoleculeInitializer.initializeMolecule(this.getTarget());
            }
            catch (CDKException cDKException) {
                // empty catch block
            }
        }
        if (findAllSubgraph) {
            this.setSubgraph(this.findSubgraphs());
        } else {
            this.setSubgraph(this.findSubgraph());
        }
    }

    public Substructure(IQueryAtomContainer query2, IAtomContainer target, boolean findAllSubgraph) throws CDKException {
        super(query2, target);
        if (findAllSubgraph) {
            this.setSubgraph(this.findSubgraphs());
        } else {
            this.setSubgraph(this.findSubgraph());
        }
    }

    private synchronized boolean hasMap(AtomAtomMapping map, List<AtomAtomMapping> mapGlobal) {
        for (AtomAtomMapping test : mapGlobal) {
            if (!test.equals(map)) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean findSubgraph() throws CDKException {
        boolean isSubgraph;
        if (this.getTarget() == null || this.getQuery() == null) {
            throw new CDKException("Query or Target molecule is not initialized (NULL)");
        }
        if (this.getQuery().getAtomCount() > this.getTarget().getAtomCount()) {
            return false;
        }
        if (this.getQuery().getAtomCount() == 1 || this.getTarget().getAtomCount() == 1) {
            isSubgraph = this.singleMapping();
        } else {
            ArrayList<AtomAtomMapping> mappingsVF2 = new ArrayList<AtomAtomMapping>();
            VF2 mapper = this.getQuery() instanceof IQueryAtomContainer ? new VF2((IQueryAtomContainer)this.getQuery(), this.getTarget()) : new VF2(this.getQuery(), this.getTarget(), this.isMatchBonds(), this.isMatchRings(), this.isMatchAtomType());
            isSubgraph = mapper.isSubgraph();
            List<AtomAtomMapping> atomMappings = mapper.getAllAtomMapping();
            if (!isSubgraph) {
                return false;
            }
            mappingsVF2.addAll(atomMappings);
            this.setVFMappings(mappingsVF2);
        }
        return isSubgraph;
    }

    private synchronized boolean findSubgraphs() throws CDKException {
        boolean isSubgraph;
        if (this.getTarget() == null || this.getQuery() == null) {
            throw new CDKException("Query or Target molecule is not initialized (NULL)");
        }
        if (this.getQuery().getAtomCount() > this.getTarget().getAtomCount()) {
            return false;
        }
        if (this.getQuery().getAtomCount() == 1 || this.getTarget().getAtomCount() == 1) {
            isSubgraph = this.singleMapping();
        } else {
            ArrayList<AtomAtomMapping> mappingsVF2 = new ArrayList<AtomAtomMapping>();
            VF2Sub mapper = this.getQuery() instanceof IQueryAtomContainer ? new VF2Sub((IQueryAtomContainer)this.getQuery(), this.getTarget()) : new VF2Sub(this.getQuery(), this.getTarget(), this.isMatchBonds(), this.isMatchRings(), this.isMatchAtomType());
            isSubgraph = mapper.isSubgraph();
            List<AtomAtomMapping> atomMappings = mapper.getAllAtomMapping();
            if (!isSubgraph) {
                return false;
            }
            mappingsVF2.addAll(atomMappings);
            this.setVFMappings(mappingsVF2);
        }
        return isSubgraph;
    }

    private synchronized void setVFMappings(List<AtomAtomMapping> mappingsVF2) {
        int counter = 0;
        for (AtomAtomMapping solution : mappingsVF2) {
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.getQuery(), this.getTarget());
            if (solution.getCount() > this.vfMappingSize) {
                this.vfMappingSize = solution.getCount();
                counter = 0;
            }
            for (Map.Entry<IAtom, IAtom> mapping : solution.getMappingsByAtoms().entrySet()) {
                IAtom qAtom = mapping.getKey();
                IAtom tAtom = mapping.getValue();
                if (qAtom != null && tAtom != null) {
                    atomatomMapping.put(qAtom, tAtom);
                    continue;
                }
                try {
                    throw new CDKException("Atom index pointing to NULL");
                }
                catch (CDKException ex) {
                    this.Logger.error(Level.SEVERE, null, ex);
                }
            }
            if (atomatomMapping.isEmpty() || this.hasMap(atomatomMapping, this.getMCSList()) || atomatomMapping.getCount() != this.vfMappingSize) continue;
            this.getMCSList().add(counter, atomatomMapping);
            ++counter;
        }
    }

    private synchronized boolean singleMapping() {
        SingleMappingHandler mcs = !(this.getQuery() instanceof IQueryAtomContainer) && !(this.getTarget() instanceof IQueryAtomContainer) ? new SingleMappingHandler(this.getQuery(), this.getTarget(), this.isMatchRings()) : new SingleMappingHandler((IQueryAtomContainer)this.getQuery(), this.getTarget());
        return mcs.getAllAtomMapping() != null && !mcs.getAllAtomMapping().isEmpty();
    }
}

