/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.matchers;

import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;

public final class DefaultAtomTypeMatcher
implements AtomMatcher {
    static final long serialVersionUID = -7861469841127327812L;
    private final String symbol;
    private final IAtom qAtom;
    private final boolean shouldMatchRings;

    public DefaultAtomTypeMatcher(IAtom qAtom, String symbol, boolean shouldMatchRings) {
        this.qAtom = qAtom;
        this.symbol = symbol;
        this.shouldMatchRings = shouldMatchRings;
    }

    public DefaultAtomTypeMatcher(IAtom atom, boolean shouldMatchRings) {
        this(atom, atom.getSymbol(), shouldMatchRings);
    }

    private boolean matchSymbol(IAtom atom) {
        if (this.getAtomSymbol() == null) {
            return false;
        }
        return this.getAtomSymbol().equals(atom.getSymbol());
    }

    @Override
    public boolean matches(IAtom targetAtom) {
        if (targetAtom instanceof IQueryAtom) {
            return ((IQueryAtom)targetAtom).matches(this.getQueryAtom());
        }
        if (this.getQueryAtom() != null && this.getQueryAtom() instanceof IQueryAtom) {
            return ((IQueryAtom)this.getQueryAtom()).matches(targetAtom);
        }
        if (!this.matchSymbol(targetAtom)) {
            return false;
        }
        if (this.isMatchRings() && this.isRingAtom(this.getQueryAtom()) && !this.isRingAtom(targetAtom)) {
            return false;
        }
        if (this.isMatchRings() && !this.isRingAtom(this.getQueryAtom()) && this.isRingAtom(targetAtom)) {
            return false;
        }
        if (this.isMatchRings() && this.isRingAtom(this.getQueryAtom()) && this.isRingAtom(targetAtom) && !this.isRingSizeMatch(targetAtom)) {
            return false;
        }
        return this.matchAtomType(targetAtom) || !this.isAliphaticAtom(this.getQueryAtom()) || !this.isAliphaticAtom(targetAtom);
    }

    private boolean isRingSizeMatch(IAtom atom) {
        List ringsizesQ = (List)this.qAtom.getProperty("cdk:RingSizes");
        List ringsizesT = (List)atom.getProperty("cdk:RingSizes");
        if (ringsizesQ != null && ringsizesT != null) {
            Iterator iterator = ringsizesQ.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (!ringsizesT.contains(i)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAliphaticAtom(IAtom atom) {
        return atom.getFlag(8);
    }

    private boolean isRingAtom(IAtom atom) {
        return atom.getFlag(2);
    }

    @Override
    public IAtom getQueryAtom() {
        return this.qAtom;
    }

    public String getAtomSymbol() {
        return this.symbol;
    }

    public boolean isMatchRings() {
        return this.shouldMatchRings;
    }

    private boolean matchAtomType(IAtom targetAtom) {
        String rAtom = this.qAtom.getAtomTypeName() == null ? this.qAtom.getSymbol() : this.qAtom.getAtomTypeName();
        String tAtom = targetAtom.getAtomTypeName() == null ? targetAtom.getSymbol() : targetAtom.getAtomTypeName();
        return rAtom.equals(tAtom);
    }
}

