/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.matchers;

import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.smsd.algorithm.matchers.BondMatcher;

public final class DefaultBondMatcher
implements BondMatcher {
    static final long serialVersionUID = -7861469841127328812L;
    private final IBond queryBond;
    private final boolean shouldMatchBonds;
    private final boolean matchAtomTypes;
    private final boolean shouldMatchRings;

    public DefaultBondMatcher() {
        this.queryBond = null;
        this.shouldMatchBonds = false;
        this.matchAtomTypes = false;
        this.shouldMatchRings = false;
    }

    public DefaultBondMatcher(IBond queryBond, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomTypes) {
        this.queryBond = queryBond;
        this.shouldMatchBonds = shouldMatchBonds;
        this.shouldMatchRings = shouldMatchRings;
        this.matchAtomTypes = matchAtomTypes;
    }

    @Override
    public boolean matches(IBond targetBond) {
        if (this.queryBond != null && this.queryBond instanceof IQueryBond) {
            return ((IQueryBond)this.queryBond).matches(targetBond);
        }
        if (this.queryBond != null && targetBond != null && this.isBondMatchFlag() && this.isBondTypeMatch(targetBond)) {
            return true;
        }
        if (this.queryBond != null && targetBond != null && !this.isBondMatchFlag() && this.isShouldMatchRings()) {
            if (this.queryBond.getFlag(32) && targetBond.getFlag(32)) {
                return true;
            }
            if (!this.queryBond.getFlag(32) && !targetBond.getFlag(32)) {
                return true;
            }
        } else if (this.queryBond != null && targetBond != null && !this.isBondMatchFlag() && !this.isShouldMatchRings()) {
            return true;
        }
        return false;
    }

    private boolean isBondTypeMatch(IBond targetBond) {
        if (this.queryBond.getFlag(32) == targetBond.getFlag(32) && this.queryBond.getOrder().equals((Object)targetBond.getOrder())) {
            return true;
        }
        if (this.queryBond.getFlag(32) && targetBond.getFlag(32)) {
            return true;
        }
        return !this.matchAtomTypes && this.queryBond.getFlag(2) && targetBond.getFlag(2) && (this.queryBond.getOrder() == IBond.Order.UNSET || targetBond.getOrder() == IBond.Order.UNSET);
    }

    public boolean isBondMatchFlag() {
        return this.shouldMatchBonds;
    }

    public boolean isShouldMatchRings() {
        return this.shouldMatchRings;
    }
}

