/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.rgraph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.manipulator.BondManipulator;
import org.openscience.smsd.algorithm.rgraph.CDKMCS;
import org.openscience.smsd.algorithm.rgraph.CDKRMap;

public final class CDKRMapHandler {
    private List<Map<Integer, Integer>> mappings;
    private IAtomContainer source;
    private IAtomContainer target;
    private boolean timeout = false;

    public synchronized IAtomContainer getSource() {
        return this.source;
    }

    public synchronized void setSource(IAtomContainer aSource) {
        this.source = aSource;
    }

    public synchronized IAtomContainer getTarget() {
        return this.target;
    }

    public synchronized void setTarget(IAtomContainer aTarget) {
        this.target = aTarget;
    }

    public synchronized List<Map<Integer, Integer>> calculateOverlapsAndReduce(IAtomContainer molecule1, IAtomContainer molecule2, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) throws CDKException {
        this.setSource(molecule1);
        this.setTarget(molecule2);
        ArrayList<Map<Integer, Integer>> solution = new ArrayList<Map<Integer, Integer>>();
        this.setMappings(solution);
        if (this.getSource().getAtomCount() == 1 || this.getTarget().getAtomCount() == 1) {
            List<CDKRMap> overlaps = CDKMCS.checkSingleAtomCases(this.getSource(), this.getTarget());
            this.setTimeout(CDKMCS.isTimeout());
            int nAtomsMatched = overlaps.size();
            int n = nAtomsMatched = nAtomsMatched > 0 ? 1 : 0;
            if (nAtomsMatched > 0) {
                this.identifySingleAtomsMatchedParts(overlaps, this.getSource(), this.getTarget());
            }
        } else {
            List<List<CDKRMap>> overlaps = CDKMCS.search(this.getSource(), this.getTarget(), new BitSet(), new BitSet(), true, true, shouldMatchBonds, shouldMatchRings, matchAtomType);
            this.setTimeout(CDKMCS.isTimeout());
            List<List<CDKRMap>> reducedList = this.removeSubGraph(overlaps);
            Stack<List<CDKRMap>> allMaxOverlaps = this.getAllMaximum(reducedList);
            while (!allMaxOverlaps.empty()) {
                List<List<CDKRMap>> maxOverlapsAtoms = this.makeAtomsMapOfBondsMap(allMaxOverlaps.peek(), this.getSource(), this.getTarget());
                this.identifyMatchedParts(maxOverlapsAtoms, this.getSource(), this.getTarget());
                allMaxOverlaps.pop();
            }
        }
        return solution;
    }

    public synchronized List<Map<Integer, Integer>> calculateOverlapsAndReduce(IAtomContainer molecule1, IQueryAtomContainer molecule2) throws CDKException {
        this.setSource(molecule1);
        this.setTarget(molecule2);
        ArrayList<Map<Integer, Integer>> solution = new ArrayList<Map<Integer, Integer>>();
        this.setMappings(solution);
        if (this.getSource().getAtomCount() == 1 || this.getTarget().getAtomCount() == 1) {
            List<CDKRMap> overlaps = CDKMCS.checkSingleAtomCases(this.getSource(), this.getTarget());
            this.setTimeout(CDKMCS.isTimeout());
            int nAtomsMatched = overlaps.size();
            int n = nAtomsMatched = nAtomsMatched > 0 ? 1 : 0;
            if (nAtomsMatched > 0) {
                this.identifySingleAtomsMatchedParts(overlaps, this.getSource(), (IQueryAtomContainer)this.getTarget());
            }
        } else {
            List<List<CDKRMap>> overlaps = CDKMCS.search(this.getSource(), (IQueryAtomContainer)this.getTarget(), new BitSet(), new BitSet(), true, true, true, true, true);
            this.setTimeout(CDKMCS.isTimeout());
            List<List<CDKRMap>> reducedList = this.removeSubGraph(overlaps);
            Stack<List<CDKRMap>> allMaxOverlaps = this.getAllMaximum(reducedList);
            while (!allMaxOverlaps.empty()) {
                List<List<CDKRMap>> maxOverlapsAtoms = this.makeAtomsMapOfBondsMap(allMaxOverlaps.peek(), this.getSource(), (IQueryAtomContainer)this.getTarget());
                this.identifyMatchedParts(maxOverlapsAtoms, this.getSource(), (IQueryAtomContainer)this.getTarget());
                allMaxOverlaps.pop();
            }
        }
        return solution;
    }

    public synchronized void calculateOverlapsAndReduceExactMatch(IAtomContainer Molecule1, IAtomContainer Molecule2, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) throws CDKException {
        this.setSource(Molecule1);
        this.setTarget(Molecule2);
        this.setMappings(new ArrayList<Map<Integer, Integer>>());
        if (this.getSource().getAtomCount() == 1 || this.getTarget().getAtomCount() == 1) {
            List<CDKRMap> overlaps = CDKMCS.checkSingleAtomCases(this.getSource(), this.getTarget());
            this.setTimeout(CDKMCS.isTimeout());
            int nAtomsMatched = overlaps.size();
            int n = nAtomsMatched = nAtomsMatched > 0 ? 1 : 0;
            if (nAtomsMatched > 0) {
                this.identifySingleAtomsMatchedParts(overlaps, this.getSource(), this.getTarget());
            }
        } else {
            List<List<CDKRMap>> overlaps = CDKMCS.search(this.getSource(), this.getTarget(), new BitSet(), new BitSet(), true, true, shouldMatchBonds, shouldMatchRings, matchAtomType);
            this.setTimeout(CDKMCS.isTimeout());
            List<List<CDKRMap>> reducedList = this.removeSubGraph(overlaps);
            Stack<List<CDKRMap>> allMaxOverlaps = this.getAllMaximum(reducedList);
            while (!allMaxOverlaps.empty()) {
                List<List<CDKRMap>> maxOverlapsAtoms = this.makeAtomsMapOfBondsMap(allMaxOverlaps.peek(), this.getSource(), this.getTarget());
                this.identifyMatchedParts(maxOverlapsAtoms, this.getSource(), this.getTarget());
                allMaxOverlaps.pop();
            }
        }
    }

    public synchronized List<Map<Integer, Integer>> calculateSubGraphs(IAtomContainer Molecule1, IAtomContainer Molecule2, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) throws CDKException {
        this.setSource(Molecule1);
        this.setTarget(Molecule2);
        ArrayList<Map<Integer, Integer>> solutions = new ArrayList<Map<Integer, Integer>>();
        this.setMappings(solutions);
        if (this.getSource().getAtomCount() == 1 || this.getTarget().getAtomCount() == 1) {
            List<CDKRMap> overlaps = CDKMCS.checkSingleAtomCases(this.getSource(), this.getTarget());
            this.setTimeout(CDKMCS.isTimeout());
            int nAtomsMatched = overlaps.size();
            int n = nAtomsMatched = nAtomsMatched > 0 ? 1 : 0;
            if (nAtomsMatched > 0) {
                this.identifySingleAtomsMatchedParts(overlaps, this.getSource(), this.getTarget());
            }
        } else {
            List<List<CDKRMap>> overlaps = CDKMCS.getSubgraphMaps(this.getSource(), this.getTarget(), shouldMatchBonds, shouldMatchRings, matchAtomType);
            this.setTimeout(CDKMCS.isTimeout());
            List<List<CDKRMap>> reducedList = this.removeSubGraph(overlaps);
            Stack<List<CDKRMap>> allMaxOverlaps = this.getAllMaximum(reducedList);
            while (!allMaxOverlaps.empty()) {
                List<List<CDKRMap>> maxOverlapsAtoms = this.makeAtomsMapOfBondsMap(allMaxOverlaps.peek(), this.getSource(), this.getTarget());
                this.identifyMatchedParts(maxOverlapsAtoms, this.getSource(), this.getTarget());
                allMaxOverlaps.pop();
            }
        }
        return solutions;
    }

    public synchronized List<Map<Integer, Integer>> calculateIsomorphs(IAtomContainer Molecule1, IAtomContainer Molecule2, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) throws CDKException {
        this.setSource(Molecule1);
        this.setTarget(Molecule2);
        ArrayList<Map<Integer, Integer>> solutions = new ArrayList<Map<Integer, Integer>>();
        this.setMappings(solutions);
        if (this.getSource().getAtomCount() == 1 || this.getTarget().getAtomCount() == 1) {
            List<CDKRMap> overlaps = CDKMCS.checkSingleAtomCases(this.getSource(), this.getTarget());
            this.setTimeout(CDKMCS.isTimeout());
            int nAtomsMatched = overlaps.size();
            int n = nAtomsMatched = nAtomsMatched > 0 ? 1 : 0;
            if (nAtomsMatched > 0) {
                this.identifySingleAtomsMatchedParts(overlaps, this.getSource(), this.getTarget());
            }
        } else {
            List<List<CDKRMap>> overlaps = CDKMCS.getIsomorphMaps(this.getSource(), this.getTarget(), shouldMatchBonds, shouldMatchRings, matchAtomType);
            this.setTimeout(CDKMCS.isTimeout());
            List<List<CDKRMap>> reducedList = this.removeSubGraph(overlaps);
            Stack<List<CDKRMap>> allMaxOverlaps = this.getAllMaximum(reducedList);
            while (!allMaxOverlaps.empty()) {
                List<List<CDKRMap>> maxOverlapsAtoms = this.makeAtomsMapOfBondsMap(allMaxOverlaps.peek(), this.getSource(), this.getTarget());
                this.identifyMatchedParts(maxOverlapsAtoms, this.getSource(), this.getTarget());
                allMaxOverlaps.pop();
            }
        }
        return solutions;
    }

    protected synchronized List<List<CDKRMap>> removeSubGraph(List<List<CDKRMap>> overlaps) {
        ArrayList<List<CDKRMap>> reducedList = new ArrayList<List<CDKRMap>>(overlaps);
        for (int i = 0; i < overlaps.size(); ++i) {
            List<CDKRMap> graphI = overlaps.get(i);
            for (int j = i + 1; j < overlaps.size(); ++j) {
                List<CDKRMap> graphJ = overlaps.get(j);
                if (graphI.size() == graphJ.size()) continue;
                if (this.isSubgraph(graphJ, graphI)) {
                    reducedList.remove(graphI);
                    continue;
                }
                if (!this.isSubgraph(graphI, graphJ)) continue;
                reducedList.remove(graphJ);
            }
        }
        return reducedList;
    }

    protected synchronized List<CDKRMap> removeRedundantMappingsForSingleAtomCase(List<CDKRMap> overlaps) {
        List<CDKRMap> reducedList = Collections.synchronizedList(new ArrayList());
        reducedList.add(overlaps.get(0));
        return reducedList;
    }

    private synchronized List<List<CDKRMap>> makeAtomsMapOfBondsMap(List<CDKRMap> rMapList, IAtomContainer graph1, IAtomContainer graph2) {
        List<List<CDKRMap>> result;
        if (rMapList == null) {
            return null;
        }
        if (rMapList.size() == 1) {
            result = this.makeAtomsMapOfBondsMapSingleBond(rMapList, graph1, graph2);
        } else {
            ArrayList<CDKRMap> resultLocal = new ArrayList<CDKRMap>();
            for (CDKRMap rMapList2 : rMapList) {
                IBond qBond = graph1.getBond(rMapList2.getId1());
                IBond tBond = graph2.getBond(rMapList2.getId2());
                IAtom[] qAtoms = BondManipulator.getAtomArray(qBond);
                IAtom[] tAtoms = BondManipulator.getAtomArray(tBond);
                for (int j = 0; j < 2; ++j) {
                    List<IBond> bondsConnectedToAtom1j = graph1.getConnectedBondsList(qAtoms[j]);
                    for (IBond bondsConnectedToAtom1j1 : bondsConnectedToAtom1j) {
                        if (bondsConnectedToAtom1j1 == qBond) continue;
                        IBond testBond = bondsConnectedToAtom1j1;
                        for (CDKRMap rMapList1 : rMapList) {
                            if (rMapList1.getId1() != graph1.getBondNumber(testBond)) continue;
                            IBond testBond2 = graph2.getBond(rMapList1.getId2());
                            for (int n = 0; n < 2; ++n) {
                                CDKRMap map2;
                                List<IBond> bondsToTest = graph2.getConnectedBondsList(tAtoms[n]);
                                if (!bondsToTest.contains(testBond2)) continue;
                                CDKRMap map1 = j == n ? new CDKRMap(graph1.getAtomNumber(qAtoms[0]), graph2.getAtomNumber(tAtoms[0])) : new CDKRMap(graph1.getAtomNumber(qAtoms[1]), graph2.getAtomNumber(tAtoms[0]));
                                if (!resultLocal.contains(map1)) {
                                    resultLocal.add(map1);
                                }
                                if (resultLocal.contains(map2 = j == n ? new CDKRMap(graph1.getAtomNumber(qAtoms[1]), graph2.getAtomNumber(tAtoms[1])) : new CDKRMap(graph1.getAtomNumber(qAtoms[0]), graph2.getAtomNumber(tAtoms[1])))) continue;
                                resultLocal.add(map2);
                            }
                        }
                    }
                }
            }
            result = new ArrayList<List<CDKRMap>>();
            result.add(resultLocal);
        }
        return result;
    }

    private synchronized List<List<CDKRMap>> makeAtomsMapOfBondsMapSingleBond(List<CDKRMap> list, IAtomContainer sourceGraph, IAtomContainer targetGraph) {
        if (list == null) {
            return null;
        }
        HashMap<IBond, IBond> bondMap = new HashMap<IBond, IBond>(list.size());
        for (CDKRMap solBondMap : list) {
            int id1 = solBondMap.getId1();
            int id2 = solBondMap.getId2();
            IBond qBond = sourceGraph.getBond(id1);
            IBond tBond = targetGraph.getBond(id2);
            bondMap.put(qBond, tBond);
        }
        ArrayList<CDKRMap> result1 = new ArrayList<CDKRMap>();
        ArrayList<CDKRMap> result2 = new ArrayList<CDKRMap>();
        for (IBond qbond : sourceGraph.bonds()) {
            if (!bondMap.containsKey(qbond)) continue;
            IBond tbond = (IBond)bondMap.get(qbond);
            CDKRMap map00 = null;
            CDKRMap map01 = null;
            CDKRMap map10 = null;
            CDKRMap map11 = null;
            if (qbond.getAtom(0).getSymbol().equals(tbond.getAtom(0).getSymbol()) && qbond.getAtom(1).getSymbol().equals(tbond.getAtom(1).getSymbol())) {
                map00 = new CDKRMap(sourceGraph.getAtomNumber(qbond.getAtom(0)), targetGraph.getAtomNumber(tbond.getAtom(0)));
                map11 = new CDKRMap(sourceGraph.getAtomNumber(qbond.getAtom(1)), targetGraph.getAtomNumber(tbond.getAtom(1)));
                if (!result1.contains(map00)) {
                    result1.add(map00);
                }
                if (!result1.contains(map11)) {
                    result1.add(map11);
                }
            }
            if (!qbond.getAtom(0).getSymbol().equals(tbond.getAtom(1).getSymbol()) || !qbond.getAtom(1).getSymbol().equals(tbond.getAtom(0).getSymbol())) continue;
            map01 = new CDKRMap(sourceGraph.getAtomNumber(qbond.getAtom(0)), targetGraph.getAtomNumber(tbond.getAtom(1)));
            map10 = new CDKRMap(sourceGraph.getAtomNumber(qbond.getAtom(1)), targetGraph.getAtomNumber(tbond.getAtom(0)));
            if (!result2.contains(map01)) {
                result2.add(map01);
            }
            if (result2.contains(map10)) continue;
            result2.add(map10);
        }
        ArrayList<List<CDKRMap>> result = new ArrayList<List<CDKRMap>>();
        if (result1.size() == result2.size()) {
            result.add(result1);
            result.add(result2);
        } else if (result1.size() > result2.size()) {
            result.add(result1);
        } else {
            result.add(result2);
        }
        return result;
    }

    protected synchronized List getMaximum(List overlaps) {
        ArrayList list = null;
        int count = 0;
        for (Object o : overlaps) {
            ArrayList arrayList = (ArrayList)o;
            if (arrayList.size() <= count) continue;
            list = arrayList;
            count = arrayList.size();
        }
        return list;
    }

    protected synchronized Stack<List<CDKRMap>> getAllMaximum(List<List<CDKRMap>> overlaps) {
        Stack<ArrayList<CDKRMap>> allMaximumMappings = null;
        int count = -1;
        for (List<CDKRMap> arrayList : overlaps) {
            ArrayList<CDKRMap> list;
            if (arrayList.size() > count) {
                list = new ArrayList<CDKRMap>(arrayList);
                count = arrayList.size();
                allMaximumMappings = new Stack<ArrayList<CDKRMap>>();
                allMaximumMappings.push(list);
                continue;
            }
            if (arrayList.size() != count) continue;
            list = new ArrayList<CDKRMap>(arrayList);
            count = arrayList.size();
            allMaximumMappings.push(list);
        }
        return allMaximumMappings;
    }

    protected synchronized void identifyMatchedParts(List<List<CDKRMap>> list, IAtomContainer source, IAtomContainer target) {
        for (List<CDKRMap> rMap : list) {
            TreeMap<Integer, Integer> atomNumbersFromContainer = new TreeMap<Integer, Integer>();
            for (CDKRMap rmap : rMap) {
                IAtom sourceAtom = source.getAtom(rmap.getId1());
                IAtom targetAtom = target.getAtom(rmap.getId2());
                int indexI = source.getAtomNumber(sourceAtom);
                int indexJ = target.getAtomNumber(targetAtom);
                atomNumbersFromContainer.put(indexI, indexJ);
            }
            this.getMappings().add(atomNumbersFromContainer);
        }
    }

    protected synchronized void identifySingleAtomsMatchedParts(List<CDKRMap> list, IAtomContainer source, IAtomContainer target) {
        TreeMap<Integer, Integer> atomNumbersFromContainer = new TreeMap<Integer, Integer>();
        for (CDKRMap rmap : list) {
            IAtom sAtom = source.getAtom(rmap.getId1());
            IAtom tAtom = target.getAtom(rmap.getId2());
            int indexI = source.getAtomNumber(sAtom);
            int indexJ = target.getAtomNumber(tAtom);
            atomNumbersFromContainer.put(indexI, indexJ);
            this.getMappings().add(atomNumbersFromContainer);
        }
    }

    protected synchronized boolean isSubgraph(List<CDKRMap> rmaps1, List<CDKRMap> rmaps2) {
        List rmaps2clone = (List)((ArrayList)rmaps2).clone();
        for (CDKRMap rmap1 : rmaps1) {
            boolean found = false;
            for (int i = 0; i < rmaps2clone.size(); ++i) {
                CDKRMap rmap2 = (CDKRMap)rmaps2clone.get(i);
                if (!this.isSameRMap(rmap1, rmap2)) continue;
                rmaps2clone.remove(i);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    protected synchronized boolean isSameRMap(CDKRMap sourceRMap, CDKRMap targetRMap) {
        return sourceRMap.getId1() == targetRMap.getId1() && sourceRMap.getId2() == targetRMap.getId2();
    }

    public synchronized List<Map<Integer, Integer>> getMappings() {
        return this.mappings;
    }

    public synchronized void setMappings(List<Map<Integer, Integer>> mappings) {
        this.mappings = mappings;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public void setTimeout(boolean timeout) {
        this.timeout = timeout;
    }
}

