/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.rgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.rgraph.CDKMCS;
import org.openscience.smsd.algorithm.rgraph.CDKRMap;
import org.openscience.smsd.algorithm.rgraph.CDKRMapHandler;
import org.openscience.smsd.interfaces.IResults;

public class CDKSubGraphHandler
implements IResults {
    private final IAtomContainer source;
    private final IAtomContainer target;
    private boolean rOnPFlag = false;
    private List<AtomAtomMapping> allAtomMCS = null;
    private List<Map<Integer, Integer>> allMCS = null;
    private final boolean shouldMatchRings;
    private final boolean shouldMatchBonds;
    private final boolean matchAtomType;

    public CDKSubGraphHandler(IAtomContainer source, IAtomContainer target, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        this.source = source;
        this.target = target;
        this.shouldMatchRings = shouldMatchRings;
        this.shouldMatchBonds = shouldMatchBonds;
        this.matchAtomType = matchAtomType;
        this.allAtomMCS = new ArrayList<AtomAtomMapping>();
        this.allMCS = new ArrayList<Map<Integer, Integer>>();
        this.isSubgraph();
    }

    public CDKSubGraphHandler(IQueryAtomContainer source, IQueryAtomContainer target) {
        this.source = source;
        this.target = target;
        this.shouldMatchRings = true;
        this.shouldMatchBonds = true;
        this.matchAtomType = true;
        this.allAtomMCS = new ArrayList<AtomAtomMapping>();
        this.allMCS = new ArrayList<Map<Integer, Integer>>();
        this.isSubgraph();
    }

    private boolean isSubgraph() {
        CDKRMapHandler rmap = new CDKRMapHandler();
        try {
            List<Map<Integer, Integer>> solutions;
            if (this.source.getAtomCount() == this.target.getAtomCount() && this.source.getBondCount() == this.target.getBondCount()) {
                this.rOnPFlag = true;
                solutions = rmap.calculateIsomorphs(this.source, this.target, this.shouldMatchBonds, this.shouldMatchRings, this.matchAtomType);
            } else if (this.source.getAtomCount() > this.target.getAtomCount() && this.source.getBondCount() != this.target.getBondCount()) {
                this.rOnPFlag = true;
                solutions = rmap.calculateSubGraphs(this.source, this.target, this.shouldMatchBonds, this.shouldMatchRings, this.matchAtomType);
            } else {
                this.rOnPFlag = false;
                solutions = rmap.calculateSubGraphs(this.target, this.source, this.shouldMatchBonds, this.shouldMatchRings, this.matchAtomType);
            }
            this.setAllMapping(solutions);
            this.setAllAtomMapping();
        }
        catch (CDKException e) {
            rmap = null;
        }
        return !this.getFirstAtomMapping().isEmpty();
    }

    protected IAtomContainerSet getUncommon(IAtomContainer mol, IAtomContainer mcss) throws CDKException {
        ArrayList<Integer> atomSerialsToDelete = new ArrayList<Integer>();
        List<List<CDKRMap>> matches = CDKMCS.getSubgraphAtomsMaps(mol, mcss, this.shouldMatchBonds, this.shouldMatchRings, this.matchAtomType);
        List<CDKRMap> mapList = matches.get(0);
        Iterator<CDKRMap> iterator = mapList.iterator();
        while (iterator.hasNext()) {
            CDKRMap o;
            CDKRMap rmap = o = iterator.next();
            atomSerialsToDelete.add(rmap.getId1());
        }
        ArrayList<IAtom> atomsToDelete = new ArrayList<IAtom>();
        for (Integer serial : atomSerialsToDelete) {
            atomsToDelete.add(mol.getAtom(serial));
        }
        for (IAtom atom : atomsToDelete) {
            mol.removeAtomAndConnectedElectronContainers(atom);
        }
        return ConnectivityChecker.partitionIntoMolecules(mol);
    }

    private synchronized void setAllMapping(List<Map<Integer, Integer>> solutions) {
        try {
            int counter = 0;
            for (Map<Integer, Integer> final_solution : solutions) {
                TreeMap<Integer, Integer> atomMappings = new TreeMap<Integer, Integer>();
                for (Map.Entry<Integer, Integer> Solutions : final_solution.entrySet()) {
                    int IIndex = Solutions.getKey();
                    int JIndex = Solutions.getValue();
                    if (this.rOnPFlag) {
                        atomMappings.put(IIndex, JIndex);
                        continue;
                    }
                    atomMappings.put(JIndex, IIndex);
                }
                if (this.allMCS.contains(atomMappings)) continue;
                this.allMCS.add(counter++, atomMappings);
            }
        }
        catch (Exception ex) {
            ex.getCause();
        }
    }

    private synchronized void setAllAtomMapping() {
        List<Map<Integer, Integer>> sol = this.allMCS;
        int counter = 0;
        for (Map<Integer, Integer> final_solution : sol) {
            AtomAtomMapping atomMappings = new AtomAtomMapping(this.source, this.target);
            for (Map.Entry<Integer, Integer> Solutions : final_solution.entrySet()) {
                int IIndex = Solutions.getKey();
                int JIndex = Solutions.getValue();
                IAtom sourceAtom = null;
                IAtom targetAtom = null;
                sourceAtom = this.source.getAtom(IIndex);
                targetAtom = this.target.getAtom(JIndex);
                atomMappings.put(sourceAtom, targetAtom);
            }
            this.allAtomMCS.add(counter++, atomMappings);
        }
    }

    @Override
    public List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    public AtomAtomMapping getFirstAtomMapping() {
        if (this.allAtomMCS.iterator().hasNext()) {
            return this.allAtomMCS.iterator().next();
        }
        return new AtomAtomMapping(this.source, this.target);
    }
}

