/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.single;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.smsd.tools.BondEnergies;

public class SingleMapping {
    private IAtomContainer source = null;
    private IAtomContainer target = null;
    private final Map<Integer, Double> connectedBondOrder = new TreeMap<Integer, Double>();

    protected synchronized List<Map<IAtom, IAtom>> getOverLaps(IAtomContainer source, IAtomContainer target) throws CDKException {
        ArrayList<Map<IAtom, IAtom>> mappings = new ArrayList<Map<IAtom, IAtom>>();
        this.source = source;
        this.target = target;
        if (source.getAtomCount() == 1 || source.getAtomCount() > 0 && source.getBondCount() == 0) {
            this.setSourceSingleAtomMap(mappings);
        }
        if (target.getAtomCount() == 1 || target.getAtomCount() > 0 && target.getBondCount() == 0) {
            this.setTargetSingleAtomMap(mappings);
        }
        return this.postFilter(mappings);
    }

    protected synchronized List<Map<IAtom, IAtom>> getOverLaps(IQueryAtomContainer source, IAtomContainer target) throws CDKException {
        ArrayList<Map<IAtom, IAtom>> mappings = new ArrayList<Map<IAtom, IAtom>>();
        this.source = source;
        this.target = target;
        if (source.getAtomCount() == 1 || source.getAtomCount() > 0 && source.getBondCount() == 0) {
            this.setSourceSingleAtomMap(mappings);
        }
        if (target.getAtomCount() == 1 || target.getAtomCount() > 0 && target.getBondCount() == 0) {
            this.setTargetSingleAtomMap(mappings);
        }
        return this.postFilter(mappings);
    }

    private synchronized void setSourceSingleAtomMap(List<Map<IAtom, IAtom>> mappings) throws CDKException {
        int counter = 0;
        BondEnergies be = BondEnergies.getInstance();
        for (IAtom sourceAtom : this.source.atoms()) {
            for (IAtom targetAtom : this.target.atoms()) {
                IBond.Order bondOrder;
                double totalOrder;
                List<IBond> Bonds;
                HashMap<IAtom, IAtom> mapAtoms = new HashMap<IAtom, IAtom>();
                if (sourceAtom instanceof IQueryAtom) {
                    if (!((IQueryAtom)sourceAtom).matches(targetAtom)) continue;
                    mapAtoms.put(sourceAtom, targetAtom);
                    Bonds = this.target.getConnectedBondsList(targetAtom);
                    totalOrder = 0.0;
                    for (IBond bond : Bonds) {
                        bondOrder = bond.getOrder();
                        if (bondOrder == null) continue;
                        totalOrder += (double)(bondOrder.numeric() + be.getEnergies(bond));
                    }
                    if (!Objects.equals(targetAtom.getFormalCharge(), sourceAtom.getFormalCharge())) {
                        totalOrder += 0.5;
                    }
                    this.connectedBondOrder.put(counter, totalOrder);
                    mappings.add(counter++, mapAtoms);
                    continue;
                }
                if (!sourceAtom.getSymbol().equalsIgnoreCase(targetAtom.getSymbol())) continue;
                mapAtoms.put(sourceAtom, targetAtom);
                Bonds = this.target.getConnectedBondsList(targetAtom);
                totalOrder = 0.0;
                for (IBond bond : Bonds) {
                    bondOrder = bond.getOrder();
                    if (bondOrder == null) continue;
                    totalOrder += (double)(bondOrder.numeric() + be.getEnergies(bond));
                }
                if (!Objects.equals(targetAtom.getFormalCharge(), sourceAtom.getFormalCharge())) {
                    totalOrder += 0.5;
                }
                this.connectedBondOrder.put(counter, totalOrder);
                mappings.add(counter, mapAtoms);
                ++counter;
            }
        }
    }

    private synchronized void setTargetSingleAtomMap(List<Map<IAtom, IAtom>> mappings) throws CDKException {
        int counter = 0;
        BondEnergies be = BondEnergies.getInstance();
        for (IAtom targetAtom : this.target.atoms()) {
            for (IAtom sourceAtoms : this.source.atoms()) {
                IBond.Order bondOrder;
                double totalOrder;
                List<IBond> Bonds;
                HashMap<IAtom, IAtom> mapAtoms = new HashMap<IAtom, IAtom>();
                if (targetAtom instanceof IQueryAtom) {
                    if (!((IQueryAtom)targetAtom).matches(sourceAtoms) || !targetAtom.getSymbol().equalsIgnoreCase(sourceAtoms.getSymbol())) continue;
                    mapAtoms.put(sourceAtoms, targetAtom);
                    Bonds = this.source.getConnectedBondsList(sourceAtoms);
                    totalOrder = 0.0;
                    for (IBond bond : Bonds) {
                        bondOrder = bond.getOrder();
                        if (bondOrder == null) continue;
                        totalOrder += (double)(bondOrder.numeric() + be.getEnergies(bond));
                    }
                    if (!Objects.equals(sourceAtoms.getFormalCharge(), targetAtom.getFormalCharge())) {
                        totalOrder += 0.5;
                    }
                    this.connectedBondOrder.put(counter, totalOrder);
                    mappings.add(counter, mapAtoms);
                    ++counter;
                    continue;
                }
                if (!targetAtom.getSymbol().equalsIgnoreCase(sourceAtoms.getSymbol())) continue;
                mapAtoms.put(sourceAtoms, targetAtom);
                Bonds = this.source.getConnectedBondsList(sourceAtoms);
                totalOrder = 0.0;
                for (IBond bond : Bonds) {
                    bondOrder = bond.getOrder();
                    if (bondOrder == null) continue;
                    totalOrder += (double)(bondOrder.numeric() + be.getEnergies(bond));
                }
                if (!Objects.equals(sourceAtoms.getFormalCharge(), targetAtom.getFormalCharge())) {
                    totalOrder += 0.5;
                }
                this.connectedBondOrder.put(counter, totalOrder);
                mappings.add(counter, mapAtoms);
                ++counter;
            }
        }
    }

    private synchronized List<Map<IAtom, IAtom>> postFilter(List<Map<IAtom, IAtom>> mappings) {
        ArrayList<Map<IAtom, IAtom>> sortedMap = new ArrayList<Map<IAtom, IAtom>>();
        if (mappings.isEmpty()) {
            return sortedMap;
        }
        Map<Integer, Double> sortedMapByValue = this.sortByValue(this.connectedBondOrder);
        for (Integer key : sortedMapByValue.keySet()) {
            Map<IAtom, IAtom> mapToBeMoved = mappings.get(key);
            sortedMap.add(mapToBeMoved);
        }
        return sortedMap;
    }

    private <K, V> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object object1, Object object2) {
                return ((Comparable)((Map.Entry)object1).getValue()).compareTo(((Map.Entry)object2).getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

