/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.single;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.single.SingleMapping;
import org.openscience.smsd.interfaces.IResults;

public class SingleMappingHandler
implements IResults {
    private final ILoggingTool Logger = LoggingToolFactory.createLoggingTool(SingleMappingHandler.class);
    private List<AtomAtomMapping> allAtomMCS = new ArrayList<AtomAtomMapping>();
    private final IAtomContainer source;
    private final IAtomContainer target;
    private final boolean shouldMatchRings;

    public SingleMappingHandler(IAtomContainer source, IAtomContainer target, boolean shouldMatchRings) {
        this.source = source;
        this.target = target;
        this.shouldMatchRings = shouldMatchRings;
        this.searchMCS();
    }

    public SingleMappingHandler(IQueryAtomContainer source, IAtomContainer target) {
        this.source = source;
        this.target = target;
        this.shouldMatchRings = true;
        this.searchMCS();
    }

    private synchronized void searchMCS() {
        SingleMapping singleMapping = new SingleMapping();
        List<Map<IAtom, IAtom>> mappings = null;
        try {
            if (this.target instanceof IQueryAtomContainer) {
                throw new CDKException("Target can't be IQueryAtomContainer");
            }
            mappings = !(this.source instanceof IQueryAtomContainer) ? singleMapping.getOverLaps(this.source, this.target) : singleMapping.getOverLaps((IQueryAtomContainer)this.source, this.target);
        }
        catch (CDKException ex) {
            this.Logger.error(Level.SEVERE, null, ex);
        }
        this.setAllAtomMapping(mappings);
    }

    private synchronized void setAllAtomMapping(List<Map<IAtom, IAtom>> mappings) {
        try {
            int counter = 0;
            for (Map<IAtom, IAtom> solution : mappings) {
                AtomAtomMapping atomMappings = new AtomAtomMapping(this.source, this.target);
                for (Map.Entry<IAtom, IAtom> map : solution.entrySet()) {
                    IAtom sourceAtom = map.getKey();
                    IAtom targetAtom = map.getValue();
                    atomMappings.put(sourceAtom, targetAtom);
                }
                this.allAtomMCS.add(counter, atomMappings);
                ++counter;
            }
        }
        catch (Exception I) {
            I.getCause();
        }
    }

    @Override
    public synchronized List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    public synchronized AtomAtomMapping getFirstAtomMapping() {
        if (this.allAtomMCS.iterator().hasNext()) {
            return this.allAtomMCS.iterator().next();
        }
        return new AtomAtomMapping(this.source, this.target);
    }
}

