/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.vflib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.mcgregor.McGregor;
import org.openscience.smsd.algorithm.vflib.Map2ValueComparator;
import org.openscience.smsd.algorithm.vflib.SortOrder;

public class BaseMCS {
    protected int countR;
    protected int countP;
    protected final IAtomContainer source;
    protected final IAtomContainer target;
    private final boolean shouldMatchRings;
    private final boolean matchBonds;
    private final boolean matchAtomType;
    protected final List<Map<IAtom, IAtom>> vfLibSolutions;
    final List<Map<Integer, Integer>> allLocalMCS;
    final List<AtomAtomMapping> allLocalAtomAtomMapping = new ArrayList<AtomAtomMapping>();
    private static final ILoggingTool Logger = LoggingToolFactory.createLoggingTool(BaseMCS.class);
    private final boolean DEBUG = false;

    BaseMCS(IAtomContainer source, IAtomContainer target, boolean matchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        this.allLocalMCS = new ArrayList<Map<Integer, Integer>>();
        this.shouldMatchRings = shouldMatchRings;
        this.matchBonds = matchBonds;
        this.matchAtomType = matchAtomType;
        this.vfLibSolutions = new ArrayList<Map<IAtom, IAtom>>();
        this.source = source;
        this.target = target;
    }

    BaseMCS(IQueryAtomContainer source, IAtomContainer target) {
        this.allLocalMCS = new ArrayList<Map<Integer, Integer>>();
        this.shouldMatchRings = true;
        this.matchBonds = true;
        this.matchAtomType = true;
        this.vfLibSolutions = new ArrayList<Map<IAtom, IAtom>>();
        this.source = source;
        this.target = target;
    }

    protected synchronized boolean hasClique(Map<Integer, Integer> cliqueMap, List<Map<Integer, Integer>> mapGlobal) {
        for (Map<Integer, Integer> storedMap : mapGlobal) {
            if (cliqueMap.size() < storedMap.size()) {
                return true;
            }
            if (!cliqueMap.equals(storedMap)) continue;
            return true;
        }
        return false;
    }

    protected synchronized boolean isCliquePresent(Map<Integer, Integer> cliqueMap, List<Map<Integer, Integer>> mapGlobal) {
        return mapGlobal.stream().anyMatch(storedMap -> cliqueMap.equals(storedMap));
    }

    protected synchronized void extendCliquesWithMcGregor(List<Map<Integer, Integer>> refinedMCSSeeds) throws CDKException, IOException {
        List<List<Integer>> mappings = new ArrayList<List<Integer>>();
        boolean ROPFlag = true;
        for (Map<Integer, Integer> firstPassMappings : refinedMCSSeeds) {
            McGregor mgit;
            TreeMap<Integer, Integer> extendMapping = new TreeMap<Integer, Integer>(firstPassMappings);
            if (this.source instanceof IQueryAtomContainer) {
                mgit = new McGregor((IQueryAtomContainer)this.source, this.target, mappings, this.isBondMatchFlag(), this.isMatchRings(), this.isMatchAtomType());
                mgit.startMcGregorIteration((IQueryAtomContainer)this.source, mgit.getMCSSize(), extendMapping);
            } else if (this.countR > this.countP) {
                mgit = new McGregor(this.source, this.target, mappings, this.isBondMatchFlag(), this.isMatchRings(), this.isMatchAtomType());
                mgit.startMcGregorIteration(this.source, mgit.getMCSSize(), extendMapping);
            } else {
                extendMapping.clear();
                mgit = new McGregor(this.target, this.source, mappings, this.isBondMatchFlag(), this.isMatchRings(), this.isMatchAtomType());
                ROPFlag = false;
                firstPassMappings.entrySet().stream().forEach(map -> extendMapping.put((Integer)map.getValue(), (Integer)map.getKey()));
                mgit.startMcGregorIteration(this.target, mgit.getMCSSize(), extendMapping);
            }
            mappings = mgit.getMappings();
        }
        this.setMcGregorMappings(ROPFlag, mappings);
    }

    protected synchronized void setVFMappings(boolean RONP) {
        Collections.sort(this.vfLibSolutions, new Map2ValueComparator(SortOrder.DESCENDING));
        for (Map<IAtom, IAtom> solution : this.vfLibSolutions) {
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.source, this.target);
            TreeMap<Integer, Integer> indexindexMapping = new TreeMap<Integer, Integer>();
            solution.entrySet().stream().forEach(mapping -> {
                Integer tIndex;
                Integer qIndex;
                IAtom tAtom;
                IAtom qAtom;
                if (RONP) {
                    qAtom = (IAtom)mapping.getKey();
                    tAtom = (IAtom)mapping.getValue();
                    qIndex = this.source.getAtomNumber(qAtom);
                    tIndex = this.target.getAtomNumber(tAtom);
                } else {
                    tAtom = (IAtom)mapping.getKey();
                    qAtom = (IAtom)mapping.getValue();
                    qIndex = this.source.getAtomNumber(qAtom);
                    tIndex = this.target.getAtomNumber(tAtom);
                }
                if (qIndex != -1 && tIndex != -1) {
                    atomatomMapping.put(qAtom, tAtom);
                    indexindexMapping.put(qIndex, tIndex);
                } else {
                    try {
                        throw new CDKException("Atom index pointing to -1");
                    }
                    catch (CDKException ex) {
                        Logger.error(Level.SEVERE, null, ex);
                    }
                }
            });
            if (indexindexMapping.isEmpty() || this.hasClique(indexindexMapping, this.getLocalMCSSolution())) continue;
            this.getLocalAtomMCSSolution().add(atomatomMapping);
            this.getLocalMCSSolution().add(indexindexMapping);
        }
    }

    private synchronized void setMcGregorMappings(boolean RONP, List<List<Integer>> mappings) throws CDKException {
        int counter = 0;
        int solSize = 0;
        this.getLocalAtomMCSSolution().clear();
        this.getLocalMCSSolution().clear();
        for (List<Integer> mapping : mappings) {
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.source, this.target);
            TreeMap<Integer, Integer> indexindexMapping = new TreeMap<Integer, Integer>();
            for (int index = 0; index < mapping.size(); index += 2) {
                int tIndex;
                int qIndex;
                IAtom tAtom;
                IAtom qAtom;
                if (RONP) {
                    qAtom = this.source.getAtom(mapping.get(index));
                    tAtom = this.target.getAtom(mapping.get(index + 1));
                    qIndex = mapping.get(index);
                    tIndex = mapping.get(index + 1);
                } else {
                    qAtom = this.source.getAtom(mapping.get(index + 1));
                    tAtom = this.target.getAtom(mapping.get(index));
                    qIndex = mapping.get(index + 1);
                    tIndex = mapping.get(index);
                }
                if (qIndex == -1 || tIndex == -1) {
                    throw new CDKException("Atom index pointing to NULL");
                }
                atomatomMapping.put(qAtom, tAtom);
                indexindexMapping.put(qIndex, tIndex);
            }
            if (indexindexMapping.size() > solSize) {
                solSize = indexindexMapping.size();
                this.getLocalAtomMCSSolution().clear();
                this.getLocalMCSSolution().clear();
                counter = 0;
            }
            if (indexindexMapping.isEmpty() || this.hasClique(indexindexMapping, this.getLocalMCSSolution()) || indexindexMapping.size() != solSize) continue;
            this.getLocalAtomMCSSolution().add(counter, atomatomMapping);
            this.getLocalMCSSolution().add(counter, indexindexMapping);
            ++counter;
        }
    }

    protected synchronized IAtomContainer getReactantMol() {
        return this.source;
    }

    protected synchronized IAtomContainer getProductMol() {
        return this.target;
    }

    protected boolean isMatchRings() {
        return this.shouldMatchRings;
    }

    protected synchronized boolean isBondMatchFlag() {
        return this.matchBonds;
    }

    private synchronized List<Map<Integer, Integer>> getLocalMCSSolution() {
        return Collections.synchronizedList(this.allLocalMCS);
    }

    private synchronized List<AtomAtomMapping> getLocalAtomMCSSolution() {
        return Collections.synchronizedList(this.allLocalAtomAtomMapping);
    }

    protected synchronized boolean isExtensionRequired(List<Map<Integer, Integer>> mcsSeeds) {
        int maxSize = 0;
        for (Map<Integer, Integer> map : mcsSeeds) {
            if (map.size() <= maxSize) continue;
            maxSize = map.size();
        }
        return this.source.getAtomCount() > maxSize && this.target.getAtomCount() > maxSize;
    }

    protected synchronized boolean isExtensionRequired() {
        int commonAtomCount = this.checkCommonAtomCount(this.getReactantMol(), this.getProductMol());
        int maxSize = 0;
        for (Map<Integer, Integer> map : this.allLocalMCS) {
            if (map.size() <= maxSize) continue;
            maxSize = map.size();
        }
        return commonAtomCount > maxSize;
    }

    private synchronized int checkCommonAtomCount(IAtomContainer reactantMolecule, IAtomContainer productMolecule) {
        ArrayList<String> atoms = new ArrayList<String>();
        for (int i = 0; i < reactantMolecule.getAtomCount(); ++i) {
            atoms.add(reactantMolecule.getAtom(i).getSymbol());
        }
        int common = 0;
        for (int i = 0; i < productMolecule.getAtomCount(); ++i) {
            String symbol = productMolecule.getAtom(i).getSymbol();
            if (!atoms.contains(symbol)) continue;
            atoms.remove(symbol);
            ++common;
        }
        return common;
    }

    public boolean isMatchAtomType() {
        return this.matchAtomType;
    }
}

