/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.vflib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.vflib.BaseMCS;
import org.openscience.smsd.algorithm.vflib.MCSSeedGenerator;
import org.openscience.smsd.algorithm.vflib.Map1ValueComparator;
import org.openscience.smsd.algorithm.vflib.SortOrder;
import org.openscience.smsd.algorithm.vflib.vf2.DefaultAtomMatcher;
import org.openscience.smsd.algorithm.vflib.vf2.DefaultBondMatcher;
import org.openscience.smsd.algorithm.vflib.vf2.mcs.VFSeed;
import org.openscience.smsd.algorithm.vflib.vf2.sub.Pattern;
import org.openscience.smsd.algorithm.vflib.vf2.sub.VF;
import org.openscience.smsd.interfaces.Algorithm;
import org.openscience.smsd.interfaces.IResults;

public final class VF2MCS
extends BaseMCS
implements IResults {
    private final List<AtomAtomMapping> allAtomMCS;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(VF2MCS.class);
    private final boolean DEBUG = false;

    public VF2MCS(IAtomContainer source, IAtomContainer target, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        super(source, target, shouldMatchBonds, shouldMatchRings, matchAtomType);
        int maxVFMappingSize;
        boolean timeoutVF = this.searchVFMappings();
        int n = maxVFMappingSize = this.allLocalMCS.iterator().hasNext() ? ((Map)this.allLocalMCS.iterator().next()).size() : 0;
        if (timeoutVF || maxVFMappingSize != source.getAtomCount() && maxVFMappingSize != target.getAtomCount()) {
            ArrayList<Map> mcsVFSeeds = new ArrayList<Map>();
            int counter = 0;
            for (Map vfMapping : this.allLocalMCS) {
                mcsVFSeeds.add(counter, vfMapping);
                ++counter;
            }
            this.allLocalMCS.clear();
            this.allLocalAtomAtomMapping.clear();
            long startTimeSeeds = System.nanoTime();
            ExecutorService executor = Executors.newSingleThreadExecutor();
            ExecutorCompletionService<List<AtomAtomMapping>> cs = new ExecutorCompletionService<List<AtomAtomMapping>>(executor);
            IAtomContainer targetClone = null;
            try {
                DefaultBondMatcher defaultBondMatcher = new DefaultBondMatcher(shouldMatchBonds, shouldMatchRings, matchAtomType);
                DefaultAtomMatcher defaultAtomMatcher = new DefaultAtomMatcher(shouldMatchRings, matchAtomType);
                targetClone = target.clone();
                HashSet<IBond> bondRemovedT = new HashSet<IBond>();
                for (IBond b1 : targetClone.bonds()) {
                    IAtom a1 = b1.getAtom(0);
                    IAtom a2 = b1.getAtom(1);
                    boolean flag = false;
                    for (IBond b2 : source.bonds()) {
                        IAtom a3 = b2.getAtom(0);
                        IAtom a4 = b2.getAtom(1);
                        boolean matchesBond = defaultBondMatcher.matches(b1, b2);
                        boolean matchesAtom0 = defaultAtomMatcher.matches(a1, a3);
                        boolean matchesAtom1 = defaultAtomMatcher.matches(a2, a4);
                        boolean matchesAtom3 = defaultAtomMatcher.matches(a1, a4);
                        boolean matchesAtom4 = defaultAtomMatcher.matches(a2, a3);
                        if (matchesBond && matchesAtom0 && matchesAtom1) {
                            flag = true;
                        } else if (matchesBond && matchesAtom3 && matchesAtom4) {
                            flag = true;
                        } else if (matchesAtom0 && matchesAtom1) {
                            flag = true;
                        } else if (matchesAtom3 && matchesAtom4) {
                            flag = true;
                        }
                        if (!flag) continue;
                        break;
                    }
                    if (flag) continue;
                    bondRemovedT.add(b1);
                }
                for (IBond b : bondRemovedT) {
                    targetClone.removeBond(b);
                }
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(VF2MCS.class.getName()).log(Level.SEVERE, null, ex);
            }
            int jobCounter = 0;
            if (targetClone != null && targetClone.getBondCount() > 0) {
                MCSSeedGenerator mcsSeedGeneratorUIT = new MCSSeedGenerator(source, targetClone, shouldMatchBonds, shouldMatchRings, matchAtomType, Algorithm.CDKMCS);
                cs.submit(mcsSeedGeneratorUIT);
                ++jobCounter;
            }
            MCSSeedGenerator mcsSeedGeneratorKoch = new MCSSeedGenerator(source, targetClone, shouldMatchBonds, shouldMatchRings, matchAtomType, Algorithm.MCSPlus);
            cs.submit(mcsSeedGeneratorKoch);
            ++jobCounter;
            HashSet mcsSeeds = new HashSet();
            for (int i = 0; i < jobCounter; ++i) {
                try {
                    List chosen = (List)cs.take().get();
                    chosen.stream().map(mapping -> {
                        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
                        map.putAll(mapping.getMappingsByIndex());
                        return map;
                    }).forEach(map -> mcsSeeds.add(map));
                    continue;
                }
                catch (InterruptedException | ExecutionException ex) {
                    logger.error(Level.SEVERE, null, ex);
                }
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
            System.gc();
            long stopTimeSeeds = System.nanoTime();
            int solutionSize = 0;
            counter = 0;
            ArrayList<Map<Integer, Integer>> cleanedMCSSeeds = new ArrayList<Map<Integer, Integer>>();
            if (!mcsSeeds.isEmpty()) {
                for (Map map2 : mcsSeeds) {
                    if (map2.size() > solutionSize) {
                        solutionSize = map2.size();
                        cleanedMCSSeeds.clear();
                        counter = 0;
                    }
                    if (map2.isEmpty() || map2.size() != solutionSize || super.isCliquePresent(map2, cleanedMCSSeeds)) continue;
                    cleanedMCSSeeds.add(counter, map2);
                    ++counter;
                }
            }
            mcsVFSeeds.stream().filter(map -> !map.isEmpty() && !super.isCliquePresent((Map<Integer, Integer>)map, (List<Map<Integer, Integer>>)cleanedMCSSeeds)).forEach(_item -> cleanedMCSSeeds.addAll(mcsVFSeeds));
            Collections.sort(cleanedMCSSeeds, new Map1ValueComparator(SortOrder.DESCENDING));
            try {
                super.extendCliquesWithMcGregor(cleanedMCSSeeds);
            }
            catch (IOException | CDKException ex) {
                logger.error(Level.SEVERE, null, ex);
            }
            mcsSeeds.clear();
            cleanedMCSSeeds.clear();
            solutionSize = 0;
            counter = 0;
            this.allAtomMCS = new ArrayList<AtomAtomMapping>();
            if (!this.allLocalAtomAtomMapping.isEmpty()) {
                for (AtomAtomMapping atomMCSMap : this.allLocalAtomAtomMapping) {
                    if (atomMCSMap.getCount() > solutionSize) {
                        solutionSize = atomMCSMap.getCount();
                        this.allAtomMCS.clear();
                        counter = 0;
                    }
                    if (atomMCSMap.isEmpty() || atomMCSMap.getCount() != solutionSize) continue;
                    this.allAtomMCS.add(counter, atomMCSMap);
                    ++counter;
                }
            }
            this.allLocalMCS.clear();
            this.allLocalAtomAtomMapping.clear();
        } else {
            int solutionSize = 0;
            int counter = 0;
            this.allAtomMCS = new ArrayList<AtomAtomMapping>();
            if (!this.allLocalAtomAtomMapping.isEmpty()) {
                for (AtomAtomMapping atomMCSMap : this.allLocalAtomAtomMapping) {
                    if (atomMCSMap.getCount() > solutionSize) {
                        solutionSize = atomMCSMap.getCount();
                        this.allAtomMCS.clear();
                        counter = 0;
                    }
                    if (atomMCSMap.isEmpty() || atomMCSMap.getCount() != solutionSize) continue;
                    this.allAtomMCS.add(counter, atomMCSMap);
                    ++counter;
                }
            }
            this.allLocalMCS.clear();
            this.allLocalAtomAtomMapping.clear();
        }
    }

    public VF2MCS(IQueryAtomContainer source, IAtomContainer target) {
        super(source, target, true, true, true);
        boolean timeoutVF = this.searchVFMappings();
        if (!timeoutVF) {
            ArrayList<Map> mcsVFSeeds = new ArrayList<Map>();
            int counter = 0;
            for (Map vfMapping : this.allLocalMCS) {
                mcsVFSeeds.add(counter, vfMapping);
                ++counter;
            }
            this.allLocalMCS.clear();
            this.allLocalAtomAtomMapping.clear();
            long startTimeSeeds = System.nanoTime();
            ExecutorService executor = Executors.newSingleThreadExecutor();
            ExecutorCompletionService<List<AtomAtomMapping>> cs = new ExecutorCompletionService<List<AtomAtomMapping>>(executor);
            IAtomContainer targetClone = null;
            try {
                targetClone = target.clone();
                HashSet<IBond> bondRemovedT = new HashSet<IBond>();
                for (IBond b1 : source.bonds()) {
                    IQueryBond bond = (IQueryBond)b1;
                    IQueryAtom a1 = (IQueryAtom)b1.getAtom(0);
                    IQueryAtom a2 = (IQueryAtom)b1.getAtom(1);
                    for (IBond b2 : targetClone.bonds()) {
                        boolean matches = bond.matches(b2);
                        if (a1.matches(b2.getAtom(0)) && a2.matches(b2.getAtom(1)) && !matches) {
                            bondRemovedT.add(b2);
                            continue;
                        }
                        if (!a2.matches(b2.getAtom(0)) || !a1.matches(b2.getAtom(1)) || matches) continue;
                        bondRemovedT.add(b2);
                    }
                }
                for (IBond b : bondRemovedT) {
                    targetClone.removeBond(b);
                }
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(VF2MCS.class.getName()).log(Level.SEVERE, null, ex);
            }
            MCSSeedGenerator mcsSeedGeneratorUIT = new MCSSeedGenerator(source, targetClone, Algorithm.CDKMCS);
            MCSSeedGenerator mcsSeedGeneratorKoch = new MCSSeedGenerator(source, targetClone, Algorithm.MCSPlus);
            int jobCounter = 0;
            cs.submit(mcsSeedGeneratorUIT);
            ++jobCounter;
            cs.submit(mcsSeedGeneratorKoch);
            ++jobCounter;
            HashSet mcsSeeds = new HashSet();
            for (int i = 0; i < jobCounter; ++i) {
                try {
                    List chosen = (List)cs.take().get();
                    chosen.stream().map(mapping -> {
                        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
                        map.putAll(mapping.getMappingsByIndex());
                        return map;
                    }).forEach(map -> mcsSeeds.add(map));
                    continue;
                }
                catch (InterruptedException | ExecutionException ex) {
                    logger.error(Level.SEVERE, null, ex);
                }
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
            System.gc();
            long stopTimeSeeds = System.nanoTime();
            int solutionSize = 0;
            counter = 0;
            ArrayList<Map<Integer, Integer>> cleanedMCSSeeds = new ArrayList<Map<Integer, Integer>>();
            if (!mcsSeeds.isEmpty()) {
                for (Map map2 : mcsSeeds) {
                    if (map2.size() > solutionSize) {
                        solutionSize = map2.size();
                        cleanedMCSSeeds.clear();
                        counter = 0;
                    }
                    if (map2.isEmpty() || map2.size() != solutionSize || super.hasClique(map2, cleanedMCSSeeds)) continue;
                    cleanedMCSSeeds.add(counter, map2);
                    ++counter;
                }
            }
            for (Map map2 : mcsVFSeeds) {
                if (map2.isEmpty() || map2.size() < solutionSize || super.hasClique(map2, cleanedMCSSeeds)) continue;
                cleanedMCSSeeds.add(counter, map2);
                ++counter;
            }
            Collections.sort(cleanedMCSSeeds, new Map1ValueComparator(SortOrder.DESCENDING));
            try {
                super.extendCliquesWithMcGregor(cleanedMCSSeeds);
            }
            catch (IOException | CDKException ex) {
                logger.error(Level.SEVERE, null, ex);
            }
            mcsSeeds.clear();
            cleanedMCSSeeds.clear();
            solutionSize = 0;
            counter = 0;
            this.allAtomMCS = new ArrayList<AtomAtomMapping>();
            if (!this.allLocalAtomAtomMapping.isEmpty()) {
                for (AtomAtomMapping atomMCSMap : this.allLocalAtomAtomMapping) {
                    if (atomMCSMap.getCount() > solutionSize) {
                        solutionSize = atomMCSMap.getCount();
                        this.allAtomMCS.clear();
                        counter = 0;
                    }
                    if (atomMCSMap.isEmpty() || atomMCSMap.getCount() != solutionSize) continue;
                    this.allAtomMCS.add(counter, atomMCSMap);
                    ++counter;
                }
            }
            this.allLocalMCS.clear();
            this.allLocalAtomAtomMapping.clear();
        } else {
            int solSize = 0;
            int counter = 0;
            this.allAtomMCS = new ArrayList<AtomAtomMapping>();
            if (!this.allLocalAtomAtomMapping.isEmpty()) {
                for (AtomAtomMapping atomMCSMap : this.allLocalAtomAtomMapping) {
                    if (atomMCSMap.getCount() > solSize) {
                        solSize = atomMCSMap.getCount();
                        this.allAtomMCS.clear();
                        counter = 0;
                    }
                    if (atomMCSMap.isEmpty() || atomMCSMap.getCount() != solSize) continue;
                    this.allAtomMCS.add(counter, atomMCSMap);
                    ++counter;
                }
            }
        }
    }

    private synchronized boolean searchVFMappings() {
        Object mapper = null;
        if (!(this.source instanceof IQueryAtomContainer) && !(this.target instanceof IQueryAtomContainer)) {
            this.countR = this.getReactantMol().getAtomCount();
            this.countP = this.getProductMol().getAtomCount();
        }
        if (this.source instanceof IQueryAtomContainer) {
            Pattern findSeeds = VF.findSubstructure((IQueryAtomContainer)this.source);
            List<Map<IAtom, IAtom>> maps = findSeeds.matchAll(this.getProductMol());
            if (maps.isEmpty()) {
                findSeeds = VFSeed.findSeeds((IQueryAtomContainer)this.source);
                maps = findSeeds.matchAll(this.getProductMol());
            }
            if (maps != null && !maps.isEmpty()) {
                this.vfLibSolutions.addAll(maps);
            }
            this.setVFMappings(true);
        } else if (this.countR < this.countP) {
            Pattern findSeeds = VF.findSubstructure(this.source, true, this.isMatchRings(), this.isMatchAtomType());
            List<Map<IAtom, IAtom>> maps = findSeeds.matchAll(this.getProductMol());
            if (maps.isEmpty()) {
                findSeeds = VFSeed.findSeeds(this.source, true, this.isMatchRings(), this.isMatchAtomType());
                maps = findSeeds.matchAll(this.getProductMol());
            }
            if (maps != null && !maps.isEmpty()) {
                this.vfLibSolutions.addAll(maps);
            }
            this.setVFMappings(true);
        } else if (this.countR == this.countP) {
            Pattern findSeeds = VF.findIdentical(this.source, true, this.isMatchRings(), this.isMatchAtomType());
            List<Map<IAtom, IAtom>> maps = findSeeds.matchAll(this.getProductMol());
            if (maps.isEmpty()) {
                findSeeds = VFSeed.findSeeds(this.source, true, this.isMatchRings(), this.isMatchAtomType());
                maps = findSeeds.matchAll(this.getProductMol());
            }
            if (maps != null && !maps.isEmpty()) {
                this.vfLibSolutions.addAll(maps);
            }
            this.setVFMappings(true);
        } else {
            Pattern findSeeds = VF.findSubstructure(this.target, true, this.isMatchRings(), this.isMatchAtomType());
            List<Map<IAtom, IAtom>> maps = findSeeds.matchAll(this.getReactantMol());
            if (maps.isEmpty()) {
                findSeeds = VFSeed.findSeeds(this.target, true, this.isMatchRings(), this.isMatchAtomType());
                maps = findSeeds.matchAll(this.getReactantMol());
            }
            if (maps != null && !maps.isEmpty()) {
                this.vfLibSolutions.addAll(maps);
            }
            this.setVFMappings(false);
        }
        return mapper != null;
    }

    public VF2MCS(IQueryAtomContainer source, IQueryAtomContainer target) {
        this(source, target, true, true, true);
    }

    @Override
    public synchronized List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    public synchronized AtomAtomMapping getFirstAtomMapping() {
        if (this.allAtomMCS.iterator().hasNext()) {
            return this.allAtomMCS.iterator().next();
        }
        return new AtomAtomMapping(this.getReactantMol(), this.getProductMol());
    }
}

