/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.vflib.vf2;

import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.smsd.algorithm.vflib.vf2.AtomMatcher;

public final class DefaultAtomMatcher
implements AtomMatcher {
    static final long serialVersionUID = -7861469841127327812L;
    private final boolean shouldMatchRings;
    private final boolean atomTypeMatcher;

    public DefaultAtomMatcher(boolean shouldMatchRings, boolean atomTypeMatcher) {
        this.shouldMatchRings = shouldMatchRings;
        this.atomTypeMatcher = atomTypeMatcher;
    }

    private boolean matchSymbol(IAtom qAtom, IAtom atom) {
        if (qAtom == null) {
            return false;
        }
        return qAtom.getSymbol().equals(atom.getSymbol());
    }

    @Override
    public boolean matches(IAtom queryAtom, IAtom targetAtom) {
        if (targetAtom instanceof IQueryAtom) {
            return ((IQueryAtom)targetAtom).matches(queryAtom);
        }
        if (queryAtom != null && queryAtom instanceof IQueryAtom) {
            return ((IQueryAtom)queryAtom).matches(targetAtom);
        }
        if (!this.matchSymbol(queryAtom, targetAtom)) {
            return false;
        }
        if (this.isMatchRings() && this.isRingAtom(queryAtom) && !this.isRingAtom(targetAtom)) {
            return false;
        }
        if (this.isMatchRings() && !this.isRingAtom(queryAtom) && this.isRingAtom(targetAtom)) {
            return false;
        }
        if (this.isMatchRings() && this.isRingAtom(queryAtom) && this.isRingAtom(targetAtom) && !this.isRingSizeMatch(queryAtom, targetAtom)) {
            return false;
        }
        return !this.isAtomTypeMatcher() || this.matchAtomType(queryAtom, targetAtom) || !this.isAliphaticAtom(queryAtom) || !this.isAliphaticAtom(targetAtom);
    }

    private boolean isRingSizeMatch(IAtom qAtom, IAtom atom) {
        List ringsizesQ = (List)qAtom.getProperty("cdk:RingSizes");
        List ringsizesT = (List)atom.getProperty("cdk:RingSizes");
        if (ringsizesQ != null && ringsizesT != null) {
            Iterator iterator = ringsizesQ.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (!ringsizesT.contains(i)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAliphaticAtom(IAtom atom) {
        return atom.getFlag(8);
    }

    private boolean isRingAtom(IAtom atom) {
        return atom.getFlag(2);
    }

    public boolean isMatchRings() {
        return this.shouldMatchRings;
    }

    private boolean matchAtomType(IAtom qAtom, IAtom targetAtom) {
        String rAtom = qAtom.getAtomTypeName() == null ? qAtom.getSymbol() : qAtom.getAtomTypeName();
        String tAtom = targetAtom.getAtomTypeName() == null ? targetAtom.getSymbol() : targetAtom.getAtomTypeName();
        return rAtom.equals(tAtom);
    }

    public boolean isAtomTypeMatcher() {
        return this.atomTypeMatcher;
    }
}

