/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.vflib.vf2;

import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.smsd.algorithm.vflib.vf2.BondMatcher;

public final class DefaultBondMatcher
implements BondMatcher {
    static final long serialVersionUID = -7861469841127328812L;
    private final boolean shouldMatchBonds;
    private final boolean matchAtomTypes;
    private final boolean shouldMatchRings;

    public DefaultBondMatcher() {
        this.shouldMatchBonds = false;
        this.matchAtomTypes = false;
        this.shouldMatchRings = false;
    }

    public DefaultBondMatcher(boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomTypes) {
        this.shouldMatchBonds = shouldMatchBonds;
        this.shouldMatchRings = shouldMatchRings;
        this.matchAtomTypes = matchAtomTypes;
    }

    @Override
    public boolean matches(IBond queryBond, IBond targetBond) {
        if (queryBond != null && queryBond instanceof IQueryBond) {
            return ((IQueryBond)queryBond).matches(targetBond);
        }
        if (queryBond != null && targetBond != null && this.isBondMatchFlag() && this.isBondTypeMatch(queryBond, targetBond)) {
            return true;
        }
        if (queryBond != null && targetBond != null && !this.isBondMatchFlag() && this.isShouldMatchRings()) {
            if (queryBond.getFlag(32) && targetBond.getFlag(32)) {
                return true;
            }
            if (!queryBond.getFlag(32) && !targetBond.getFlag(32)) {
                return true;
            }
        } else if (queryBond != null && targetBond != null && !this.isBondMatchFlag() && !this.isShouldMatchRings()) {
            return true;
        }
        return false;
    }

    private boolean isBondTypeMatch(IBond queryBond, IBond targetBond) {
        if (queryBond.getFlag(32) == targetBond.getFlag(32) && queryBond.getOrder().equals((Object)targetBond.getOrder())) {
            return true;
        }
        if (queryBond.getFlag(32) && targetBond.getFlag(32)) {
            return true;
        }
        return !this.matchAtomTypes && queryBond.getFlag(2) && targetBond.getFlag(2) && (queryBond.getOrder() == IBond.Order.UNSET || targetBond.getOrder() == IBond.Order.UNSET);
    }

    public boolean isBondMatchFlag() {
        return this.shouldMatchBonds;
    }

    public boolean isShouldMatchRings() {
        return this.shouldMatchRings;
    }
}

