/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.vflib.vf2.mcs;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.openscience.smsd.algorithm.vflib.vf2.mcs.State;

final class StateStream
implements Iterator<Collection<int[]>> {
    private final State state;
    private final CandidateStack stack;
    private int n = 0;
    private int m = -1;
    private Collection<int[]> next;

    StateStream(State state) {
        this.state = state;
        this.stack = new CandidateStack(state.maxQueryCandidate());
        this.next = state.maxQueryCandidate() == 0 || state.maxTargetCandidate() == 0 ? null : this.findNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Collection<int[]> next() {
        Collection<int[]> ret = this.next;
        this.next = this.findNext();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("a graph matching cannot be removed");
    }

    private Collection<int[]> findNext() {
        LinkedList<int[]> types = new LinkedList<int[]>();
        while (this.map()) {
            if (this.state.size() > this.state.maxQueryCandidate() || this.state.size() <= 0) continue;
            if (types.isEmpty()) {
                types.add(this.state.mapping());
                continue;
            }
            if (this.matchLength((int[])types.iterator().next()) < this.matchLength(this.state.mapping())) {
                types.clear();
                types.add(this.state.mapping());
                continue;
            }
            if (this.matchLength((int[])types.iterator().next()) != this.matchLength(this.state.mapping()) || this.solutionPresent(types, this.state.mapping())) continue;
            types.add(this.state.mapping());
        }
        return types.isEmpty() ? null : types;
    }

    private boolean solutionPresent(Collection<int[]> storedSolutions, int[] potentialSolution) {
        for (int[] solution : storedSolutions) {
            boolean equalsFlag = Arrays.equals(solution, potentialSolution);
            if (!equalsFlag) continue;
            return equalsFlag;
        }
        return false;
    }

    private int matchLength(int[] match) {
        int counter = 0;
        for (int i : match) {
            if (i < 0) continue;
            ++counter;
        }
        return counter;
    }

    private boolean map() {
        if (!(this.n != this.state.maxQueryCandidate() && this.m != this.state.maxTargetCandidate() || this.stack.empty())) {
            this.n = this.stack.popN();
            this.m = this.stack.popM();
            this.state.backTrack(this.n, this.m);
        }
        while ((this.m = this.state.nextCandidate(this.n, this.m)) < this.state.maxTargetCandidate()) {
            if (!this.state.addMapping(this.n, this.m)) continue;
            this.stack.push(this.n, this.m);
            this.n = this.state.hasNextCandidate(-1);
            this.m = -1;
            return this.n < this.state.maxQueryCandidate();
        }
        return this.state.size() > 0 || this.m < this.state.maxTargetCandidate();
    }

    private final class CandidateStack {
        private final int[] ns;
        private final int[] ms;
        private int nSize;
        private int mSize;

        private CandidateStack(int capacity) {
            this.ns = new int[capacity];
            this.ms = new int[capacity];
        }

        void push(int n, int m) {
            this.ns[this.nSize++] = n;
            this.ms[this.mSize++] = m;
        }

        int popN() {
            return this.ns[--this.nSize];
        }

        int popM() {
            return this.ms[--this.mSize];
        }

        boolean empty() {
            return this.nSize == 0 && this.mSize == 0;
        }
    }
}

