/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.filters.BaseFilter;
import org.openscience.smsd.filters.EnergyFilter;
import org.openscience.smsd.filters.FragmentFilter;
import org.openscience.smsd.filters.IChemicalFilter;
import org.openscience.smsd.filters.StereoFilter;

public class ChemicalFilters
extends BaseFilter {
    private final List<AtomAtomMapping> allAtomMCS = Collections.synchronizedList(new ArrayList());
    private final IChemicalFilter<Double> energyFilter;
    private final IChemicalFilter<Integer> fragmentFilter;
    private final IChemicalFilter<Double> stereoFilter = new StereoFilter(this);

    public ChemicalFilters(IAtomContainer sourceMol, IAtomContainer targetMol) {
        super(sourceMol, targetMol);
        this.fragmentFilter = new FragmentFilter(this);
        this.energyFilter = new EnergyFilter(this);
    }

    public ChemicalFilters(IQueryAtomContainer sourceMol, IAtomContainer targetMol) {
        super(sourceMol, targetMol);
        this.fragmentFilter = new FragmentFilter(this);
        this.energyFilter = new EnergyFilter(this);
    }

    private synchronized void clear(Map<Integer, AtomAtomMapping> sortedAllAtomMCS, Map<Integer, Double> stereoScoreMap, Map<Integer, Integer> fragmentScoreMap, Map<Integer, Double> energySelectionMap) {
        sortedAllAtomMCS.clear();
        stereoScoreMap.clear();
        fragmentScoreMap.clear();
        energySelectionMap.clear();
    }

    public synchronized void sortResultsByEnergies() throws CDKException {
        SortedMap<Integer, AtomAtomMapping> allEnergyAtomMCS = Collections.synchronizedSortedMap(new TreeMap());
        SortedMap<Integer, Double> stereoScoreMap = Collections.synchronizedSortedMap(new TreeMap());
        SortedMap<Integer, Integer> fragmentScoreMap = Collections.synchronizedSortedMap(new TreeMap());
        SortedMap<Integer, Double> energySelectionMap = Collections.synchronizedSortedMap(new TreeMap());
        this.initializeMaps(allEnergyAtomMCS, stereoScoreMap, fragmentScoreMap, energySelectionMap);
        double lowestEnergyScore = this.energyFilter.sortResults(allEnergyAtomMCS, energySelectionMap);
        this.clear();
        int counter = 0;
        for (Map.Entry map : energySelectionMap.entrySet()) {
            if (lowestEnergyScore != (Double)map.getValue()) continue;
            this.addSolution(counter, (Integer)map.getKey(), allEnergyAtomMCS, stereoScoreMap, energySelectionMap, fragmentScoreMap);
            ++counter;
        }
        if (lowestEnergyScore != EnergyFilter.MAX_ENERGY) {
            this.clear(allEnergyAtomMCS, stereoScoreMap, fragmentScoreMap, energySelectionMap);
        }
    }

    public synchronized void sortResultsByFragments() {
        SortedMap<Integer, AtomAtomMapping> allFragmentAtomMCS = Collections.synchronizedSortedMap(new TreeMap());
        SortedMap<Integer, Double> stereoScoreMap = Collections.synchronizedSortedMap(new TreeMap());
        SortedMap<Integer, Double> energyScoreMap = Collections.synchronizedSortedMap(new TreeMap());
        SortedMap<Integer, Integer> fragmentScoreMap = Collections.synchronizedSortedMap(new TreeMap());
        this.initializeMaps(allFragmentAtomMCS, stereoScoreMap, fragmentScoreMap, energyScoreMap);
        try {
            int minFragmentScore = this.fragmentFilter.sortResults(allFragmentAtomMCS, fragmentScoreMap);
            boolean flag = false;
            if (minFragmentScore < 9999) {
                flag = true;
                this.clear();
            }
            int counter = 0;
            for (Map.Entry map : fragmentScoreMap.entrySet()) {
                if (minFragmentScore != (Integer)map.getValue()) continue;
                this.addSolution(counter, (Integer)map.getKey(), allFragmentAtomMCS, stereoScoreMap, energyScoreMap, fragmentScoreMap);
                ++counter;
            }
            if (flag) {
                this.clear(allFragmentAtomMCS, stereoScoreMap, fragmentScoreMap, energyScoreMap);
            }
        }
        catch (CDKException cDKException) {
            // empty catch block
        }
    }

    public synchronized void sortResultsByStereoAndBondMatch() throws CDKException {
        Map<Integer, AtomAtomMapping> allStereoAtomMCS = Collections.synchronizedMap(new HashMap());
        SortedMap<Integer, Integer> fragmentScoreMap = Collections.synchronizedSortedMap(new TreeMap());
        SortedMap<Integer, Double> energyScoreMap = Collections.synchronizedSortedMap(new TreeMap());
        Map<Integer, Double> stereoScoreMap = Collections.synchronizedMap(new HashMap());
        this.initializeMaps(allStereoAtomMCS, stereoScoreMap, fragmentScoreMap, energyScoreMap);
        double highestStereoScore = this.stereoFilter.sortResults(allStereoAtomMCS, stereoScoreMap);
        if (highestStereoScore != 0.0) {
            boolean flag = false;
            double secondhigestStereoScore = highestStereoScore;
            for (Integer key : stereoScoreMap.keySet()) {
                if (secondhigestStereoScore < highestStereoScore && stereoScoreMap.get(key) > secondhigestStereoScore) {
                    secondhigestStereoScore = stereoScoreMap.get(key);
                    continue;
                }
                if (secondhigestStereoScore != highestStereoScore || !(stereoScoreMap.get(key) < secondhigestStereoScore)) continue;
                secondhigestStereoScore = stereoScoreMap.get(key);
            }
            if (!stereoScoreMap.isEmpty()) {
                flag = true;
                this.clear();
            }
            int counter = 0;
            for (Integer I : stereoScoreMap.keySet()) {
                if (highestStereoScore != stereoScoreMap.get(I)) continue;
                this.addSolution(counter, I, allStereoAtomMCS, stereoScoreMap, energyScoreMap, fragmentScoreMap);
                ++counter;
            }
            if (flag) {
                this.clear(allStereoAtomMCS, stereoScoreMap, fragmentScoreMap, energyScoreMap);
            }
        }
    }

    public synchronized List<Double> getSortedEnergy() {
        return Collections.unmodifiableList(this.energyFilter.getScores());
    }

    public synchronized List<Integer> getSortedFragment() {
        return Collections.unmodifiableList(this.fragmentFilter.getScores());
    }

    public synchronized List<Double> getStereoMatches() {
        return Collections.unmodifiableList(this.stereoFilter.getScores());
    }

    private synchronized void initializeMaps(Map<Integer, AtomAtomMapping> sortedAllAtomMCS, Map<Integer, Double> stereoScoreMap, Map<Integer, Integer> fragmentScoreMap, Map<Integer, Double> energySelectionMap) {
        Integer Index2 = 0;
        for (AtomAtomMapping atomsMCS : this.allAtomMCS) {
            sortedAllAtomMCS.put(Index2, atomsMCS);
            fragmentScoreMap.put(Index2, 0);
            energySelectionMap.put(Index2, 0.0);
            stereoScoreMap.put(Index2, 0.0);
            Integer n = Index2;
            Integer n2 = Index2 = Integer.valueOf(Index2 + 1);
        }
        this.energyFilter.fillMap(energySelectionMap);
        this.fragmentFilter.fillMap(fragmentScoreMap);
        this.stereoFilter.fillMap(stereoScoreMap);
    }

    private synchronized void addSolution(int counter, int key, Map<Integer, AtomAtomMapping> allFragmentAtomMCS, Map<Integer, Double> stereoScoreMap, Map<Integer, Double> energyScoreMap, Map<Integer, Integer> fragmentScoreMap) {
        this.allAtomMCS.add(counter, allFragmentAtomMCS.get(key));
        this.stereoFilter.addScore(counter, stereoScoreMap.get(key));
        this.fragmentFilter.addScore(counter, fragmentScoreMap.get(key));
        this.energyFilter.addScore(counter, energyScoreMap.get(key));
    }

    private synchronized void clear() {
        this.allAtomMCS.clear();
        this.energyFilter.clearScores();
        this.fragmentFilter.clearScores();
        this.stereoFilter.clearScores();
    }

    protected synchronized List<AtomAtomMapping> getMCSList() {
        return Collections.synchronizedList(this.allAtomMCS);
    }
}

