/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.mcss;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.mcss.JobType;
import org.openscience.smsd.mcss.MCSSThread;
import org.openscience.smsd.tools.AtomContainerComparator;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;

public class MCSS {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MCSS.class);
    private static final Logger LOG = Logger.getLogger(MCSS.class.getName());
    private final Collection<IAtomContainer> calculateMCSS;
    private final boolean matchBonds;
    private final boolean matchRings;
    private final boolean matchAtomType;

    public MCSS(List<IAtomContainer> jobList, JobType jobType, int numberOfThreads) {
        this(jobList, jobType, numberOfThreads, true, true, true);
    }

    public MCSS(List<IAtomContainer> jobList, JobType jobType, int numberOfThreads, boolean matchBonds, boolean matchRings, boolean matchAtomType) {
        int threadsAvailable = Runtime.getRuntime().availableProcessors() - 1;
        logger.debug("Demand threads: " + numberOfThreads);
        logger.debug(", Available threads: " + threadsAvailable);
        if (numberOfThreads > 0 && threadsAvailable >= numberOfThreads) {
            threadsAvailable = numberOfThreads;
        } else if (threadsAvailable <= 0) {
            threadsAvailable = 1;
        }
        logger.debug(", Assigned threads: " + threadsAvailable + "\n");
        ArrayList<IAtomContainer> selectedJobs = new ArrayList<IAtomContainer>(jobList.size());
        for (IAtomContainer ac : jobList) {
            selectedJobs.add(ExtAtomContainerManipulator.removeHydrogens(ac));
        }
        AtomContainerComparator comparator = new AtomContainerComparator();
        Collections.sort(selectedJobs, comparator);
        this.matchBonds = matchBonds;
        this.matchRings = matchRings;
        this.matchAtomType = matchAtomType;
        this.calculateMCSS = this.calculateMCSS(selectedJobs, jobType, threadsAvailable);
        selectedJobs.clear();
    }

    private synchronized Collection<IAtomContainer> calculateMCSS(List<IAtomContainer> mcssList, JobType jobType, int nThreads) {
        IAtomContainer inTheList;
        LinkedList<IAtomContainer> newMCSSList;
        if (nThreads == 1) {
            newMCSSList = new LinkedList<IAtomContainer>(this.submitSingleThreadedJob(mcssList, jobType, nThreads));
        } else {
            newMCSSList = new LinkedList<IAtomContainer>(this.submitMultiThreadedJob(mcssList, jobType, nThreads));
            while (newMCSSList.size() > 1) {
                if (newMCSSList.size() > 2) {
                    newMCSSList = new LinkedList<IAtomContainer>(this.submitMultiThreadedJob(newMCSSList, jobType, nThreads));
                    continue;
                }
                newMCSSList = new LinkedList<IAtomContainer>(this.submitMultiThreadedJob(newMCSSList, jobType, 1));
            }
        }
        if (!mcssList.isEmpty() && !newMCSSList.isEmpty() && (inTheList = mcssList.get(mcssList.size() - 1)) == newMCSSList.iterator().next()) {
            return new LinkedBlockingQueue<IAtomContainer>();
        }
        return newMCSSList;
    }

    public synchronized Collection<IAtomContainer> getCalculateMCSS() {
        return Collections.unmodifiableCollection(this.calculateMCSS);
    }

    private synchronized LinkedBlockingQueue<IAtomContainer> submitSingleThreadedJob(List<IAtomContainer> mcssList, JobType jobType, int nThreads) {
        LinkedBlockingQueue<IAtomContainer> solutions = new LinkedBlockingQueue<IAtomContainer>();
        MCSSThread task = new MCSSThread(mcssList, jobType, 1);
        Object results = task.call();
        if (results != null) {
            solutions.addAll((Collection<IAtomContainer>)results);
        }
        return solutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized LinkedBlockingQueue<IAtomContainer> submitMultiThreadedJob(List<IAtomContainer> mcssList, JobType jobType, int nThreads) {
        int taskNumber = 1;
        LinkedBlockingQueue<IAtomContainer> solutions = new LinkedBlockingQueue<IAtomContainer>();
        LinkedBlockingQueue<MCSSThread> callablesQueue = new LinkedBlockingQueue<MCSSThread>();
        ExecutorService threadPool = Executors.newFixedThreadPool(nThreads);
        int step = (int)Math.ceil(mcssList.size() / nThreads);
        if (step < 2) {
            step = 2;
        }
        for (int i = 0; i < mcssList.size(); i += step) {
            ArrayList<IAtomContainer> subList;
            int endPoint = i + step;
            if (endPoint > mcssList.size()) {
                endPoint = mcssList.size();
            }
            if ((subList = new ArrayList<IAtomContainer>(mcssList.subList(i, endPoint))).size() > 1) {
                MCSSThread mcssJobThread = new MCSSThread(subList, jobType, taskNumber, this.matchBonds, this.matchRings, this.matchAtomType);
                callablesQueue.add(mcssJobThread);
                ++taskNumber;
                continue;
            }
            solutions.add((IAtomContainer)subList.get(0));
        }
        try {
            List futureList = threadPool.invokeAll(callablesQueue);
            for (Future callable : futureList) {
                LinkedBlockingQueue mapping = (LinkedBlockingQueue)callable.get();
                if (callable.isDone() && mapping != null) {
                    solutions.addAll(mapping);
                    continue;
                }
                logger.warn("WARNING: InComplete job in AtomMappingTool: ");
            }
            threadPool.shutdown();
            while (!threadPool.isTerminated()) {
            }
            System.gc();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.debug("ERROR: in AtomMappingTool: " + e.getMessage());
            logger.error(e);
        }
        finally {
            threadPool.shutdown();
        }
        return solutions;
    }

    public synchronized String getTitle() {
        return "Calculating Maximum Commmon Substrutures (MCSS) using SMSD";
    }
}

