/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.aamtool.rgroup;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import uk.ac.ebi.aamtool.rgroup.ECRgroupFrequency;
import uk.ac.ebi.aamtool.rgroup.FingerprintType;
import uk.ac.ebi.aamtool.rgroup.ReactionGroup;
import uk.ac.ebi.reactionblast.mechanism.helper.Utility;
import uk.ac.ebi.reactionblast.tools.ExtAtomContainerManipulator;

class MultiReactionContainer {
    private static final Logger LOG = Logger.getLogger(MultiReactionContainer.class.getName());
    private final Set<ReactionGroup> reaction;
    private final String enzyme;
    private boolean RGroup;
    private final FingerprintType fp;

    MultiReactionContainer(String enzyme) {
        this.enzyme = enzyme;
        this.reaction = new TreeSet<ReactionGroup>();
        this.RGroup = false;
        this.fp = new FingerprintType(new TreeSet<String>(), new TreeSet<String>(), new TreeSet<String>());
    }

    public void addReaction(IReaction r, String name) {
        ReactionGroup rg = new ReactionGroup(name);
        if (!this.reaction.contains(rg)) {
            this.calculateCommonFingerprint(r);
            boolean local_r_group_finder = false;
            List<IAtomContainer> allAtomContainers = ReactionManipulator.getAllAtomContainers(r);
            for (IAtomContainer a : allAtomContainers) {
                if (!this.isRGroupPresent(a)) continue;
                local_r_group_finder = true;
                break;
            }
            rg.setRGroupPresent(local_r_group_finder);
            if (!this.isRGroup() && local_r_group_finder) {
                this.RGroup = true;
            }
            this.getReaction().add(rg);
        }
    }

    private boolean isRGroupPresent(IAtomContainer ac) {
        for (IAtom a : ac.atoms()) {
            if (!(a instanceof IPseudoAtom) || !a.getSymbol().contains("R")) continue;
            return true;
        }
        return false;
    }

    public String getEnzyme() {
        return this.enzyme;
    }

    public String getEnzyme1Level() {
        return this.enzyme.split("\\.")[0];
    }

    public String getEnzyme2Level() {
        return this.enzyme.split("\\.")[1];
    }

    public String getEnzyme3Level() {
        return this.enzyme.split("\\.")[2];
    }

    public String getEnzyme4Level() {
        return this.enzyme.split("\\.")[3];
    }

    public boolean isRGroup() {
        return this.RGroup;
    }

    private void calculateCommonFingerprint(IReaction reaction) {
        String smiles;
        IAtomContainer circularFragment;
        int i;
        IAtomContainer ac;
        HashSet<String> l = new HashSet<String>();
        HashSet<String> r = new HashSet<String>();
        SmilesGenerator sm = SmilesGenerator.unique().aromatic();
        for (IAtomContainer a : reaction.getReactants().atomContainers()) {
            ac = null;
            ac = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(a);
            for (i = 0; i < ac.getAtomCount(); ++i) {
                try {
                    circularFragment = Utility.getCircularFragment(ac, i, 1);
                    smiles = sm.create(circularFragment);
                    l.add(smiles);
                    this.getAllFP().add(smiles);
                    circularFragment = Utility.getCircularFragment(ac, i, 2);
                    smiles = sm.create(circularFragment);
                    l.add(smiles);
                    this.getAllFP().add(smiles);
                    circularFragment = Utility.getCircularFragment(ac, i, 3);
                    smiles = sm.create(circularFragment);
                    l.add(smiles);
                    this.getAllFP().add(smiles);
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(ECRgroupFrequency.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        for (IAtomContainer a : reaction.getProducts().atomContainers()) {
            ac = null;
            ac = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(a);
            for (i = 0; i < ac.getAtomCount(); ++i) {
                try {
                    circularFragment = Utility.getCircularFragment(ac, i, 1);
                    smiles = sm.create(circularFragment);
                    r.add(smiles);
                    this.getAllFP().add(smiles);
                    circularFragment = Utility.getCircularFragment(ac, i, 2);
                    smiles = sm.create(circularFragment);
                    r.add(smiles);
                    this.getAllFP().add(smiles);
                    circularFragment = Utility.getCircularFragment(ac, i, 3);
                    smiles = sm.create(circularFragment);
                    r.add(smiles);
                    this.getAllFP().add(smiles);
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(ECRgroupFrequency.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        HashSet common = new HashSet(l);
        boolean intersection = common.retainAll(r);
        TreeSet<String> difference = new TreeSet<String>(l);
        difference.addAll(r);
        boolean removeAll = difference.removeAll(common);
        if (this.getReaction().isEmpty()) {
            this.getCommonCommonFP().addAll(common);
        } else {
            this.getCommonCommonFP().retainAll(common);
        }
        if (this.getReaction().isEmpty()) {
            this.getCommonDifferenceFP().addAll(difference);
        } else {
            this.getCommonDifferenceFP().retainAll(difference);
        }
    }

    public Set<String> getCommonCommonFP() {
        return this.fp.getCommonCommonFP();
    }

    public Set<ReactionGroup> getReaction() {
        return this.reaction;
    }

    public int getReactionCount() {
        return this.reaction.size();
    }

    public Set<String> getCommonDifferenceFP() {
        return this.fp.getCommonDifferenceFP();
    }

    public Set<String> getAllFP() {
        return this.fp.getAllPatternsFP();
    }
}

