/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import uk.ac.ebi.centres.Descriptor;
import uk.ac.ebi.centres.Ligand;

public class Priority {
    private static final Logger LOG = Logger.getLogger(Priority.class.getName());
    private Boolean unique;
    private Descriptor.Type type;
    private Set<Set<Integer>> duplicates;

    public Priority(Boolean unique, Descriptor.Type type) {
        this.unique = unique;
        this.type = type;
    }

    public Priority(Boolean unique, Descriptor.Type type, Set<Set<Integer>> duplicates) {
        this.unique = unique;
        this.type = type;
        this.duplicates = duplicates;
    }

    public Boolean isUnique() {
        return this.unique;
    }

    public Descriptor.Type getType() {
        return this.type;
    }

    public <A> List<List<Ligand<A>>> createBins(List<Ligand<A>> ligands) {
        if (this.duplicates == null) {
            throw new IllegalArgumentException("No duplicates stored at time of sort!");
        }
        ArrayList<List<Ligand<A>>> bins = new ArrayList<List<Ligand<A>>>(ligands.size());
        for (Ligand<A> ligand : ligands) {
            ArrayList<Ligand<A>> bin = new ArrayList<Ligand<A>>();
            bin.add(ligands.get(0));
            bins.add(bin);
        }
        HashSet<Integer> removed = new HashSet<Integer>();
        for (Set<Integer> pair2 : this.duplicates) {
            Iterator<Integer> it = pair2.iterator();
            int i = it.next();
            int j = it.next();
            if (removed.contains(i) && removed.contains(j)) continue;
            ((List)bins.get(i)).addAll((Collection)bins.get(j));
            removed.add(j);
        }
        for (Integer remove : removed) {
            bins.remove(remove);
        }
        return bins;
    }
}

