/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.cdk;

import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.centres.DefaultPerceptor;
import uk.ac.ebi.centres.cdk.CDK2DSignCalculator;
import uk.ac.ebi.centres.cdk.CDKCentreProvider;
import uk.ac.ebi.centres.cdk.CDKManager;
import uk.ac.ebi.centres.priority.AtomicNumberRule;
import uk.ac.ebi.centres.priority.CombinedRule;
import uk.ac.ebi.centres.priority.DuplicateAtomRule;
import uk.ac.ebi.centres.priority.MassNumberRule;
import uk.ac.ebi.centres.priority.access.AtomicNumberAccessor;
import uk.ac.ebi.centres.priority.access.MassNumberAccessor;
import uk.ac.ebi.centres.priority.access.PsuedoAtomicNumberModifier;
import uk.ac.ebi.centres.priority.access.descriptor.AuxiliaryDescriptor;
import uk.ac.ebi.centres.priority.access.descriptor.PrimaryDescriptor;
import uk.ac.ebi.centres.priority.descriptor.PairRule;
import uk.ac.ebi.centres.priority.descriptor.RSRule;
import uk.ac.ebi.centres.priority.descriptor.ZERule;

public class CDKPerceptor
extends DefaultPerceptor<IAtom> {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(CDKPerceptor.class);
    private static final Logger LOG = Logger.getLogger(CDKPerceptor.class.getName());

    public CDKPerceptor() {
        super(new CombinedRule(new AtomicNumberRule<IAtom>(new PsuedoAtomicNumberModifier<IAtom>(new AtomicNumberAccessor<IAtom>(){

            @Override
            public int getAtomicNumber(IAtom atom) {
                return atom.getAtomicNumber() == null ? 0 : atom.getAtomicNumber();
            }
        })), new DuplicateAtomRule(), new MassNumberRule<IAtom>(new MassNumberAccessor<IAtom>(){

            @Override
            public int getMassNumber(IAtom atom) {
                return atom.getMassNumber() == null ? 11 : atom.getMassNumber();
            }
        }), new ZERule(), new PairRule(new PrimaryDescriptor()), new RSRule(new PrimaryDescriptor())), new CombinedRule(new AtomicNumberRule<IAtom>(new PsuedoAtomicNumberModifier<IAtom>(new AtomicNumberAccessor<IAtom>(){

            @Override
            public int getAtomicNumber(IAtom atom) {
                return atom.getAtomicNumber() == null ? 0 : atom.getAtomicNumber();
            }
        })), new MassNumberRule<IAtom>(new MassNumberAccessor<IAtom>(){

            @Override
            public int getMassNumber(IAtom atom) {
                return atom.getMassNumber();
            }
        }), new ZERule(), new PairRule(new AuxiliaryDescriptor()), new RSRule(new AuxiliaryDescriptor())), new CDK2DSignCalculator());
    }

    public void perceive(IAtomContainer container) {
        try {
            if (!GeometryTools.has2DCoordinates(container)) {
                try {
                    IAtomContainer clone = container.clone();
                    StructureDiagramGenerator sdg = new StructureDiagramGenerator(clone);
                    sdg.generateCoordinates();
                    container = sdg.getMolecule();
                }
                catch (CDKException clone) {
                    // empty catch block
                }
            }
            this.perceive(new CDKCentreProvider(container), new CDKManager(container));
        }
        catch (Exception e) {
            logger.warn("WARNING: 2D CDK based stereo perception failed! ");
        }
    }
}

