/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.cdk;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.io.CMLReader;
import org.openscience.cdk.silent.AtomContainer;
import org.openscience.cdk.silent.ChemFile;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class CMLLoader {
    private static final Logger LOG = Logger.getLogger(CMLLoader.class.getName());

    public static IAtomContainer loadCML(InputStream in) {
        CMLReader reader = new CMLReader(in);
        try {
            IChemFile chemfile = reader.read(new ChemFile());
            Iterator<IAtomContainer> iterator = ChemFileManipulator.getAllAtomContainers(chemfile).iterator();
            if (iterator.hasNext()) {
                IAtomContainer container = iterator.next();
                for (IAtom atom : container.atoms()) {
                    atom.setAtomicNumber(PeriodicTable.getAtomicNumber(atom.getSymbol()));
                    if (atom.getSymbol().equals("R")) continue;
                    atom.setMassNumber(Isotopes.getInstance().getMajorIsotope(atom.getSymbol()).getMassNumber());
                }
                AtomContainerManipulator.percieveAtomTypesAndConfigureUnsetProperties(container);
                return container;
            }
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        catch (IOException ex) {
            Logger.getLogger(CMLLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new AtomContainer();
    }

    private CMLLoader() {
    }
}

