/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.graph;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.ebi.centres.DescriptorManager;
import uk.ac.ebi.centres.MutableDescriptor;
import uk.ac.ebi.centres.descriptor.General;

public class DefaultDescriptorManager<A>
implements DescriptorManager<A> {
    private static final Logger LOG = Logger.getLogger(DefaultDescriptorManager.class.getName());
    private final Map<A, MutableDescriptor> atomMap = new HashMap<A, MutableDescriptor>();
    private final Map<Map.Entry<A, A>, MutableDescriptor> bondMap = new HashMap<Map.Entry<A, A>, MutableDescriptor>();

    @Override
    public MutableDescriptor getDescriptor(A atom) {
        MutableDescriptor mutableDescriptor = this.atomMap.get(atom);
        if (mutableDescriptor == null) {
            mutableDescriptor = new MutableDescriptor();
            this.atomMap.put(atom, mutableDescriptor);
        }
        return mutableDescriptor;
    }

    @Override
    public MutableDescriptor getDescriptor(A first, A second) {
        AbstractMap.SimpleEntry<A, A> entry = new AbstractMap.SimpleEntry<A, A>(first, second);
        MutableDescriptor mutableDescriptor = this.bondMap.get(entry);
        if (mutableDescriptor == null) {
            mutableDescriptor = new MutableDescriptor();
            this.bondMap.put(entry, mutableDescriptor);
            this.bondMap.put(new AbstractMap.SimpleEntry<A, A>(second, first), mutableDescriptor);
        }
        return mutableDescriptor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<A, MutableDescriptor> entry : this.atomMap.entrySet()) {
            if (entry.getValue().get() == General.UNKNOWN) continue;
            sb.append(entry.getKey()).append(": ").append(entry.getValue().get()).append("\n");
        }
        for (Map.Entry<Object, MutableDescriptor> entry : this.bondMap.entrySet()) {
            if (entry.getValue().get() == General.UNKNOWN) continue;
            sb.append(((Map.Entry)entry.getKey()).getKey()).append("=").append(((Map.Entry)entry.getKey()).getValue()).append(": ").append(entry.getValue().get()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void clear() {
        this.atomMap.clear();
        this.bondMap.clear();
    }
}

