/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.ligand;

import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import uk.ac.ebi.centres.ConnectionProvider;
import uk.ac.ebi.centres.MutableDescriptor;
import uk.ac.ebi.centres.ligand.AbstractLigand;

public class NonterminalLigand<A>
extends AbstractLigand<A> {
    private static final Logger LOG = Logger.getLogger(NonterminalLigand.class.getName());
    private final A atom;
    private A parent;

    public NonterminalLigand(MutableDescriptor descriptor, A atom, A parent, int distance) {
        this(descriptor, Collections.EMPTY_SET, atom, parent, distance);
    }

    public NonterminalLigand(ConnectionProvider<A> provider, MutableDescriptor descriptor, A atom, A parent, int distance) {
        this(provider, descriptor, Collections.EMPTY_SET, atom, parent, distance);
    }

    public NonterminalLigand(ConnectionProvider<A> provider, MutableDescriptor descriptor, Set<A> visited, A atom, A parent, int distance) {
        super(provider, visited, descriptor, distance);
        if (atom == null) {
            throw new IllegalArgumentException("Provided non-terminal atom should not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Provided non-terminal parent atom should not be null");
        }
        this.getVisited().add(atom);
        this.getVisited().add(parent);
        this.atom = atom;
        this.parent = parent;
    }

    public NonterminalLigand(MutableDescriptor descriptor, Set<A> visited, A atom, A parent, int distance) {
        super(visited, descriptor, distance);
        if (atom == null) {
            throw new IllegalArgumentException("Provided non-terminal atom should not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Provided non-terminal parent atom should not be null");
        }
        this.atom = atom;
        this.parent = parent;
        this.getVisited().add(atom);
        this.getVisited().add(parent);
    }

    @Override
    public A getParent() {
        return this.parent;
    }

    @Override
    public void setParent(A atom) {
        this.parent = atom;
    }

    @Override
    public A getAtom() {
        return this.atom;
    }

    @Override
    public boolean isTerminal() {
        return Boolean.FALSE;
    }

    @Override
    public boolean isBranching() {
        return Boolean.FALSE;
    }

    @Override
    public Boolean isParent(A atom) {
        return this.parent.equals(atom);
    }
}

