/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.priority;

import java.util.Iterator;
import java.util.List;
import uk.ac.ebi.centres.Comparison;
import uk.ac.ebi.centres.Descriptor;
import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.LigandComparison;
import uk.ac.ebi.centres.LigandSorter;
import uk.ac.ebi.centres.Priority;
import uk.ac.ebi.centres.PriorityRule;
import uk.ac.ebi.centres.priority.InsertionSorter;

public abstract class AbstractPriorityRule<A>
implements PriorityRule<A> {
    private LigandSorter<A> sorter;
    private boolean halted = Boolean.FALSE;
    private final Descriptor.Type reflection;
    private final PriorityRule.Type ordering;

    public AbstractPriorityRule(PriorityRule.Type ordering) {
        this(Descriptor.Type.ASYMMETRIC, ordering);
    }

    public AbstractPriorityRule(Descriptor.Type reflection, PriorityRule.Type ordering) {
        this.ordering = ordering;
        this.reflection = reflection;
    }

    @Override
    public void setHalt(boolean halt) {
        this.halted = halt;
    }

    @Override
    public int recursiveCompare(Ligand<A> o1, Ligand<A> o2) {
        int value = this.compare(o1, o2);
        return value != 0 || this.halted ? value : this.compare(o1.getLigands(), o2.getLigands());
    }

    @Override
    public Comparison compareLigands(Ligand<A> o1, Ligand<A> o2) {
        return new LigandComparison(this.recursiveCompare(o1, o2), this.reflection);
    }

    @Override
    public void setSorter(LigandSorter<A> sorter) {
        this.sorter = sorter;
    }

    public LigandSorter<A> getSorter() {
        if (this.sorter == null) {
            this.sorter = new InsertionSorter(this);
        }
        return this.sorter;
    }

    @Override
    public Priority prioritise(List<Ligand<A>> ligands) {
        return this.getSorter().prioritise(ligands);
    }

    @Override
    public int compare(List<Ligand<A>> first, List<Ligand<A>> second) {
        if (this.halted) {
            return 0;
        }
        this.prioritise(first);
        this.prioritise(second);
        Iterator<Ligand<A>> firstIt = first.iterator();
        Iterator<Ligand<A>> secondIt = second.iterator();
        while (firstIt.hasNext() && secondIt.hasNext()) {
            Ligand<A> secondLigand;
            Ligand<A> firstLigand = firstIt.next();
            int value = this.compare(firstLigand, secondLigand = secondIt.next());
            if (value == 0) continue;
            return value;
        }
        int sizediff = first.size() - second.size();
        if (sizediff != 0) {
            return sizediff;
        }
        firstIt = first.iterator();
        secondIt = second.iterator();
        while (firstIt.hasNext() && secondIt.hasNext()) {
            Ligand<A> secondLigand;
            Ligand<A> firstLigand = firstIt.next();
            int value = this.recursiveCompare(firstLigand, secondLigand = secondIt.next());
            if (value == 0) continue;
            return value;
        }
        return 0;
    }

    public boolean isHalted() {
        return this.halted;
    }

    @Override
    public Descriptor.Type getType() {
        return this.reflection;
    }

    @Override
    public PriorityRule.Type getRuleType() {
        return this.ordering;
    }
}

