/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.priority.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import uk.ac.ebi.centres.Descriptor;

public final class DescriptorList
implements Comparable<DescriptorList> {
    private static final Logger LOG = Logger.getLogger(DescriptorList.class.getName());
    private final List<Descriptor> descriptors = new ArrayList<Descriptor>();
    private final Set<Descriptor> ignore = new HashSet<Descriptor>();
    private int pairing = 0;

    public DescriptorList(Descriptor ... ignore) {
        this(Arrays.asList(ignore));
    }

    public DescriptorList(List<Descriptor> ignores) {
        this.ignoreAll(ignores);
    }

    public DescriptorList(DescriptorList head, DescriptorList tail) {
        this.ignoreAll(head.ignore);
        this.ignoreAll(tail.ignore);
        this.addAll(head.descriptors);
        this.addAll(tail.descriptors);
    }

    public boolean ignore(Descriptor ignore) {
        return this.ignore.add(ignore);
    }

    public boolean ignoreAll(Collection<? extends Descriptor> ignores) {
        boolean changed = Boolean.FALSE;
        for (Descriptor descriptor : ignores) {
            changed = this.ignore(descriptor) || changed;
        }
        return changed;
    }

    public boolean add(Descriptor descriptor) {
        return !this.ignore.contains(descriptor) && this.addAndPair(descriptor);
    }

    private boolean addAndPair(Descriptor descriptor) {
        if (!this.descriptors.isEmpty() && this.descriptors.get(0).equals(descriptor)) {
            this.pairing |= 1 << 31 - this.descriptors.size();
        }
        return this.descriptors.add(descriptor);
    }

    public boolean addAll(Collection<? extends Descriptor> descriptors) {
        boolean changed = Boolean.FALSE;
        for (Descriptor descriptor : descriptors) {
            changed = this.add(descriptor) || changed;
        }
        return changed;
    }

    public int getPairing() {
        return this.pairing;
    }

    public List<DescriptorList> append(Collection<? extends DescriptorList> lists) {
        ArrayList<DescriptorList> created = new ArrayList<DescriptorList>(lists.size());
        for (DescriptorList descriptorList : lists) {
            if (descriptorList.descriptors.isEmpty()) continue;
            created.add(new DescriptorList(this, descriptorList));
        }
        if (created.isEmpty()) {
            created.add(this);
        }
        return created;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.descriptors.isEmpty() || this.descriptors.get(0) == null) {
            return sb.toString();
        }
        Iterator<Descriptor> it = this.descriptors.iterator();
        Descriptor basis = it.next();
        sb.append(basis).append(":");
        while (it.hasNext()) {
            sb.append(basis.equals(it.next()) ? "l" : "u");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(DescriptorList o) {
        return this.getPairing() - o.getPairing();
    }

    public void clear() {
        this.pairing = 0;
        this.descriptors.clear();
    }
}

