/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.containers;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import uk.ac.ebi.reactionblast.interfaces.IInChIContainer;

public class InChIContainer
implements IInChIContainer,
Cloneable {
    private static InChIContainer _instance = null;
    private static Map<String, String> InChIMap = null;
    private static final Logger LOG = Logger.getLogger(InChIContainer.class.getName());

    public static int getCount() throws IOException {
        return InChIMap.size();
    }

    public static synchronized InChIContainer getInstance() {
        if (_instance == null) {
            _instance = new InChIContainer();
        }
        return _instance;
    }

    private InChIContainer() {
        InChIMap = Collections.synchronizedSortedMap(new TreeMap());
    }

    @Override
    public synchronized void Clear() throws IOException {
        InChIMap.clear();
        _instance = null;
    }

    @Override
    public void Erase(String Key2) throws IOException {
        InChIMap.remove(Key2);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public synchronized void put(String Key2, String Value2) throws IOException {
        try {
            if (Value2 != null) {
                InChIMap.put(Key2, Value2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized String getInChI(String Key2) throws IOException {
        String value = InChIMap.get(Key2);
        return value == null ? "" : value;
    }

    @Override
    public synchronized String getMoleculeID(String Value2) throws IOException {
        String Key2 = "Key Not Found";
        for (Map.Entry<String, String> map : InChIMap.entrySet()) {
            if (!map.getValue().equals(Value2)) continue;
            return Key2;
        }
        return Key2;
    }

    @Override
    public synchronized Map<String, String> getInChIMap() throws IOException {
        return Collections.unmodifiableMap(InChIMap);
    }

    @Override
    public synchronized boolean isKeyPresent(String Key2) throws IOException {
        boolean flag = InChIMap.containsKey(Key2);
        return flag;
    }

    @Override
    public synchronized void setValue(String Key2, String Value2) throws IOException {
        InChIMap.put(Key2, Value2);
    }

    @Override
    public synchronized boolean isValuePresent(String Value2) throws IOException {
        boolean flag = InChIMap.containsValue(Value2);
        return flag;
    }

    @Override
    public void write() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

