/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.fingerprints;

import java.util.BitSet;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.CircularFingerprinter;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IFingerprintGenerator;

public class FingerprintGenerator
implements IFingerprintGenerator {
    private static final Logger LOG = Logger.getLogger(FingerprintGenerator.class.getName());
    final CircularFingerprinter fingerprinter = new CircularFingerprinter(3);

    public static int getFingerprinterSize() {
        return new CircularFingerprinter(3).getSize();
    }

    @Override
    public synchronized BitSet getFingerprint(IAtomContainer mol) throws CDKException {
        if (!GeometryTools.has2DCoordinates(mol)) {
            StructureDiagramGenerator structureDiagramGenerator = new StructureDiagramGenerator();
            structureDiagramGenerator.setMolecule(mol, true);
            if (ConnectivityChecker.isConnected(mol)) {
                structureDiagramGenerator.generateCoordinates();
                mol = structureDiagramGenerator.getMolecule();
            } else {
                System.err.println("Disconnected components needs to be layout separately");
            }
        }
        return this.fingerprinter.getBitFingerprint(mol).asBitSet();
    }
}

