/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.fingerprints;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.fingerprints.FingerprintGenerator;
import uk.ac.ebi.reactionblast.fingerprints.tools.Similarity;

public class MolFingerprint
implements Comparable<MolFingerprint>,
Comparator<MolFingerprint> {
    private static final long serialVersionUID = 7057060562283378622L;
    private static final Logger LOG = Logger.getLogger(MolFingerprint.class.getName());
    private boolean[] arrayFingerprint = null;
    private BitSet bitsetFingerprint = null;
    private final FingerprintGenerator hashedFP = new FingerprintGenerator();

    private static synchronized MolFingerprint or(boolean[] boolArray1, boolean[] boolArray2) throws CDKException {
        if (boolArray1.length != boolArray2.length) {
            throw new CDKException("EBIFingerprint.or(boolean[], boolean[]): array with different dimensions.");
        }
        MolFingerprint res = new MolFingerprint(boolArray1);
        for (int i = 0; i < boolArray1.length; ++i) {
            if (!boolArray2[i]) continue;
            res.setBit(i, true);
        }
        return res;
    }

    private static synchronized MolFingerprint and(boolean[] boolArray1, boolean[] boolArray2) throws CDKException {
        if (boolArray1.length != boolArray2.length) {
            throw new CDKException("EBIFingerprint.and(boolean[], boolean[]): array with different dimensions.");
        }
        MolFingerprint res = new MolFingerprint(boolArray1.length);
        for (int i = 0; i < boolArray1.length; ++i) {
            if (boolArray1[i] && boolArray2[i]) {
                res.setBit(i, true);
                continue;
            }
            res.setBit(i, false);
        }
        return res;
    }

    public MolFingerprint() {
        this.arrayFingerprint = new boolean[0];
    }

    public MolFingerprint(IAtomContainer mol) throws CDKException {
        this();
        try {
            this.bitsetFingerprint = this.hashedFP.getFingerprint(mol);
            this.set(this.bitsetFingerprint);
            this.arrayFingerprint = new boolean[FingerprintGenerator.getFingerprinterSize()];
            for (int i = 0; i < FingerprintGenerator.getFingerprinterSize(); ++i) {
                this.arrayFingerprint[i] = this.bitsetFingerprint.get(i);
            }
        }
        catch (CDKException e) {
            throw new CDKException("Failed to create CDKMolecularDescriptor while constructing EBIFingerprint " + mol.getAtomCount() + ",\n" + e.getMessage());
        }
    }

    public MolFingerprint(BitSet fgrprt) {
        this();
        this.arrayFingerprint = new boolean[fgrprt.size()];
        for (int i = 0; i < fgrprt.length(); ++i) {
            this.arrayFingerprint[i] = fgrprt.get(i);
        }
    }

    public MolFingerprint(int length) {
        this();
        this.arrayFingerprint = new boolean[length];
        this.set(false);
    }

    public MolFingerprint(boolean[] fgprt) throws CDKException {
        this();
        this.arrayFingerprint = new boolean[fgprt.length];
        System.arraycopy(fgprt, 0, this.arrayFingerprint, 0, fgprt.length);
    }

    public MolFingerprint(MolFingerprint molFingerprint) throws CDKException {
        this();
        this.arrayFingerprint = new boolean[molFingerprint.getBooleanArray().length];
        System.arraycopy(molFingerprint.getBooleanArray(), 0, this.arrayFingerprint, 0, this.arrayFingerprint.length);
    }

    private synchronized void set(boolean value) {
        for (int i = 0; i < this.arrayFingerprint.length; ++i) {
            this.arrayFingerprint[i] = value;
        }
    }

    private synchronized void set(BitSet bitset) {
        this.arrayFingerprint = new boolean[bitset.size()];
        for (int i = 0; i < bitset.length(); ++i) {
            this.arrayFingerprint[i] = bitset.get(i);
        }
    }

    public synchronized BitSet getBitSet() {
        BitSet bts = new BitSet(this.arrayFingerprint.length);
        for (int i = 0; i < this.arrayFingerprint.length; ++i) {
            bts.set(i, this.arrayFingerprint[i]);
        }
        return bts;
    }

    private synchronized void set(int fromIndex, MolFingerprint molFingerprint) throws CDKException {
        for (int i = fromIndex; i < fromIndex + molFingerprint.length() && i < this.arrayFingerprint.length; ++i) {
            this.arrayFingerprint[i] = molFingerprint.getBooleanArray()[i - fromIndex];
        }
    }

    private synchronized void set(int fromIndex, boolean[] fgprt) throws CDKException {
        for (int i = fromIndex; i < fromIndex + fgprt.length && i < this.arrayFingerprint.length; ++i) {
            this.arrayFingerprint[i] = fgprt[i - fromIndex];
        }
    }

    public synchronized String toString() {
        String strFp = "";
        for (int i = 0; i < this.arrayFingerprint.length; ++i) {
            strFp = strFp + (this.arrayFingerprint[i] ? "1" : "0");
        }
        return strFp;
    }

    public synchronized void println() {
        System.out.println(this.toString());
    }

    public synchronized int length() {
        return this.arrayFingerprint.length;
    }

    public synchronized boolean getBit(int index) throws CDKException {
        if (index >= this.arrayFingerprint.length || index < 0) {
            throw new CDKException("EBIFingerprint.getBit(int index) failed for index out of bounds.");
        }
        return this.arrayFingerprint[index];
    }

    public synchronized void setBit(int index, boolean value) throws CDKException {
        if (index >= this.arrayFingerprint.length || index < 0) {
            throw new CDKException("EBIFingerprint.setBit(int index, boolean value) failed for index out of bounds.");
        }
        this.arrayFingerprint[index] = value;
    }

    public synchronized boolean[] getBooleanArray() {
        boolean[] bs = new boolean[this.arrayFingerprint.length];
        System.arraycopy(this.arrayFingerprint, 0, bs, 0, this.arrayFingerprint.length);
        return bs;
    }

    public synchronized void append(Byte b) throws CDKException {
        boolean[] bt = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            bt[i] = (b & 1 << 7 - i) != 0;
        }
        this.append(new MolFingerprint(bt));
    }

    public synchronized void append(MolFingerprint fp) throws CDKException {
        MolFingerprint newFp = new MolFingerprint(this.arrayFingerprint.length + fp.length());
        newFp.set(0, this.arrayFingerprint);
        newFp.set(this.arrayFingerprint.length, fp);
        this.arrayFingerprint = newFp.getBooleanArray();
    }

    public synchronized MolFingerprint or(MolFingerprint molFp) throws CDKException {
        return MolFingerprint.or(this.arrayFingerprint, molFp.getBooleanArray());
    }

    public synchronized MolFingerprint and(MolFingerprint molFp) throws CDKException {
        return MolFingerprint.and(this.arrayFingerprint, molFp.getBooleanArray());
    }

    public synchronized double similarity(MolFingerprint fingerprint) throws Exception {
        double similarity = Similarity.getTanimotoSimilarity(fingerprint.getBitSet(), this.bitsetFingerprint);
        return similarity;
    }

    @Override
    public synchronized int compareTo(MolFingerprint t) {
        return this.compare(this, t);
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MolFingerprint)) {
            return false;
        }
        MolFingerprint fpn = (MolFingerprint)object;
        if (this.arrayFingerprint.length != fpn.getBooleanArray().length) {
            return false;
        }
        for (int i = 0; i < this.arrayFingerprint.length; ++i) {
            if (this.arrayFingerprint[i] == this.arrayFingerprint[i]) continue;
            return false;
        }
        return true;
    }

    public synchronized int hashCode() {
        int hash = 7;
        hash = 19 * hash + Arrays.hashCode(this.arrayFingerprint);
        hash = 19 * hash + (this.bitsetFingerprint != null ? this.bitsetFingerprint.hashCode() : 0);
        return hash;
    }

    @Override
    public int compare(MolFingerprint o1, MolFingerprint o2) {
        int len1 = o1.getBooleanArray().length;
        int len2 = o2.getBooleanArray().length;
        int n = Math.min(len1, len2);
        if (len1 == len2) {
            if (o1.equals(o2)) {
                return 0;
            }
            return -1;
        }
        return Math.max(len1, len2) - n;
    }
}

