/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct;

import java.util.Comparator;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;

public class AtomContainerComparatorBy2DCenter
implements Comparator<IAtomContainer> {
    private static final Logger LOG = Logger.getLogger(AtomContainerComparatorBy2DCenter.class.getName());

    @Override
    public int compare(IAtomContainer atCont1, IAtomContainer atCont2) {
        if (atCont1 != null && atCont2 != null) {
            Point2d p1 = GeometryTools.get2DCenter(atCont1);
            Point2d p2 = GeometryTools.get2DCenter(atCont2);
            if (p1 != null && p2 != null) {
                if (p1.x != p2.x) {
                    return new Double(p1.x).compareTo(p2.x);
                }
                return new Double(p1.y).compareTo(p2.y);
            }
        }
        return 0;
    }
}

