/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import javax.vecmath.Point2f;
import javax.vecmath.Vector2d;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.graphics.direct.AbstractDirectDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.Axis;
import uk.ac.ebi.reactionblast.graphics.direct.DirectArrowDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.DirectMoleculeDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.MoleculeLabelDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.Params;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.AbstractAWTReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.AbstractDirectReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsPrinter;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;
import uk.ac.ebi.reactionblast.graphics.direct.layout.LeftToRightReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.TopToBottomReactionLayout;

public class DirectReactionDrawer
extends AbstractDirectDrawer {
    private static final Logger LOG = Logger.getLogger(DirectReactionDrawer.class.getName());
    private AbstractDirectReactionLayout reactionLayout;
    private AbstractAWTReactionLayout exactReactionLayout;
    private DirectMoleculeDrawer moleculeDrawer;
    private DirectArrowDrawer arrowDrawer;

    public DirectReactionDrawer(AbstractDirectReactionLayout layout) {
        this(new Params(), layout);
    }

    public DirectReactionDrawer(Params params) {
        this.setParams(params);
        this.reactionLayout = null;
        this.moleculeDrawer = new DirectMoleculeDrawer(params);
        this.arrowDrawer = new DirectArrowDrawer(params);
    }

    public DirectReactionDrawer(Params params, AbstractDirectReactionLayout layout) {
        this(params, layout, null);
    }

    public DirectReactionDrawer(Params params, AbstractDirectReactionLayout layout, AbstractAWTReactionLayout exactReactionLayout) {
        this.setParams(params);
        this.reactionLayout = layout;
        layout.setParams(params);
        this.exactReactionLayout = exactReactionLayout;
        if (exactReactionLayout != null) {
            exactReactionLayout.setParams(params);
        }
        this.moleculeDrawer = new DirectMoleculeDrawer(params);
        this.arrowDrawer = new DirectArrowDrawer(params);
    }

    public AbstractDirectReactionLayout getLayout() {
        return this.reactionLayout;
    }

    private void setupLayout() {
        if (this.reactionLayout == null) {
            this.reactionLayout = this.params.layoutLeftToRight ? new LeftToRightReactionLayout() : new TopToBottomReactionLayout();
        }
    }

    public Image drawReaction(IReaction reaction) {
        return this.drawReaction(reaction, true);
    }

    public Image drawReaction(IReaction reaction, int w, int h) {
        return this.drawReaction(reaction, w, h, true);
    }

    public Map<String, String> makeLabelMap(IReaction reaction) {
        String boundsLabel;
        String acID;
        HashMap<String, String> labelMap = new HashMap<String, String>();
        reaction.getReactants().setID("r");
        reaction.getProducts().setID("p");
        String rxnID = reaction.getID();
        int counter = 0;
        for (IAtomContainer atomContainer : reaction.getReactants().atomContainers()) {
            acID = atomContainer.getID();
            boundsLabel = rxnID + "_" + "r" + "_" + acID + ":" + counter;
            labelMap.put(boundsLabel, acID);
            ++counter;
        }
        counter = 0;
        for (IAtomContainer atomContainer : reaction.getProducts().atomContainers()) {
            acID = atomContainer.getID();
            boundsLabel = rxnID + "_" + "p" + "_" + acID + ":" + counter;
            labelMap.put(boundsLabel, acID);
            ++counter;
        }
        return labelMap;
    }

    public Image drawReaction(IReaction reaction, int w, int h, boolean invert) {
        this.setupLayout();
        this.reactionLayout.shouldInvert = invert;
        Map<String, String> labelMap = this.makeLabelMap(reaction);
        BoundsTree boundsTree = this.reactionLayout.layout(reaction, this.reactionLayout.getAxis());
        Vector2d reactionAxis = this.reactionLayout.getAxis();
        BufferedImage image = this.makeBlankImage(w, h);
        Graphics2D g = (Graphics2D)image.getGraphics();
        if (this.params.useAntialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        AffineTransform originalTransform = g.getTransform();
        if (this.exactReactionLayout != null) {
            boundsTree = this.exactReactionLayout.layout(reaction, g);
        }
        Rectangle2D totalBoundingBox = boundsTree.getBounds(new ArrayList<String>(labelMap.keySet()));
        boundsTree.setRoot(totalBoundingBox);
        double zoom = this.calculateZoom(w, h, totalBoundingBox);
        BoundsTree centeredBoundsTree = this.centerOn(reaction, 0.0, 0.0, boundsTree);
        totalBoundingBox = centeredBoundsTree.getBounds(new ArrayList<String>(labelMap.keySet()));
        centeredBoundsTree.setRoot(totalBoundingBox);
        double rxnWidth = totalBoundingBox.getWidth();
        double rxnHeight = totalBoundingBox.getHeight();
        double finalWidth = zoom * rxnWidth + (double)(2 * this.params.borderX);
        double finalHeight = zoom * rxnHeight + (double)(2 * this.params.borderY);
        g.translate(w / 2, h / 2);
        g.scale(zoom, zoom);
        if (this.params.drawLabelPanel) {
            finalHeight += this.params.labelPanelHeight;
        }
        this.drawReaction(reaction, g, centeredBoundsTree, reactionAxis);
        if (this.params.drawLabelPanel) {
            g.setTransform(originalTransform);
            g.translate(w / 2, h / 2);
            g.setFont(new Font(this.params.labelPanelFont, 0, this.params.labelPanelFontSize));
            AffineTransform labelTransform = new AffineTransform();
            labelTransform.scale(zoom, zoom);
            double labelGap = this.params.labelGap;
            double labelHeight = this.getMaxLabelHeight(centeredBoundsTree, labelMap, g);
            double labelShift = totalBoundingBox.getHeight() / 2.0 + labelHeight / 2.0 + labelGap;
            labelTransform.translate(0.0, labelShift);
            BoundsTree labelBoundsTree = centeredBoundsTree.transform(labelTransform);
            g.setColor(Color.BLACK);
            this.drawLabelPanel(labelMap, labelBoundsTree, g);
            finalHeight += labelHeight + labelGap;
        }
        if (this.params.shouldCrop) {
            double dX = (double)w - finalWidth;
            double dY = (double)h - finalHeight;
            int cropX = Math.max(0, (int)dX / 2);
            int cropY = Math.max(0, (int)dY / 2);
            int cropW = (int)Math.min(finalWidth, (double)w);
            int cropH = (int)Math.min(finalHeight, (double)w);
            if (cropX + cropW > w || cropY + cropH > h) {
                System.out.println("Not cropping " + (cropX + cropW) + " " + w + " " + (cropY + cropH) + " " + h);
                return image;
            }
            return image.getSubimage(cropX, cropY, cropW, cropH);
        }
        return image;
    }

    public Image drawReaction(IReaction reaction, boolean invert) {
        this.setupLayout();
        int borderX = this.params.borderX;
        int borderY = this.params.borderY;
        this.reactionLayout.shouldInvert = invert;
        if (this.exactReactionLayout != null) {
            reaction.getReactants().setID("r");
            reaction.getProducts().setID("p");
        }
        BoundsTree boundsTree = this.reactionLayout.layout(reaction, this.reactionLayout.getAxis());
        Vector2d reactionAxis = this.reactionLayout.getAxis();
        if (this.exactReactionLayout != null) {
            BufferedImage dummyImage = this.makeBlankImage(1, 1);
            Graphics2D g = (Graphics2D)((Image)dummyImage).getGraphics();
            boundsTree = this.exactReactionLayout.layout(reaction, g);
            Rectangle2D bb = boundsTree.getRoot();
            double dx = boundsTree.getWidth() / 2.0 - bb.getCenterX();
            double dy = boundsTree.getHeight() / 2.0 - bb.getCenterY();
            System.err.println(BoundsPrinter.toString(bb) + " " + dx + " " + dy);
            boundsTree = this.shift(reaction, boundsTree, dx, 0.0);
        }
        int w = (int)boundsTree.getWidth() + 2 * borderX;
        int h = (int)boundsTree.getHeight() + 2 * borderY;
        BufferedImage image = this.makeBlankImage(w, h);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        this.drawReaction(reaction, g, boundsTree, reactionAxis);
        return image;
    }

    public void drawReaction(IReaction reaction, BoundsTree boundsTree, int w, int h, double zoom, Graphics2D g) {
        Vector2d reactionAxis;
        if (this.params.useAntialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.translate(w / 2, h / 2);
        g.scale(zoom, zoom);
        if (this.reactionLayout != null) {
            if (this.exactReactionLayout == null) {
                reactionAxis = this.reactionLayout.getAxis();
            } else {
                reaction.getReactants().setID("r");
                reaction.getProducts().setID("p");
                reactionAxis = this.exactReactionLayout.getAxis();
            }
        } else {
            reactionAxis = new Vector2d(1.0, 0.0);
        }
        this.drawReaction(reaction, g, boundsTree, reactionAxis);
    }

    public void drawLabelPanel(Map<String, String> labelMap, BoundsTree labelBoundsTree, Graphics2D g) {
        MoleculeLabelDrawer molLabelDrawer = new MoleculeLabelDrawer(Axis.X, this.params);
        molLabelDrawer.draw(labelMap, labelBoundsTree, g);
    }

    public double getMaxLabelHeight(BoundsTree tree, Map<String, String> labels, Graphics2D g) {
        double maxHeight = 0.0;
        Font font = new Font(this.params.labelPanelFont, 0, this.params.labelPanelFontSize);
        FontRenderContext frc = g.getFontRenderContext();
        for (String boundsLabel : labels.keySet()) {
            TextLayout justifiedLayout;
            double height;
            String label = labels.get(boundsLabel);
            Rectangle2D bounds = tree.get(boundsLabel);
            float boundsWidth = (float)bounds.getWidth();
            TextLayout textLayout = new TextLayout(label, font, frc);
            if (boundsWidth <= 0.0f || !((height = (justifiedLayout = textLayout.getJustifiedLayout(boundsWidth)).getBounds().getHeight()) > maxHeight)) continue;
            maxHeight = height;
        }
        return maxHeight;
    }

    private void drawReaction(IReaction reaction, Graphics2D g, BoundsTree boundsTree, Vector2d reactionAxis) {
        double yPos;
        double xPos;
        IAtomContainerSet reactants = reaction.getReactants();
        double reactantAxisPos = this.molSetBounds(reactants).getCenterY();
        String reactionID = reaction.getID();
        this.drawMoleculeSet(reactants, reactionID, reactantAxisPos, boundsTree, g);
        int index = reaction.getReactantCount() - 1;
        IAtomContainer lastReactant = reaction.getReactants().getAtomContainer(index);
        String reactantsID = reaction.getReactants().getID();
        String boundsID = reactionID + "_" + reactantsID + "_" + lastReactant.getID() + ":" + index;
        Rectangle2D lastRBound = boundsTree.get(boundsID);
        if (this.reactionLayout.getArrowAxis() == Axis.X) {
            xPos = lastRBound.getMaxX() + (double)this.params.arrowGap + (double)(this.params.arrowLength / 2);
            yPos = boundsTree.getRoot().getCenterY();
        } else {
            xPos = boundsTree.getRoot().getCenterX();
            yPos = lastRBound.getMaxY() + (double)this.params.arrowGap + (double)(this.params.arrowLength / 2);
        }
        Point2d arrowCenter = new Point2d(xPos, yPos);
        if (this.params.arrowType == Params.ArrowType.FORWARD) {
            this.arrowDrawer.drawArrow(g, arrowCenter, reactionAxis);
        } else if (this.params.arrowType == Params.ArrowType.BACKWARD) {
            Vector2d backAxis = new Vector2d(reactionAxis);
            backAxis.negate();
            this.arrowDrawer.drawArrow(g, arrowCenter, backAxis);
        } else {
            this.arrowDrawer.drawArrow(g, arrowCenter, reactionAxis);
        }
        IAtomContainerSet products = reaction.getProducts();
        double productAxisPos = this.molSetBounds(products).getCenterY();
        this.drawMoleculeSet(products, reactionID, productAxisPos, boundsTree, g);
        if (this.params.drawMappings) {
            this.drawMappings(reaction, g);
        }
    }

    private void drawBoundsTree(BoundsTree tree, List<String> labels, Color color, Graphics2D g) {
        Random random = new Random();
        for (String label : labels) {
            Rectangle2D bounds = tree.get(label);
            g.setColor(color);
            g.draw(bounds);
            g.setColor(Color.RED);
            Point2f p = super.getTextPoint(g, label, bounds.getCenterX(), bounds.getCenterY());
            g.drawString(label, p.x, p.y);
        }
    }

    public void printBoundsTree(BoundsTree tree, List<String> labels) {
        for (String label : labels) {
            Rectangle2D r = tree.get(label);
            if (r == null) {
                System.out.println(label + ":NULL");
                continue;
            }
            System.out.println(label + ":" + BoundsPrinter.toString(r));
        }
    }

    public BoundsTree centerOnOrigin(IReaction reaction, BoundsTree boundsTree) {
        return this.centerOn(reaction, 0.0, 0.0, boundsTree);
    }

    public BoundsTree centerOn(IReaction reaction, double cx, double cy, BoundsTree boundsTree) {
        double boundsX = boundsTree.getRoot().getCenterX();
        double boundsY = boundsTree.getRoot().getCenterY();
        double dx = cx - boundsX;
        double dy = cy - boundsY;
        return this.shift(reaction, boundsTree, dx, dy);
    }

    public BoundsTree shift(IReaction reaction, BoundsTree unshiftedTree, double dx, double dy) {
        IAtomContainerSet reactants = reaction.getReactants();
        IAtomContainerSet products = reaction.getProducts();
        String rootLabel = reaction.getID();
        String reactantID = reactants.getID();
        BoundsTree reactantTree = unshiftedTree.getSubtree(rootLabel + "_" + reactantID);
        BoundsTree rBoundsTree = this.shift(reactants, rootLabel, reactantTree, reactantID, dx, dy);
        String productID = products.getID();
        BoundsTree productTree = unshiftedTree.getSubtree(rootLabel + "_" + productID);
        BoundsTree pBoundsTree = this.shift(products, rootLabel, productTree, products.getID(), dx, dy);
        BoundsTree boundsTree = new BoundsTree(reaction.getID(), rBoundsTree, pBoundsTree);
        if (this.exactReactionLayout == null) {
            double pos = this.reactionLayout.getArrowPos();
            if (this.reactionLayout.getArrowAxis() == Axis.X) {
                this.reactionLayout.setArrowPos(pos + dy);
            } else {
                this.reactionLayout.setArrowPos(pos + dx);
            }
        } else {
            double pos = this.reactionLayout.getArrowPos();
            if (this.exactReactionLayout.getArrowAxis() == Axis.X) {
                this.exactReactionLayout.setArrowPos(pos + dy);
            } else {
                this.exactReactionLayout.setArrowPos(pos + dx);
            }
        }
        return boundsTree;
    }

    private BoundsTree shift(IAtomContainerSet reactants, String rootLabel, BoundsTree unshiftedMolSetTree, String label, double dx, double dy) {
        BoundsTree boundsTree = new BoundsTree(label);
        int counter = 0;
        for (IAtomContainer atomContainer : reactants.atomContainers()) {
            String fullLabel = rootLabel + "_" + label + "_" + atomContainer.getID() + ":" + counter;
            String subLabel = label + "_" + atomContainer.getID() + ":" + counter;
            GeometryTools.translate2D(atomContainer, dx, dy);
            Rectangle2D uBounds = unshiftedMolSetTree.get(fullLabel);
            Rectangle2D.Double sBounds = new Rectangle2D.Double(uBounds.getMinX() + dx, uBounds.getMinY() + dy, uBounds.getWidth(), uBounds.getHeight());
            boundsTree.add(subLabel, sBounds);
            ++counter;
        }
        return boundsTree;
    }

    private Axis getAxisOfExpansion(int targetWidth, int targetHeight, double zoomedWidth, double zoomedHeight) {
        double widthRatio = (double)targetWidth / zoomedWidth;
        double heightRatio = (double)targetHeight / zoomedHeight;
        if (widthRatio < heightRatio) {
            return Axis.X;
        }
        return Axis.Y;
    }

    public void align(IReaction reaction, int w, int h, double actualWidth, double actualHeight, double zoom) {
        double b2X = this.params.borderX * 2;
        double b2Y = this.params.borderY * 2;
        double bXz = (double)this.params.borderX * zoom;
        double bYz = (double)this.params.borderY * zoom;
        double ww = ((double)w + b2X) / zoom;
        double hh = ((double)h + b2Y) / zoom;
        Axis expansionAxis = this.getAxisOfExpansion(w, h, actualWidth, actualHeight);
        Params.XAlign xAlign = this.params.leftRightAlignment;
        Params.YAlign yAlign = this.params.topBottomAlignment;
        double boundsCenterX = actualWidth / 2.0;
        double boundsCenterY = actualHeight / 2.0;
        if (expansionAxis != Axis.Y || xAlign != Params.XAlign.LEFT) {
            if (expansionAxis == Axis.Y && xAlign == Params.XAlign.CENTER) {
                double dx = ww / 2.0 - (boundsCenterX + bXz);
                this.shift(reaction, null, dx, 0.0);
            } else if (expansionAxis == Axis.X && yAlign == Params.YAlign.CENTER) {
                double dy = hh / 2.0 - (boundsCenterY + bYz);
                this.shift(reaction, null, 0.0, dy);
            }
        }
    }

    public void drawReactionID(IReaction reaction, int w, Graphics2D g) {
        String id = reaction.getID();
        if (id == null) {
            return;
        }
        g.setColor(Color.BLACK);
        g.drawString(id, w / 2, 10);
    }

    public BoundsTree getReactionBounds(IReaction reaction) {
        return this.reactionLayout.layout(reaction, this.reactionLayout.getAxis());
    }

    public BoundsTree getExactReactionBounds(IReaction reaction, Graphics2D g) {
        BoundsTree tree = this.reactionLayout.layout(reaction, this.reactionLayout.getAxis());
        if (this.exactReactionLayout != null) {
            return this.exactReactionLayout.layout(reaction, g);
        }
        return tree;
    }

    public double calculateZoom(int targetWidth, int targetHeight, Rectangle2D totalBounds) {
        int borderX = this.params.borderX;
        int borderX2 = borderX * 2;
        int borderY = this.params.borderY;
        int borderY2 = borderY * 2;
        double preZoomedWidth = totalBounds.getWidth() + (double)borderX2;
        double preZoomedHeight = totalBounds.getHeight() + (double)borderY2;
        return this.calculateZoom(targetWidth, targetHeight, preZoomedWidth, preZoomedHeight);
    }

    private double calculateZoom(int targetWidth, int targetHeight, double actualWidth, double actualHeight) {
        return Math.min((double)targetWidth / actualWidth, (double)targetHeight / actualHeight);
    }

    public Rectangle2D getDrawnBounds(List<IAtom> atoms) {
        return this.moleculeDrawer.getDrawnBounds(atoms);
    }

    public Vector2d getReactionAxis() {
        return this.reactionLayout.getAxis();
    }

    public void drawMappings(IReaction reaction, Graphics2D g) {
        g.setColor(Color.LIGHT_GRAY);
        for (IMapping mapping : reaction.mappings()) {
            IAtom a0 = (IAtom)mapping.getChemObject(0);
            IAtom a1 = (IAtom)mapping.getChemObject(1);
            Point2d p0 = a0.getPoint2d();
            Point2d p1 = a1.getPoint2d();
            g.drawLine((int)p0.x, (int)p0.y, (int)p1.x, (int)p1.y);
        }
    }

    private Rectangle2D molSetBounds(IAtomContainerSet molSet) {
        Rectangle2D bounds = null;
        for (IAtomContainer ac : molSet.atomContainers()) {
            Rectangle2D currentBounds = GeometryTools.getRectangle2D(ac);
            if (bounds == null) {
                bounds = (Rectangle2D)currentBounds.clone();
                continue;
            }
            bounds.add(currentBounds);
        }
        return bounds;
    }

    public void drawMoleculeSet(IAtomContainerSet reactants, String reactionID, double yAxis, BoundsTree boundsTree, Graphics2D g) {
        this.params.moleculeLabelFontSize = this.params.layoutLeftToRight ? this.params.leftToRightMoleculeLabelFontSize : this.params.topToBottomMoleculeLabelFontSize;
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IAtomContainer current = reactants.getAtomContainer(i);
            if (i > 0) {
                IAtomContainer previous = reactants.getAtomContainer(i - 1);
                String previousLabel = reactionID + "_" + reactants.getID() + "_" + previous.getID() + ":" + (i - 1);
                this.drawPlus(previous, previousLabel, yAxis, boundsTree, g);
                this.moleculeDrawer.drawMolecule(current, g);
                continue;
            }
            this.moleculeDrawer.drawMolecule(current, g);
        }
    }

    public void drawPlus(IAtomContainer ac, String acLabel, double yAxis, BoundsTree boundsTree, Graphics2D g) {
        int plusGap = this.params.plusGap;
        Rectangle2D bounds = boundsTree == null ? GeometryTools.getRectangle2D(ac) : boundsTree.get(acLabel);
        Rectangle2D textBounds = this.getTextBounds(g, "+");
        double tbW = textBounds.getWidth();
        double tbH = textBounds.getHeight();
        double halfWidth = tbW / 2.0;
        double halfHeight = tbH / 2.0;
        double posAlongAxis = bounds.getMaxX() + (double)plusGap + halfWidth;
        Point2f p = this.getTextPoint(g, "+", posAlongAxis, yAxis);
        g.setColor(Color.WHITE);
        g.fill(new Rectangle2D.Double(posAlongAxis - halfWidth, yAxis - halfHeight, tbW, tbH));
        g.setColor(Color.BLACK);
        g.setFont(new Font("ARIAL", 0, this.params.plusFontSize));
        g.drawString("+", p.x, p.y);
    }

    @Override
    public Params getParams() {
        return this.params;
    }

    public void highlightSubgraph(List<IAtom> atoms, Color color) {
        AtomContainer highlightContainer = new AtomContainer();
        for (IAtom atom : atoms) {
            highlightContainer.addAtom(atom);
        }
        this.moleculeDrawer.addHighlights(highlightContainer, color);
    }

    public DirectMoleculeDrawer getMoleculeDrawer() {
        return this.moleculeDrawer;
    }
}

