/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct.awtlayout;

import java.awt.Graphics2D;
import java.util.logging.Logger;
import javax.vecmath.Vector2d;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.graphics.direct.Axis;
import uk.ac.ebi.reactionblast.graphics.direct.Params;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.AbstractAWTReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.LinearAtomContainerSetLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;

public class LeftToRightAWTReactionLayout
extends AbstractAWTReactionLayout {
    private static final Logger LOG = Logger.getLogger(LeftToRightAWTReactionLayout.class.getName());

    public LeftToRightAWTReactionLayout() {
        this(new Params());
    }

    public LeftToRightAWTReactionLayout(Params params) {
        this.params = params;
        this.reactantLayout = new LinearAtomContainerSetLayout(new Vector2d(1.0, 0.0));
        this.productLayout = new LinearAtomContainerSetLayout(new Vector2d(1.0, 0.0));
        this.arrowAxis = Axis.X;
    }

    @Override
    public BoundsTree layout(IReaction reaction, Graphics2D graphics) {
        double arrowCenterX;
        String rxnID = reaction.getID();
        this.reactantBoundsTree = this.reactantLayout.layout(reaction.getReactants(), graphics);
        this.productBoundsTree = this.productLayout.layout(reaction.getProducts(), graphics);
        int borderX = this.params.borderX;
        int borderY = this.params.borderY;
        int arrowGap = this.params.arrowGap;
        int arrowLength = this.params.arrowLength;
        double rbW = this.reactantBoundsTree.getWidth();
        double rbH = this.reactantBoundsTree.getHeight();
        double pbH = this.productBoundsTree.getHeight();
        double maxH = Math.max(rbH, pbH);
        double dx = borderX;
        double dy = (double)borderY + maxH / 2.0;
        this.shiftMoleculeSet(reaction.getReactants(), this.reactantBoundsTree, dx, dy);
        dx = (double)borderX + rbW + (double)arrowLength + (double)(2 * arrowGap);
        this.shiftMoleculeSet(reaction.getProducts(), this.productBoundsTree, dx, dy);
        this.boundsTree = new BoundsTree(rxnID, this.productBoundsTree, this.reactantBoundsTree);
        this.arrowPos = arrowCenterX = (double)borderX + rbW + (double)arrowGap + (double)(arrowLength / 2);
        return this.boundsTree;
    }

    @Override
    public Vector2d getAxis() {
        return new Vector2d(1.0, 0.0);
    }

    @Override
    public BoundsTree layout(IReaction obj, String rootLabel, Graphics2D g) {
        return null;
    }
}

