/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct.awtlayout;

import java.awt.Graphics2D;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.graphics.direct.LabelManager;
import uk.ac.ebi.reactionblast.graphics.direct.Params;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.AbstractAWTLayout;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.AtomLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;

public class MoleculeLayout
extends AbstractAWTLayout<IAtomContainer> {
    private static final Logger LOG = Logger.getLogger(MoleculeLayout.class.getName());
    private AtomLayout atomLayout;

    public MoleculeLayout(Params params) {
        this.atomLayout = new AtomLayout(this, params, new LabelManager());
    }

    public MoleculeLayout(AbstractAWTLayout parent, Params params) {
        this(params);
        this.parent = parent;
    }

    @Override
    public BoundsTree layout(IAtomContainer atomContainer, Graphics2D graphics) {
        return this.layout(atomContainer, atomContainer.getID(), graphics);
    }

    @Override
    public BoundsTree layout(IAtomContainer atomContainer, String rootLabel, Graphics2D graphics) {
        this.atomLayout.reset();
        this.setGraphics(graphics);
        this.currentObject = atomContainer;
        this.boundsTree = new BoundsTree(rootLabel);
        for (IAtom atom : atomContainer.atoms()) {
            this.boundsTree.add(rootLabel, this.atomLayout.layout(atom, graphics));
        }
        return this.boundsTree;
    }
}

