/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct.layout;

import java.awt.geom.Rectangle2D;
import javax.vecmath.Vector2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.graphics.direct.Params;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;
import uk.ac.ebi.reactionblast.graphics.direct.layout.MoleculeAligner;

public abstract class AbstractDirectLayout<T> {
    public static final String INVERTED = "Coordinates Inverted";
    protected Params params;
    protected BoundsTree boundsTree;
    public boolean shouldInvert;

    public AbstractDirectLayout() {
        this(true);
    }

    public AbstractDirectLayout(boolean shouldInvert) {
        this.shouldInvert = shouldInvert;
    }

    public abstract BoundsTree layout(T var1, Vector2d var2);

    public abstract Vector2d getAxis();

    public abstract double getAxisPosition();

    public Params getParams() {
        return this.params;
    }

    public void setParams(Params params) {
        this.params = params;
    }

    public void translateTo(IAtomContainer ac, double x, double y, Rectangle2D bounds) {
        double dx = x - bounds.getCenterX();
        double dy = y - bounds.getCenterY();
        for (IAtom atom : ac.atoms()) {
            atom.getPoint2d().x += dx;
            atom.getPoint2d().y += dy;
        }
        bounds.setRect(bounds.getMinX() + dx, bounds.getMinY() + dy, bounds.getWidth(), bounds.getHeight());
    }

    public void invert(IAtomContainer ac) {
        if (this.shouldInvert && ac.getProperty(INVERTED) == null || !((Boolean)ac.getProperty(INVERTED)).booleanValue()) {
            for (IAtom atom : ac.atoms()) {
                atom.getPoint2d().y *= -1.0;
            }
            ac.setProperty(INVERTED, Boolean.TRUE);
        }
        this.shouldInvert = false;
    }

    public void align(IAtomContainer atomContainer, Vector2d molAxis) {
        switch (this.params.moleculeAlignMethod) {
            case MAX_AXIS: {
                MoleculeAligner.alignToMaxWidth(atomContainer, molAxis);
            }
            case MIN_AREA: {
                MoleculeAligner.alignToMinAreaBox(atomContainer, molAxis);
            }
        }
        MoleculeAligner.alignToMaxWidth(atomContainer, molAxis);
    }
}

