/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct.layout;

import java.util.logging.Logger;
import javax.vecmath.Vector2d;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.graphics.direct.Axis;
import uk.ac.ebi.reactionblast.graphics.direct.layout.AbstractDirectReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;

public class TopToBottomReactionLayout
extends AbstractDirectReactionLayout {
    private static final Logger LOG = Logger.getLogger(TopToBottomReactionLayout.class.getName());

    public TopToBottomReactionLayout() {
        this(true);
    }

    public TopToBottomReactionLayout(boolean shouldInvert) {
        this(shouldInvert, new Vector2d(1.0, 0.0));
    }

    public TopToBottomReactionLayout(boolean shouldInvert, Vector2d moleculeAxis) {
        super(shouldInvert, moleculeAxis);
        this.arrowAxis = Axis.Y;
    }

    @Override
    public BoundsTree layout(IReaction reaction, Vector2d axis) {
        double arrowCenterY;
        Vector2d molSetAxis = new Vector2d(1.0, 0.0);
        this.productBoundsTree = this.productLayout.layout(reaction.getProducts(), molSetAxis);
        this.reactantBoundsTree = this.reactantLayout.layout(reaction.getReactants(), molSetAxis);
        int borderX = this.params.borderX;
        int borderY = this.params.borderY;
        int arrowGap = this.params.arrowGap;
        int arrowLength = this.params.arrowLength;
        double rbH = this.reactantBoundsTree.getHeight();
        double pbH = this.productBoundsTree.getHeight();
        double dx = borderX;
        double dy = (double)borderY + rbH / 2.0;
        this.shiftMoleculeSet(reaction.getReactants(), this.reactantBoundsTree, dx, dy);
        dy = (double)borderY + rbH + (double)arrowLength + (double)(2 * arrowGap) + pbH / 2.0;
        this.shiftMoleculeSet(reaction.getProducts(), this.productBoundsTree, dx, dy);
        this.boundsTree = new BoundsTree("reaction", this.productBoundsTree, this.reactantBoundsTree);
        this.arrowPos = arrowCenterY = (double)borderY + rbH + (double)arrowGap + (double)(arrowLength / 2);
        return this.boundsTree;
    }

    @Override
    public Vector2d getAxis() {
        return new Vector2d(0.0, 1.0);
    }

    @Override
    public double getAxisPosition() {
        return this.boundsTree.getWidth() / 2.0 + (double)this.params.borderX;
    }
}

