/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.Intractable;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.SSSRFinder;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;
import org.openscience.smsd.helper.MoleculeInitializer;
import uk.ac.ebi.reactionblast.mapping.algorithm.GameTheoryRings;

class IsomeraseHandler {
    private static final Logger LOG = Logger.getLogger(IsomeraseHandler.class.getName());
    private final Map<IRingSet, IAtomContainer> ringContainerCountR;
    private final Map<IRingSet, IAtomContainer> ringContainerCountP;
    private final IRingSet sssrEduct;
    private final IRingSet sssrProduct;
    private final boolean DEBUG = false;
    protected final IReaction reaction;

    protected static void initializeMolecule(IAtomContainer atomContainer) throws CDKException {
        MoleculeInitializer.initializeMolecule(atomContainer);
    }

    IsomeraseHandler(IReaction reaction) {
        this.reaction = reaction;
        this.ringContainerCountR = this.getRingContainerCount(reaction.getReactants());
        this.ringContainerCountP = this.getRingContainerCount(reaction.getProducts());
        if (this.ringContainerCountR.size() == 1 && this.ringContainerCountP.size() == 1) {
            IAtomContainer educt = this.ringContainerCountR.values().iterator().next();
            IAtomContainer product = this.ringContainerCountP.values().iterator().next();
            try {
                IsomeraseHandler.initializeMolecule(educt);
            }
            catch (CDKException ex) {
                Logger.getLogger(GameTheoryRings.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                IsomeraseHandler.initializeMolecule(product);
            }
            catch (CDKException ex) {
                Logger.getLogger(GameTheoryRings.class.getName()).log(Level.SEVERE, null, ex);
            }
            SSSRFinder finder = new SSSRFinder(educt);
            this.sssrEduct = finder.findEssentialRings();
            finder = new SSSRFinder(product);
            this.sssrProduct = finder.findEssentialRings();
            boolean bl = this.chipBondInTheRing(educt, product);
        } else {
            this.sssrEduct = null;
            this.sssrProduct = null;
            IAtomContainerSet reactants = reaction.getReactants();
            IAtomContainerSet products = reaction.getProducts();
            if (reactants.getAtomContainerCount() == 1 && products.getAtomContainerCount() == 1) {
                try {
                    IAtomContainer educt = reactants.atomContainers().iterator().next();
                    IAtomContainer product = products.atomContainers().iterator().next();
                    boolean bl = this.chipPhophateInSingleReactantProductNotInRing(educt, product);
                }
                catch (CDKException ex) {
                    Logger.getLogger(IsomeraseHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private Map<IRingSet, IAtomContainer> getRingContainerCount(IAtomContainerSet acs) {
        CycleFinder cycles = Cycles.or(Cycles.all(), Cycles.all());
        HashMap<IRingSet, IAtomContainer> ringSet = new HashMap<IRingSet, IAtomContainer>();
        for (IAtomContainer ac : acs.atomContainers()) {
            try {
                Cycles rings = cycles.find(ac);
                IRingSet basicRings = rings.toRingSet();
                if (basicRings.isEmpty()) continue;
                basicRings.setID(ac.getID());
                ringSet.put(basicRings, ac);
            }
            catch (Intractable ex) {
                Logger.getLogger(IsomeraseHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return ringSet;
    }

    private boolean chipBondInTheRing(IAtomContainer educt, IAtomContainer product) {
        if (this.sssrEduct.getAtomContainerCount() == 1 && this.sssrProduct.getAtomContainerCount() == 1) {
            IAtomContainer ringE = this.sssrEduct.atomContainers().iterator().next();
            IAtomContainer ringP = this.sssrProduct.atomContainers().iterator().next();
            if (ringE.getAtomCount() == 6 && ringP.getAtomCount() == 5) {
                return this.findAndChipBond(ringE, educt);
            }
            if (ringE.getAtomCount() == 5 && ringP.getAtomCount() == 6) {
                return this.findAndChipBond(ringP, product);
            }
        } else if (this.sssrEduct.getAtomContainerCount() == 2 && this.sssrEduct.getAtomContainerCount() == this.sssrProduct.getAtomContainerCount()) {
            return this.findAndChipBondBetweenRings(educt) | this.findAndChipBondBetweenRings(product);
        }
        return false;
    }

    private boolean chipPhophateInSingleReactantProductNotInRing(IAtomContainer educt, IAtomContainer product) throws CDKException {
        if (this.ringContainerCountR.isEmpty() && this.ringContainerCountP.isEmpty()) {
            String phosphateSMILES = "OP(O)(O)=O";
            SMARTSQueryTool smartsPhosphate = new SMARTSQueryTool(phosphateSMILES, DefaultChemObjectBuilder.getInstance());
            boolean matchesE = smartsPhosphate.matches(educt);
            boolean matchesP = smartsPhosphate.matches(product);
            if (matchesE && matchesP) {
                boolean findAndChipBondPhophate1 = this.findAndChipBondPhophate(educt);
                boolean findAndChipBondPhophate2 = this.findAndChipBondPhophate(product);
                return findAndChipBondPhophate1 && findAndChipBondPhophate2;
            }
        }
        return false;
    }

    private boolean findAndChipBond(IAtomContainer container, IAtomContainer referenceContainer) {
        boolean flag = false;
        if (container != null) {
            for (IBond bond : container.bonds()) {
                if ((!bond.getAtom(0).getSymbol().equalsIgnoreCase("O") || !bond.getAtom(1).getSymbol().equalsIgnoreCase("C")) && (!bond.getAtom(0).getSymbol().equalsIgnoreCase("C") || !bond.getAtom(1).getSymbol().equalsIgnoreCase("O")) || bond.getAtom(0).getFlag(32) || bond.getAtom(1).getFlag(32) || !referenceContainer.contains(bond)) continue;
                IAtom atom = bond.getAtom(0).getSymbol().equalsIgnoreCase("C") ? bond.getAtom(0) : bond.getAtom(1);
                List<IBond> neighbourhoodBonds = referenceContainer.getConnectedBondsList(atom);
                flag = false;
                for (IBond neighbourhoodBond : neighbourhoodBonds) {
                    if (!neighbourhoodBond.contains(atom) || neighbourhoodBond.getFlag(2) || (!neighbourhoodBond.getAtom(0).getSymbol().equalsIgnoreCase("O") || !neighbourhoodBond.getAtom(1).getSymbol().equalsIgnoreCase("C")) && (!neighbourhoodBond.getAtom(0).getSymbol().equalsIgnoreCase("C") || !neighbourhoodBond.getAtom(1).getSymbol().equalsIgnoreCase("O"))) continue;
                    flag = true;
                }
                if (!flag) continue;
                referenceContainer.removeBond(bond);
                break;
            }
        }
        return flag;
    }

    private boolean findAndChipBondPhophate(IAtomContainer container) {
        boolean flag = false;
        for (IBond bond : container.bonds()) {
            IAtom oxygen;
            List<IBond> neighbourBonds;
            IAtom atomE = bond.getAtom(0);
            IAtom atomP = bond.getAtom(1);
            if ((!atomE.getSymbol().equals("O") || !atomP.getSymbol().equals("P")) && (!atomE.getSymbol().equals("P") || !atomP.getSymbol().equals("O")) || !bond.getOrder().equals((Object)IBond.Order.SINGLE) || (neighbourBonds = container.getConnectedBondsList(oxygen = atomE.getSymbol().equals("O") ? atomE : atomP)).size() != 2) continue;
            for (IBond b : neighbourBonds) {
                if (!b.getAtom(0).getSymbol().equals("O") && !b.getAtom(0).getSymbol().equals("P") || !b.getAtom(1).getSymbol().equals("O") && !b.getAtom(1).getSymbol().equals("P")) continue;
                container.removeBond(b);
            }
            return true;
        }
        return flag;
    }

    private boolean findAndChipBondBetweenRings(IAtomContainer container) {
        ArrayList<IBond> bond_to_be_removed = new ArrayList<IBond>();
        for (IAtom atom : container.atoms()) {
            if (!atom.getSymbol().equals("O")) continue;
            int number_of_rings = (Integer)atom.getProperty("cdk:RingConnections");
            List<IBond> bonds = container.getConnectedBondsList(atom);
            if (bonds.size() != 2 || number_of_rings != 2) continue;
            IBond bondToBeChipped = bonds.iterator().next();
            bond_to_be_removed.add(bondToBeChipped);
        }
        for (IBond bond : bond_to_be_removed) {
            container.removeBond(bond);
        }
        return !bond_to_be_removed.isEmpty();
    }
}

