/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm.checks;

import java.io.IOException;
import java.io.Serializable;
import org.openscience.cdk.exception.CDKException;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;
import uk.ac.ebi.reactionblast.mapping.container.ReactionContainer;
import uk.ac.ebi.reactionblast.tools.EBIMatrix;

public abstract class Selector
implements Serializable {
    int rowSize;
    int colSize;
    boolean[][] flagMatrix;

    public static synchronized Holder modifyMatrix(Holder orignal) throws IOException, CDKException, CloneNotSupportedException {
        ReactionContainer reactionStructureInformationContainer = orignal.getReactionContainer();
        Holder localHolder = (Holder)orignal.clone();
        int inputRowSize = orignal.getCliqueMatrix().getRowDimension();
        int inputColSize = orignal.getCliqueMatrix().getColumnDimension();
        for (int i = 0; i < inputRowSize; ++i) {
            for (int j = 0; j < inputColSize; ++j) {
                double totalAtomCount = reactionStructureInformationContainer.getProduct(j).getAtomCount() + reactionStructureInformationContainer.getEduct(i).getAtomCount();
                double cliqueValue = orignal.getCliqueMatrix().getValue(i, j);
                double simValue = cliqueValue / totalAtomCount;
                if (!(cliqueValue >= 1.0)) continue;
                localHolder.getGraphSimilarityMatrix().set(i, j, simValue);
            }
        }
        return localHolder;
    }

    protected synchronized boolean isMajorSubgraphColumn(Holder mh, int IndexI, int IndexJ) throws IOException, CDKException {
        double queryColScore = mh.getCliqueMatrix().getValue(IndexI, IndexJ);
        if (queryColScore > 0.0) {
            for (int col = 0; col < this.colSize; ++col) {
                double colCSize;
                if (!this.flagMatrix[IndexI][col] || col == IndexJ || !(queryColScore < (colCSize = mh.getCliqueMatrix().getValue(IndexI, col)))) continue;
                return false;
            }
        }
        return true;
    }

    protected synchronized boolean isMajorSubgraphRow(Holder mh, int IndexI, int IndexJ) throws IOException, CDKException {
        double queryRowScore = mh.getCliqueMatrix().getValue(IndexI, IndexJ);
        if (queryRowScore > 0.0) {
            for (int row = 0; row < this.rowSize; ++row) {
                if (!this.flagMatrix[row][IndexJ] || row == IndexI) continue;
                int eSize = mh.getReactionContainer().getEduct(row).getAtomCount();
                double rowRSize = mh.getCliqueMatrix().getValue(row, IndexJ);
                if (!(queryRowScore < rowRSize)) continue;
                return false;
            }
        }
        return true;
    }

    protected synchronized boolean isMinEnergyColumn(Holder mh, int IndexI, int IndexJ) throws IOException, CDKException {
        double refEnergy = mh.getEnergyMatrix().getValue(IndexI, IndexJ);
        if (mh.getCliqueMatrix().getValue(IndexI, IndexJ) > 0.0) {
            for (int col = 0; col < this.colSize; ++col) {
                if (!this.flagMatrix[IndexI][col] || col == IndexJ) continue;
                double colEnergy = mh.getEnergyMatrix().getValue(IndexI, col);
                if (!(refEnergy > 0.0) || !(colEnergy > 0.0) || !(refEnergy > colEnergy)) continue;
                return false;
            }
        }
        return true;
    }

    protected synchronized boolean isMinEnergyRow(Holder mh, int IndexI, int IndexJ) throws IOException, CDKException {
        double refEnergy = mh.getEnergyMatrix().getValue(IndexI, IndexJ);
        if (mh.getCliqueMatrix().getValue(IndexI, IndexJ) > 0.0) {
            for (int row = 0; row < this.rowSize; ++row) {
                double rowEnergy;
                if (!this.flagMatrix[row][IndexJ] || row == IndexI || !((rowEnergy = mh.getEnergyMatrix().getValue(row, IndexJ)) > 0.0) || !(refEnergy > 0.0) || !(refEnergy > rowEnergy)) continue;
                return false;
            }
        }
        return true;
    }

    protected synchronized boolean isMinorSubgraphColumn(Holder mh, int IndexI, int IndexJ) throws IOException, CDKException {
        boolean flag = true;
        double queryColScore = mh.getCliqueMatrix().getValue(IndexI, IndexJ);
        if (queryColScore > 0.0) {
            for (int col = 0; col < this.colSize; ++col) {
                double targetColScore;
                if (!this.flagMatrix[IndexI][col] || col == IndexJ || !(queryColScore > (targetColScore = mh.getCliqueMatrix().getValue(IndexI, col))) || !(targetColScore > 0.0)) continue;
                return true;
            }
        }
        return flag;
    }

    protected synchronized boolean isMinorSubgraphRow(Holder mh, int IndexI, int IndexJ) {
        boolean flag = true;
        double queryRowScore = mh.getCliqueMatrix().getValue(IndexI, IndexJ);
        if (queryRowScore > 0.0) {
            for (int row = 0; row < this.rowSize; ++row) {
                double targetRowScore;
                if (!this.flagMatrix[row][IndexJ] || row == IndexI || !(queryRowScore > (targetRowScore = mh.getCliqueMatrix().getValue(row, IndexJ))) || !(targetRowScore > 0.0)) continue;
                return false;
            }
        }
        return flag;
    }

    protected synchronized boolean isMinorSubgraphColumn(EBIMatrix similarityMatrix, int IndexI, int IndexJ) {
        boolean flag = true;
        double queryColScore = similarityMatrix.getValue(IndexI, IndexJ);
        if (queryColScore > 0.0) {
            for (int col = 0; col < this.colSize; ++col) {
                double targetColScore;
                if (!this.flagMatrix[IndexI][col] || col == IndexJ || !(queryColScore > (targetColScore = similarityMatrix.getValue(IndexI, col))) || !(targetColScore > 0.0)) continue;
                return true;
            }
        }
        return flag;
    }

    protected synchronized boolean isMinorSubgraphRow(EBIMatrix similarityMatrix, int IndexI, int IndexJ) {
        boolean flag = true;
        double queryRowScore = similarityMatrix.getValue(IndexI, IndexJ);
        if (queryRowScore > 0.0) {
            for (int row = 0; row < this.rowSize; ++row) {
                double targetRowScore;
                if (!this.flagMatrix[row][IndexJ] || row == IndexI || !(queryRowScore > (targetRowScore = similarityMatrix.getValue(row, IndexJ))) || !(targetRowScore > 0.0)) continue;
                return false;
            }
        }
        return flag;
    }

    protected synchronized boolean isMajorSubgraphColumn(EBIMatrix similarityMatrix, int IndexI, int IndexJ) {
        double queryColumnscore = similarityMatrix.getValue(IndexI, IndexJ);
        if (queryColumnscore > 0.0) {
            for (int col = 0; col < this.colSize; ++col) {
                double colCSize;
                if (!this.flagMatrix[IndexI][col] || col == IndexJ || !(queryColumnscore < (colCSize = similarityMatrix.getValue(IndexI, col)))) continue;
                return false;
            }
        }
        return true;
    }

    protected synchronized boolean isMajorSubgraphRow(EBIMatrix similarityMatrix, int IndexI, int IndexJ) {
        double queryRowScore = similarityMatrix.getValue(IndexI, IndexJ);
        if (queryRowScore > 0.0) {
            for (int row = 0; row < this.rowSize; ++row) {
                double rowRSize;
                if (!this.flagMatrix[row][IndexJ] || row == IndexI || !(queryRowScore < (rowRSize = similarityMatrix.getValue(row, IndexJ)))) continue;
                return false;
            }
        }
        return true;
    }
}

