/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.blocks;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.mapping.blocks.SubgraphMoleculeSignature;

public class Block
implements Comparable<Block> {
    private static final Logger LOG = Logger.getLogger(Block.class.getName());
    private final IAtomContainer atomContainer;
    private final Map<IAtom, IAtom> atomMap;
    private SubgraphMoleculeSignature subgraphSignature;
    private String signatureString;
    private Point2d centerPoint;
    private Rectangle2D bounds;
    private Block partner;

    public Block(IAtomContainer atomContainer) {
        this.atomContainer = atomContainer;
        this.atomMap = new HashMap<IAtom, IAtom>();
    }

    public int[] getMappingPermutation() {
        int[] mappingPermutation = new int[this.atomMap.size()];
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        for (IAtom atom : this.atomMap.keySet()) {
            int atomIndex = this.atomContainer.getAtomNumber(atom);
            IAtom partnerAtom = this.atomMap.get(atom);
            int partnerIndex = this.partner.atomContainer.getAtomNumber(partnerAtom);
            indexMap.put(atomIndex, partnerIndex);
        }
        Map<Integer, Integer> compactMap = this.getCompactMap(new ArrayList<Integer>(indexMap.keySet()));
        Map<Integer, Integer> compactPartnerMap = this.getCompactMap(new ArrayList<Integer>(indexMap.values()));
        for (Integer index : indexMap.keySet()) {
            mappingPermutation[compactMap.get((Object)index).intValue()] = compactPartnerMap.get(indexMap.get(index));
        }
        return mappingPermutation;
    }

    private Map<Integer, Integer> getCompactMap(List<Integer> indices) {
        HashMap<Integer, Integer> compactMap = new HashMap<Integer, Integer>();
        Collections.sort(indices);
        int compactIndex = 0;
        for (Integer index : indices) {
            compactMap.put(index, compactIndex);
            ++compactIndex;
        }
        return compactMap;
    }

    public void setPartner(Block partner) {
        this.partner = partner;
    }

    public Block getPartner() {
        return this.partner;
    }

    public void addMapping(IAtom atom, IAtom partner) {
        this.atomMap.put(atom, partner);
    }

    public void setCenterPoint(Point2d centerPoint) {
        this.centerPoint = centerPoint;
    }

    public Point2d getCenterPoint() {
        if (this.centerPoint == null) {
            Rectangle2D b = this.getBounds();
            this.centerPoint = new Point2d(b.getCenterX(), b.getCenterY());
        }
        return this.centerPoint;
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            IAtomContainer tmp = this.atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            tmp.setAtoms(this.getAtoms().toArray(new IAtom[0]));
            this.bounds = this.calculateBounds(tmp);
        }
        return this.bounds;
    }

    private Rectangle2D calculateBounds(IAtomContainer atomContainer) {
        Rectangle2D b = null;
        for (IAtom atom : atomContainer.atoms()) {
            Point2d p = atom.getPoint2d();
            if (b == null) {
                b = new Rectangle2D.Double(p.x, p.y, 0.0, 0.0);
                continue;
            }
            b.add(p.x, p.y);
        }
        return b;
    }

    @Override
    public int compareTo(Block o) {
        return this.getSignatureString().compareTo(o.getSignatureString());
    }

    public int getAtomCount() {
        return this.atomMap.size();
    }

    public int[] getLabels() {
        return this.getSubgraphSignature().getCanonicalLabels();
    }

    public SubgraphMoleculeSignature getSubgraphSignature() {
        if (this.subgraphSignature == null) {
            this.subgraphSignature = new SubgraphMoleculeSignature(this.atomContainer, this.getAtoms(), -1);
        }
        return this.subgraphSignature;
    }

    public String getSignatureString() {
        if (this.signatureString == null) {
            this.signatureString = this.getSubgraphSignature().toCanonicalString();
        }
        return this.signatureString;
    }

    public IAtomContainer getAtomContainer() {
        return this.atomContainer;
    }

    public List<IAtom> getAtoms() {
        return new ArrayList<IAtom>(this.atomMap.keySet());
    }

    private List<Integer> getIndices(List<IAtom> atoms, IAtomContainer container) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (IAtom atom : atoms) {
            indices.add(container.getAtomNumber(atom));
        }
        return indices;
    }

    public String toString() {
        return this.atomContainer.getID() + " " + this.getIndices(this.getAtoms(), this.atomContainer) + " " + this.getSignatureString();
    }
}

