/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import uk.ac.ebi.reactionblast.mapping.blocks.Block;
import uk.ac.ebi.reactionblast.mapping.blocks.BlockList;
import uk.ac.ebi.reactionblast.mapping.blocks.BlockPair;
import uk.ac.ebi.reactionblast.mapping.blocks.MappingGraph;

public class BlockMapping {
    private static final Logger LOG = Logger.getLogger(BlockMapping.class.getName());
    private final IReaction reaction;
    private final List<Block> reactantBlocks;
    private final List<Block> productBlocks;
    private final Map<IAtomContainer, BlockList> reactantBlockMap;
    private final Map<IAtomContainer, BlockList> productBlockMap;
    private final List<BlockPair> blockPairs;

    public BlockMapping(IReaction reaction) {
        this.reaction = reaction;
        this.reactantBlocks = new ArrayList<Block>();
        this.productBlocks = new ArrayList<Block>();
        this.reactantBlockMap = new HashMap<IAtomContainer, BlockList>();
        this.productBlockMap = new HashMap<IAtomContainer, BlockList>();
        MappingGraph mappingGraph = new MappingGraph(reaction);
        this.blockPairs = mappingGraph.createBlockPairs(reaction);
        for (BlockPair pair2 : this.blockPairs) {
            Block reactantBlock = pair2.getReactantBlock();
            Block productBlock = pair2.getProductBlock();
            this.reactantBlocks.add(reactantBlock);
            this.productBlocks.add(productBlock);
            this.addBlockToAtomContainerMap(reactantBlock, this.reactantBlockMap);
            this.addBlockToAtomContainerMap(productBlock, this.productBlockMap);
        }
    }

    public List<BlockPair> getBlockPairs() {
        return this.blockPairs;
    }

    public List<Block> getReactantBlocks() {
        return this.reactantBlocks;
    }

    public List<Block> getProductBlocks() {
        return this.productBlocks;
    }

    public IReaction getReaction() {
        return this.reaction;
    }

    private void addBlockToAtomContainerMap(Block block, Map<IAtomContainer, BlockList> map) {
        BlockList blocksForContainer;
        IAtomContainer key = block.getAtomContainer();
        if (map.containsKey(key)) {
            blocksForContainer = map.get(key);
        } else {
            blocksForContainer = new BlockList();
            map.put(key, blocksForContainer);
        }
        blocksForContainer.add(block);
    }

    public int[] getTotalPermutation() {
        int n = ReactionManipulator.getAtomCount(this.reaction);
        int[] totalPermutation = new int[n];
        int totalIndex = 0;
        int offset = 0;
        int[] reactantPermutation = this.getPermutationOfReactants();
        IAtomContainerSet reactants = this.reaction.getReactants();
        for (int i = 0; i < this.reaction.getReactantCount(); ++i) {
            int permutedReactantIndex = reactantPermutation[i];
            IAtomContainer reactant = reactants.getAtomContainer(permutedReactantIndex);
            BlockList blockList = this.reactantBlockMap.get(reactant);
            int[] atomContainerPermutation = blockList.getAtomContainerPermutation();
            for (int j = 0; j < atomContainerPermutation.length; ++j) {
                int x = atomContainerPermutation[j];
                totalPermutation[totalIndex] = offset + x;
                ++totalIndex;
            }
            offset += atomContainerPermutation.length;
        }
        int[] productPermutation = this.getPermutationOfProducts();
        IAtomContainerSet products = this.reaction.getProducts();
        for (int i = 0; i < this.reaction.getProductCount(); ++i) {
            int permutedProductIndex = productPermutation[i];
            IAtomContainer product = products.getAtomContainer(permutedProductIndex);
            BlockList blockList = this.productBlockMap.get(product);
            int[] atomContainerPermutation = blockList.getAtomContainerPermutation();
            for (int j = 0; j < atomContainerPermutation.length; ++j) {
                int x = atomContainerPermutation[j];
                totalPermutation[totalIndex] = offset + x;
                ++totalIndex;
            }
            offset += atomContainerPermutation.length;
        }
        return totalPermutation;
    }

    public int[] getPermutationOfReactants() {
        return this.getContainerPermutation(this.reaction.getReactants(), this.reactantBlockMap);
    }

    public int[] getContainerPermutationForReactant(IAtomContainer reactant) {
        return this.reactantBlockMap.get(reactant).getAtomContainerPermutation();
    }

    public int[] getPermutationOfProducts() {
        return this.getContainerPermutation(this.reaction.getProducts(), this.productBlockMap);
    }

    public int[] getContainerPermutationForProduct(IAtomContainer product) {
        return this.productBlockMap.get(product).getAtomContainerPermutation();
    }

    private int[] getContainerPermutation(IAtomContainerSet containers, Map<IAtomContainer, BlockList> map) {
        int n = containers.getAtomContainerCount();
        HashMap<BlockList, Integer> blockListToOriginalOrderMap = new HashMap<BlockList, Integer>();
        for (int i = 0; i < n; ++i) {
            IAtomContainer container = containers.getAtomContainer(i);
            BlockList blockList = map.get(container);
            if (blockList == null) continue;
            blockListToOriginalOrderMap.put(blockList, i);
        }
        ArrayList blockListKeys = new ArrayList(blockListToOriginalOrderMap.keySet());
        Collections.sort(blockListKeys);
        int[] containerPermutation = new int[n];
        int index = 0;
        for (BlockList blockList : blockListKeys) {
            int originalOrder;
            containerPermutation[index] = originalOrder = ((Integer)blockListToOriginalOrderMap.get(blockList)).intValue();
            ++index;
        }
        return containerPermutation;
    }

    public BlockList getBlockListForReactant(IAtomContainer container) {
        return this.reactantBlockMap.get(container);
    }

    public BlockList getBlockListForProduct(IAtomContainer container) {
        return this.productBlockMap.get(container);
    }

    public String toString() {
        String rbm = "{";
        for (IAtomContainer r : this.reactantBlockMap.keySet()) {
            rbm = rbm + r.getID() + ":" + this.reactantBlockMap.get(r) + "\n";
        }
        rbm = rbm + "}\n";
        String pbm = "{";
        for (IAtomContainer p : this.productBlockMap.keySet()) {
            pbm = pbm + p.getID() + ":" + this.productBlockMap.get(p) + "\n";
        }
        pbm = pbm + "}\n";
        return this.reactantBlocks.toString() + "\n" + this.productBlocks.toString() + "\n" + rbm + pbm;
    }
}

