/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMapping;
import uk.ac.ebi.reactionblast.mapping.blocks.Block;

public class BlockPair {
    private static final Logger LOG = Logger.getLogger(BlockPair.class.getName());
    private final Block reactantBlock;
    private final Block productBlock;
    private final List<IMapping> mappings = new ArrayList<IMapping>();

    public BlockPair(IAtomContainer reactant, IAtomContainer product) {
        this.reactantBlock = new Block(reactant);
        this.productBlock = new Block(product);
        this.reactantBlock.setPartner(this.productBlock);
        this.productBlock.setPartner(this.reactantBlock);
    }

    public void addMapping(IMapping mapping, IAtom rAtom, IAtom pAtom) {
        this.mappings.add(mapping);
        this.reactantBlock.addMapping(rAtom, pAtom);
        this.productBlock.addMapping(pAtom, rAtom);
    }

    public Block getReactantBlock() {
        return this.reactantBlock;
    }

    public Block getProductBlock() {
        return this.productBlock;
    }

    public String toString() {
        return this.reactantBlock + "-" + this.productBlock;
    }
}

