/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.blocks;

import java.util.List;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public class DefinedMapping {
    private static final Logger LOG = Logger.getLogger(DefinedMapping.class.getName());
    private final IAtomContainer rAtomContainer;
    private final IAtomContainer pAtomContainer;
    private final int rIndex;
    private final int pIndex;
    private boolean visited = false;
    private final int index;

    public DefinedMapping(int rIndex, int pIndex, int index, IAtomContainer rAtomContainer, IAtomContainer pAtomContainer) {
        this.rIndex = rIndex;
        this.pIndex = pIndex;
        this.index = index;
        this.rAtomContainer = rAtomContainer;
        this.pAtomContainer = pAtomContainer;
    }

    public IAtom getRAtom() {
        return this.getrAtomContainer().getAtom(this.getrIndex());
    }

    public List<IAtom> getRAtomNeighbours() {
        return this.getrAtomContainer().getConnectedAtomsList(this.getRAtom());
    }

    public IAtom getPAtom() {
        return this.getpAtomContainer().getAtom(this.getpIndex());
    }

    public List<IAtom> getPAtomNeighbours() {
        return this.getpAtomContainer().getConnectedAtomsList(this.getPAtom());
    }

    public boolean equals(Object o) {
        if (o instanceof DefinedMapping) {
            DefinedMapping other = (DefinedMapping)o;
            return this.getrAtomContainer() == other.getrAtomContainer() && this.getpAtomContainer() == other.getpAtomContainer() && this.getrIndex() == other.getrIndex() && this.getpIndex() == other.getpIndex();
        }
        return false;
    }

    public int hashCode() {
        return this.getrAtomContainer().hashCode() ^ this.getpAtomContainer().hashCode() * this.getrIndex() * this.getpIndex();
    }

    public String toString() {
        return String.format("rI:%s pI:%s i:%s rID:%s pID:%s", this.getrIndex(), this.getpIndex(), this.getIndex(), this.getrAtomContainer().getID(), this.getpAtomContainer().getID());
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public IAtomContainer getrAtomContainer() {
        return this.rAtomContainer;
    }

    public IAtomContainer getpAtomContainer() {
        return this.pAtomContainer;
    }

    public int getrIndex() {
        return this.rIndex;
    }

    public int getpIndex() {
        return this.pIndex;
    }

    public int getIndex() {
        return this.index;
    }
}

