/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.blocks;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import signature.AbstractVertexSignature;

public class SubgraphAtomSignature
extends AbstractVertexSignature {
    private static final Logger LOG = Logger.getLogger(SubgraphAtomSignature.class.getName());
    private final IAtomContainer atomContainer;
    private Map<Integer, int[]> subgraphAdjacencyLists;
    private boolean useAdjLists = false;

    public SubgraphAtomSignature(IAtomContainer atomContainer, int atomIndex) {
        this.atomContainer = atomContainer;
        super.createMaximumHeight(atomIndex, atomContainer.getAtomCount());
    }

    public SubgraphAtomSignature(IAtomContainer atomContainer, int atomIndex, Map<Integer, int[]> subgraphAdjacencyLists) {
        this.useAdjLists = true;
        this.atomContainer = atomContainer;
        this.subgraphAdjacencyLists = subgraphAdjacencyLists;
        int graphVertexCount = atomContainer.getAtomCount();
        super.createMaximumHeight(atomIndex, graphVertexCount);
    }

    @Override
    protected int[] getConnected(int atomIndex) {
        if (this.useAdjLists) {
            if (this.subgraphAdjacencyLists.containsKey(atomIndex)) {
                return this.subgraphAdjacencyLists.get(atomIndex);
            }
            return new int[0];
        }
        List<IAtom> connectedAtoms = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(atomIndex));
        int[] connected = new int[connectedAtoms.size()];
        int i = 0;
        for (IAtom connectedAtom : connectedAtoms) {
            connected[i] = this.atomContainer.getAtomNumber(connectedAtom);
            ++i;
        }
        return connected;
    }

    @Override
    protected String getEdgeLabel(int atomIndexA, int atomIndexB) {
        IAtom atomB;
        IAtom atomA = this.atomContainer.getAtom(atomIndexA);
        IBond bond = this.atomContainer.getBond(atomA, atomB = this.atomContainer.getAtom(atomIndexB));
        if (bond.getFlag(32)) {
            return "@";
        }
        if (bond.getFlag(2)) {
            return "%";
        }
        switch (bond.getOrder()) {
            case SINGLE: {
                return "";
            }
            case DOUBLE: {
                return "=";
            }
            case TRIPLE: {
                return "#";
            }
            case QUADRUPLE: {
                return "$";
            }
        }
        return "";
    }

    @Override
    protected int getIntLabel(int arg0) {
        return 0;
    }

    @Override
    protected String getVertexSymbol(int atomIndex) {
        IAtom atom = this.atomContainer.getAtom(atomIndex);
        try {
            Integer charge = atom.getFormalCharge();
            if (charge == null || charge == 0) {
                return atom.getSymbol();
            }
            return atom.getSymbol() + charge;
        }
        catch (NullPointerException npe) {
            System.out.println("npe getting atom " + atomIndex + " from " + this.atomContainer.getID());
            npe.printStackTrace();
            return "C";
        }
    }

    @Override
    protected int convertEdgeLabelToColor(String edgeLabel) {
        switch (edgeLabel) {
            case "": {
                return 1;
            }
            case "=": {
                return 2;
            }
            case "#": {
                return 3;
            }
            case "$": {
                return 4;
            }
            case "@": {
                return 5;
            }
            case "%": {
                return 6;
            }
        }
        return 0;
    }
}

