/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.container;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import uk.ac.ebi.reactionblast.mapping.container.helper.MolMapping;

public class MoleculeMoleculeMapping
implements Serializable {
    private static final long serialVersionUID = 1094750239472059259L;
    private static final Logger LOG = Logger.getLogger(MoleculeMoleculeMapping.class.getName());
    private final Map<String, List<MolMapping>> reactant_product_mapping_map = Collections.synchronizedMap(new HashMap());

    public String toString() {
        return "MoleculeMoleculeMapping{reactant_product_mapping_map=" + this.reactant_product_mapping_map + '}';
    }

    public synchronized void Clear() throws IOException {
        this.reactant_product_mapping_map.clear();
    }

    public synchronized void Erase(String Key2) throws IOException {
        this.reactant_product_mapping_map.remove(Key2);
    }

    public synchronized boolean isPresent(String Key2) throws IOException {
        return this.reactant_product_mapping_map.containsKey(Key2);
    }

    public synchronized void setMolMappings(String Key2, List<MolMapping> Value2) throws IOException {
        this.reactant_product_mapping_map.put(Key2, Value2);
    }

    public synchronized List<MolMapping> getMolMappings(String RID) throws CDKException {
        return this.reactant_product_mapping_map.containsKey(RID) ? this.reactant_product_mapping_map.get(RID) : null;
    }

    public synchronized long getCount() {
        return this.reactant_product_mapping_map.size();
    }

    public synchronized Set<String> getKeySet() {
        return this.reactant_product_mapping_map.keySet();
    }

    public synchronized Set<Map.Entry<String, List<MolMapping>>> getEntrySet() {
        return this.reactant_product_mapping_map.entrySet();
    }

    public synchronized List<MolMapping> getMapping(String reactionID, String rName, String pName) {
        List<MolMapping> mMap = this.reactant_product_mapping_map.get(reactionID);
        ArrayList<MolMapping> mappedMap = new ArrayList<MolMapping>();
        for (MolMapping map : mMap) {
            if ((!map.getTarget().equalsIgnoreCase(rName) || !map.getQuery().equalsIgnoreCase(pName)) && (!map.getTarget().equalsIgnoreCase(pName) || !map.getQuery().equalsIgnoreCase(rName))) continue;
            mappedMap.add(map);
        }
        return mappedMap;
    }
}

