/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.container.helper;

import java.io.Serializable;
import java.util.Objects;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;

public class MolMapping
implements Serializable {
    private static final long serialVersionUID = 1738327023703717L;
    private static final Logger LOG = Logger.getLogger(MolMapping.class.getName());
    private final String mol1;
    private final String mol2;
    private final Integer indexI;
    private final Integer indexJ;
    private Integer indexStep = 0;
    private boolean keggMapping;
    private boolean rBLASTMapping;
    private IAtomContainer matchedMol = null;
    private String matchedSMILES = null;

    public MolMapping(String mol1, String mol2, Integer indexI, Integer indexJ) {
        this.mol1 = mol1;
        this.mol2 = mol2;
        this.indexI = indexI;
        this.indexJ = indexJ;
        this.keggMapping = false;
        this.rBLASTMapping = false;
    }

    public String getQuery() {
        return this.mol1;
    }

    public String getTarget() {
        return this.mol2;
    }

    public synchronized boolean isKeggMapping() {
        return this.keggMapping;
    }

    public synchronized void setKeggMapping(boolean keggMapping) {
        this.keggMapping = keggMapping;
    }

    public synchronized boolean isrBLASTMapping() {
        return this.rBLASTMapping;
    }

    public synchronized void setReactionMapping(boolean rBLASTMapping) {
        this.rBLASTMapping = rBLASTMapping;
    }

    public synchronized Integer getIndexI() {
        return this.indexI;
    }

    public synchronized Integer getIndexJ() {
        return this.indexJ;
    }

    public synchronized IAtomContainer getMatchedMol() {
        return this.matchedMol;
    }

    public synchronized void setMatchedMol(IAtomContainer matchedMol) {
        this.matchedMol = matchedMol;
    }

    public synchronized String getMatchedSMILES() {
        return this.matchedSMILES;
    }

    public synchronized void setMatchedSMILES(String matchedSMILES, Integer step) {
        this.matchedSMILES = matchedSMILES;
        this.setIndexStep(step);
    }

    public synchronized Integer getIndexStep() {
        return this.indexStep;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MolMapping other = (MolMapping)obj;
        if (this.mol1 == null ? other.mol1 != null : !this.mol1.equals(other.mol1)) {
            return false;
        }
        if (this.mol2 == null ? other.mol2 != null : !this.mol2.equals(other.mol2)) {
            return false;
        }
        if (!(Objects.equals(this.indexI, other.indexI) || this.indexI != null && this.indexI.equals(other.indexI))) {
            return false;
        }
        if (!(Objects.equals(this.indexJ, other.indexJ) || this.indexJ != null && this.indexJ.equals(other.indexJ))) {
            return false;
        }
        if (!(Objects.equals(this.indexStep, other.indexStep) || this.indexStep != null && this.indexStep.equals(other.indexStep))) {
            return false;
        }
        if (this.keggMapping != other.keggMapping) {
            return false;
        }
        if (this.rBLASTMapping != other.rBLASTMapping) {
            return false;
        }
        if (!(this.matchedMol == other.matchedMol || this.matchedMol != null && this.matchedMol.equals(other.matchedMol))) {
            return false;
        }
        return !(this.matchedSMILES != null ? !this.matchedSMILES.equals(other.matchedSMILES) : other.matchedSMILES != null);
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + (this.mol1 != null ? this.mol1.hashCode() : 0);
        hash = 83 * hash + (this.mol2 != null ? this.mol2.hashCode() : 0);
        hash = 83 * hash + (this.indexI != null ? this.indexI.hashCode() : 0);
        hash = 83 * hash + (this.indexJ != null ? this.indexJ.hashCode() : 0);
        hash = 83 * hash + (this.indexStep != null ? this.indexStep.hashCode() : 0);
        hash = 83 * hash + (this.keggMapping ? 1 : 0);
        hash = 83 * hash + (this.rBLASTMapping ? 1 : 0);
        hash = 83 * hash + (this.matchedMol != null ? this.matchedMol.hashCode() : 0);
        hash = 83 * hash + (this.matchedSMILES != null ? this.matchedSMILES.hashCode() : 0);
        return hash;
    }

    private synchronized void setIndexStep(Integer indexStep) {
        this.indexStep = indexStep;
    }

    public String toString() {
        return "MolMapping{mol1=" + this.mol1 + ", mol2=" + this.mol2 + ", indexI=" + this.indexI + ", indexJ=" + this.indexJ + ", indexStep=" + this.indexStep + ", keggMapping=" + this.keggMapping + ", rBLASTMapping=" + this.rBLASTMapping + ", matchedMol=" + this.matchedMol + ", matchedSMILES=" + this.matchedSMILES + '}';
    }
}

