/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.fixer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;

public class MappingReferenceResolver {
    private static final Logger LOG = Logger.getLogger(MappingReferenceResolver.class.getName());

    public static void resolveReferences(IReaction reaction) {
        int count;
        HashMap<String, IAtom> atomIDLookup = new HashMap<String, IAtom>();
        IAtomContainerSet reactants = reaction.getReactants();
        IAtomContainerSet products = reaction.getProducts();
        MappingReferenceResolver.fillMap(reactants, atomIDLookup, "R");
        MappingReferenceResolver.fillMap(products, atomIDLookup, "P");
        ArrayList<IMapping> resolvedMappings = new ArrayList<IMapping>();
        IChemObjectBuilder builder = reaction.getBuilder();
        for (IMapping mapping : reaction.mappings()) {
            IAtom a0 = (IAtom)mapping.getChemObject(0);
            IAtom a1 = (IAtom)mapping.getChemObject(1);
            IAtom rAtom = (IAtom)atomIDLookup.get("R" + a0.getID());
            IAtom pAtom = (IAtom)atomIDLookup.get("P" + a1.getID());
            resolvedMappings.add(builder.newInstance(IMapping.class, rAtom, pAtom));
        }
        for (int i = count = reaction.getMappingCount(); i > 0; --i) {
            reaction.removeMapping(i);
        }
        int numberOfMappingsAdded = 0;
        for (IMapping mapping : resolvedMappings) {
            reaction.addMapping(mapping);
            ++numberOfMappingsAdded;
        }
    }

    private static void fillMap(IAtomContainerSet moleculeSet, Map<String, IAtom> map, String label) {
        for (IAtomContainer atomContainer : moleculeSet.atomContainers()) {
            for (IAtom atom : atomContainer.atoms()) {
                String id = label + atom.getID();
                map.put(id, atom);
            }
        }
    }

    private static void printIDs(IReaction reaction) {
        IAtom atom;
        int i;
        IAtomContainerSet reactants = reaction.getReactants();
        IAtomContainerSet products = reaction.getProducts();
        for (IAtomContainer reactant : reactants.atomContainers()) {
            System.out.print("[");
            for (i = 0; i < reactant.getAtomCount(); ++i) {
                atom = reactant.getAtom(i);
                System.out.print(atom.getSymbol() + i + "." + atom.getID() + ",");
            }
            System.out.println("]");
        }
        for (IAtomContainer product : products.atomContainers()) {
            System.out.print("[");
            for (i = 0; i < product.getAtomCount(); ++i) {
                atom = product.getAtom(i);
                System.out.print(atom.getSymbol() + i + "." + atom.getID() + ",");
            }
            System.out.println("]");
        }
        System.out.print("{");
        for (IMapping mapping : reaction.mappings()) {
            IAtom a0 = (IAtom)mapping.getChemObject(0);
            IAtom a1 = (IAtom)mapping.getChemObject(1);
            System.out.print(String.format("%s-%s, ", a0.getID(), a1.getID()));
        }
        System.out.println("}");
    }

    private MappingReferenceResolver() {
    }
}

