/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.graph;

import java.util.logging.Logger;

class Lock {
    private static final Logger LOG = Logger.getLogger(Lock.class.getName());
    private boolean isLocked = false;
    private Thread lockedBy = null;
    private int lockedCount = 0;

    Lock() {
    }

    public synchronized void lock() throws InterruptedException {
        Thread callingThread = Thread.currentThread();
        while (this.isIsLocked() && this.getLockedBy() != callingThread) {
            this.wait();
        }
        this.setIsLocked(true);
        this.setLockedCount(this.getLockedCount() + 1);
        this.setLockedBy(callingThread);
    }

    public synchronized void unlock() {
        if (Thread.currentThread() == this.getLockedBy()) {
            this.setLockedCount(this.getLockedCount() - 1);
            if (this.getLockedCount() == 0) {
                this.setIsLocked(false);
                this.notify();
            }
        }
    }

    public boolean isIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public Thread getLockedBy() {
        return this.lockedBy;
    }

    public void setLockedBy(Thread lockedBy) {
        this.lockedBy = lockedBy;
    }

    public int getLockedCount() {
        return this.lockedCount;
    }

    public void setLockedCount(int lockedCount) {
        this.lockedCount = lockedCount;
    }
}

