/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.interfaces;

import java.io.IOException;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;
import uk.ac.ebi.reactionblast.mapping.container.ReactionContainer;

public abstract class IGraphMatching {
    public static void setMCSUpdationFlags(Holder holder, int substrateIndex, int productIndex) {
        try {
            ReactionContainer reactionStructureInformation = holder.getReactionContainer();
            reactionStructureInformation.setEductModified(substrateIndex, true);
            reactionStructureInformation.setProductModified(productIndex, true);
        }
        catch (IOException ex) {
            Logger.getLogger(IGraphMatching.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(IGraphMatching.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public abstract IAtomContainer getMatchedPart();

    public abstract IAtomContainer getRemainingEduct();

    public abstract IAtomContainer getRemainingProduct();

    public abstract boolean mcsMatch(Holder var1, boolean var2, Integer var3, Integer var4, BitSet var5, BitSet var6);

    public abstract int removeMatchedAtomsAndUpdateAAM(IReaction var1);
}

