/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.interfaces;

public enum IMappingAlgorithm {
    MIN(0, "Local Minimization Model"),
    MAX(1, "Global Maximization Model"),
    MIXTURE(2, "Max-Mixture Model"),
    RINGS(3, "Ring Conservation Model"),
    USER_DEFINED(4, "Customised Mapping");

    private final int type;
    private final String description;

    private IMappingAlgorithm(int aStatus, String desc) {
        this.type = aStatus;
        this.description = desc;
    }

    public int type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public <status> int compareTo(IMappingAlgorithm obj) {
        return 0;
    }
}

