/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.Mapping;
import org.openscience.cdk.aromaticity.Kekulization;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import org.openscience.smsd.tools.BondEnergies;
import uk.ac.ebi.reactionblast.fingerprints.Feature;
import uk.ac.ebi.reactionblast.fingerprints.PatternFingerprinter;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IPatternFingerprinter;
import uk.ac.ebi.reactionblast.mechanism.BEMatrix;
import uk.ac.ebi.reactionblast.mechanism.BondChangeAnnotator;
import uk.ac.ebi.reactionblast.mechanism.RMatrix;
import uk.ac.ebi.reactionblast.mechanism.helper.AtomAtomMappingContainer;
import uk.ac.ebi.reactionblast.mechanism.helper.AtomStereoChangeInformation;
import uk.ac.ebi.reactionblast.mechanism.helper.BondChange;
import uk.ac.ebi.reactionblast.mechanism.helper.MoleculeMoleculePair;
import uk.ac.ebi.reactionblast.mechanism.helper.ReactionCenterFragment;
import uk.ac.ebi.reactionblast.mechanism.interfaces.AbstractChangeCalculator;
import uk.ac.ebi.reactionblast.mechanism.interfaces.ECBLAST_BOND_CHANGE_FLAGS;
import uk.ac.ebi.reactionblast.mechanism.interfaces.ECBLAST_FLAGS;
import uk.ac.ebi.reactionblast.mechanism.interfaces.EnumSubstrateProduct;
import uk.ac.ebi.reactionblast.mechanism.interfaces.IChangeCalculator;
import uk.ac.ebi.reactionblast.tools.ExtReactionManipulatorTool;

public class BondChangeCalculator
extends AbstractChangeCalculator
implements IChangeCalculator {
    private final boolean DEBUG = false;
    private static final long serialVersionUID = 98698690880809981L;
    private static final Logger LOG = Logger.getLogger(BondChangeCalculator.class.getName());
    private final BondChangeAnnotator bondChangeAnnotator;
    private final IPatternFingerprinter formedCleavedWFingerprint;
    private final IPatternFingerprinter orderChangesWFingerprint;
    private final IPatternFingerprinter stereoChangesWFingerprint;
    private final IPatternFingerprinter reactionCenterWFingerprint;
    private final Map<Integer, IPatternFingerprinter> reactionCenterFormedCleavedFingerprint;
    private final Map<Integer, IPatternFingerprinter> reactionCenterOrderChangeFingerprint;
    private final Map<Integer, IPatternFingerprinter> reactionCenterStereoChangeFingerprint;
    private final Map<IBond, String> bondFormedMap;
    private final Map<IBond, String> bondCleavedMap;
    private final Map<IBond, String> bondOrderRMap;
    private final Map<IBond, String> bondOrderPMap;
    private final Map<IAtom, String> AtomStereoRMap;
    private final Map<IAtom, String> AtomStereoPMap;
    private final List<ReactionCenterFragment> reactionCenterFragmentList;
    private final Set<MoleculeMoleculePair> reactionMoleculeMoleculePairList;
    private final IReaction mappedReaction;
    private int energySum;
    private int energyDelta;
    private int totalSmallestFragmentSize;

    public BondChangeCalculator(IReaction reaction, boolean generate2D, boolean generate3D) throws Exception {
        IAtomContainer moleculeP;
        Object atomP1;
        IAtomContainer moleculeR;
        IAtom atomR1;
        Feature eductFeature;
        int rEnergy = 0;
        int pEnergy = 0;
        this.energySum = 0;
        this.energyDelta = 0;
        this.totalSmallestFragmentSize = 0;
        this.mappedReaction = reaction;
        this.bondChangeAnnotator = new BondChangeAnnotator(this.mappedReaction, true, generate2D, generate3D);
        BondEnergies be = BondEnergies.getInstance();
        this.formedCleavedWFingerprint = new PatternFingerprinter();
        this.formedCleavedWFingerprint.setFingerprintID(reaction.getID() + ":" + "Bond Cleaved and Formed");
        this.orderChangesWFingerprint = new PatternFingerprinter();
        this.orderChangesWFingerprint.setFingerprintID(reaction.getID() + ":" + "Bond Order Change");
        this.stereoChangesWFingerprint = new PatternFingerprinter();
        this.stereoChangesWFingerprint.setFingerprintID(reaction.getID() + ":" + "Bond Stereo Change");
        this.reactionCenterWFingerprint = new PatternFingerprinter();
        this.reactionCenterWFingerprint.setFingerprintID(reaction.getID() + ":" + "Reaction Center");
        this.reactionCenterFormedCleavedFingerprint = new HashMap<Integer, IPatternFingerprinter>();
        this.reactionCenterOrderChangeFingerprint = new HashMap<Integer, IPatternFingerprinter>();
        this.reactionCenterStereoChangeFingerprint = new HashMap<Integer, IPatternFingerprinter>();
        this.reactionMoleculeMoleculePairList = new LinkedHashSet<MoleculeMoleculePair>();
        this.bondFormedMap = Collections.synchronizedMap(new HashMap());
        this.bondCleavedMap = Collections.synchronizedMap(new HashMap());
        this.bondOrderRMap = Collections.synchronizedMap(new HashMap());
        this.bondOrderPMap = Collections.synchronizedMap(new HashMap());
        this.AtomStereoRMap = Collections.synchronizedMap(new HashMap());
        this.AtomStereoPMap = Collections.synchronizedMap(new HashMap());
        this.reactionCenterFragmentList = Collections.synchronizedList(new ArrayList());
        for (AtomStereoChangeInformation atomConformation : this.bondChangeAnnotator.getConformationChangeList()) {
            if (atomConformation.getReactantAtom() != null && atomConformation.getProductAtom() != null) {
                String keyE = atomConformation.getReactantAtom().getSymbol().concat("(E/Z)");
                eductFeature = new Feature(keyE, 1.0);
                this.stereoChangesWFingerprint.add(eductFeature);
            }
            if (atomConformation.getReactantAtom() != null) {
                atomConformation.getReactantAtom().setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_STEREO);
                this.AtomStereoRMap.put(atomConformation.getReactantAtom(), BondChangeCalculator.getMoleculeID(atomConformation.getReactantAtom(), reaction.getReactants()));
                atomR1 = atomConformation.getReactantAtom();
                moleculeR = BondChangeCalculator.getAtomContainer(atomConformation.getReactantAtom(), reaction.getReactants());
                if (moleculeR.getAtomCount() > 1 && !atomR1.getSymbol().equals("H")) {
                    this.reactionCenterFragmentList.addAll(BondChangeCalculator.getCircularReactionPatternFingerprints(moleculeR, atomR1, EnumSubstrateProduct.REACTANT));
                    BondChangeCalculator.setCircularFingerprints(reaction.getID(), moleculeR, atomR1, this.reactionCenterStereoChangeFingerprint);
                }
            }
            if (atomConformation.getProductAtom() == null) continue;
            atomConformation.getProductAtom().setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_STEREO);
            this.AtomStereoPMap.put(atomConformation.getProductAtom(), BondChangeCalculator.getMoleculeID(atomConformation.getProductAtom(), reaction.getProducts()));
            atomP1 = atomConformation.getProductAtom();
            moleculeP = BondChangeCalculator.getAtomContainer(atomConformation.getProductAtom(), reaction.getProducts());
            if (moleculeP.getAtomCount() <= 1 || atomP1.getSymbol().equals("H")) continue;
            this.reactionCenterFragmentList.addAll(BondChangeCalculator.getCircularReactionPatternFingerprints(moleculeP, (IAtom)atomP1, EnumSubstrateProduct.PRODUCT));
            BondChangeCalculator.setCircularFingerprints(reaction.getID(), moleculeP, (IAtom)atomP1, this.reactionCenterStereoChangeFingerprint);
        }
        for (AtomStereoChangeInformation atomStereo : this.bondChangeAnnotator.getStereoChangeList()) {
            if (atomStereo.getReactantAtom() != null && atomStereo.getProductAtom() != null) {
                String key = atomStereo.getReactantAtom().getSymbol().concat("(R/S)");
                eductFeature = new Feature(key, 1.0);
                this.stereoChangesWFingerprint.add(eductFeature);
            }
            if (atomStereo.getReactantAtom() != null) {
                atomStereo.getReactantAtom().setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_STEREO);
                this.AtomStereoRMap.put(atomStereo.getReactantAtom(), BondChangeCalculator.getMoleculeID(atomStereo.getReactantAtom(), reaction.getReactants()));
                atomR1 = atomStereo.getReactantAtom();
                moleculeR = BondChangeCalculator.getAtomContainer(atomStereo.getReactantAtom(), reaction.getReactants());
                if (moleculeR.getAtomCount() > 1 && !atomR1.getSymbol().equals("H")) {
                    this.reactionCenterFragmentList.addAll(BondChangeCalculator.getCircularReactionPatternFingerprints(moleculeR, atomR1, EnumSubstrateProduct.REACTANT));
                    BondChangeCalculator.setCircularFingerprints(reaction.getID(), moleculeR, atomR1, this.reactionCenterStereoChangeFingerprint);
                }
            }
            if (atomStereo.getProductAtom() == null) continue;
            atomStereo.getProductAtom().setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_STEREO);
            this.AtomStereoPMap.put(atomStereo.getProductAtom(), BondChangeCalculator.getMoleculeID(atomStereo.getProductAtom(), reaction.getProducts()));
            atomP1 = atomStereo.getProductAtom();
            moleculeP = BondChangeCalculator.getAtomContainer(atomStereo.getProductAtom(), reaction.getProducts());
            if (moleculeP.getAtomCount() <= 1 || atomP1.getSymbol().equals("H")) continue;
            this.reactionCenterFragmentList.addAll(BondChangeCalculator.getCircularReactionPatternFingerprints(moleculeP, (IAtom)atomP1, EnumSubstrateProduct.PRODUCT));
            BondChangeCalculator.setCircularFingerprints(reaction.getID(), moleculeP, (IAtom)atomP1, this.reactionCenterStereoChangeFingerprint);
        }
        HashSet<IAtom> reactantAtoms = new HashSet<IAtom>();
        HashSet<IAtom> productAtoms = new HashSet<IAtom>();
        for (BondChange bcinfo : this.bondChangeAnnotator.getBondChangeList()) {
            Iterator<Object> bondR = bcinfo.getReactantBond();
            IBond bondP = bcinfo.getProductBond();
            if (bondR == null || bondP == null || !bondP.getProperties().get((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION).equals((Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_ORDER) || !bondR.getProperties().get((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION).equals((Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_ORDER)) continue;
            this.bondOrderRMap.put((IBond)((Object)bondR), BondChangeCalculator.getMoleculeID(bondR, reaction.getReactants()));
            bondR.getAtom(0).setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_ORDER);
            bondR.getAtom(1).setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_ORDER);
            this.bondOrderPMap.put(bondP, BondChangeCalculator.getMoleculeID(bondP, reaction.getProducts()));
            bondP.getAtom(0).setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_ORDER);
            bondP.getAtom(1).setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_ORDER);
            reactantAtoms.add(bondR.getAtom(0));
            reactantAtoms.add(bondR.getAtom(1));
            productAtoms.add(bondP.getAtom(0));
            productAtoms.add(bondP.getAtom(1));
            this.orderChangesWFingerprint.add(new Feature(BondChangeCalculator.getCanonisedBondChangePattern(bondR, bondP), 1.0));
        }
        IAtomContainerSet reactants = reaction.getReactants();
        IAtomContainerSet products = reaction.getProducts();
        for (IAtom atom : reactantAtoms) {
            IAtomContainer iAtomContainer = AtomContainerSetManipulator.getRelevantAtomContainer(reactants, atom);
            this.reactionCenterFragmentList.addAll(BondChangeCalculator.getCircularReactionPatternFingerprints(iAtomContainer, atom, EnumSubstrateProduct.REACTANT));
            BondChangeCalculator.setCircularFingerprints(reaction.getID(), iAtomContainer, atom, this.reactionCenterOrderChangeFingerprint);
        }
        for (IAtom atom : productAtoms) {
            IAtomContainer iAtomContainer = AtomContainerSetManipulator.getRelevantAtomContainer(products, atom);
            this.reactionCenterFragmentList.addAll(BondChangeCalculator.getCircularReactionPatternFingerprints(iAtomContainer, atom, EnumSubstrateProduct.PRODUCT));
            BondChangeCalculator.setCircularFingerprints(reaction.getID(), iAtomContainer, atom, this.reactionCenterOrderChangeFingerprint);
        }
        for (BondChange bcinfo : this.bondChangeAnnotator.getBondChangeList()) {
            int chippedBondIndex;
            IBond iBond = bcinfo.getReactantBond();
            IBond bondP = bcinfo.getProductBond();
            if (bondP != null && (bondP.getProperties().get((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION).equals((Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_FORMED) || bondP.getProperties().get((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION).equals((Object)ECBLAST_BOND_CHANGE_FLAGS.PSEUDO_BOND)) && !bondP.getAtom(0).getSymbol().equals("PsH") && !bondP.getAtom(1).getSymbol().equals("PsH")) {
                this.energySum += be.getEnergies(bondP);
                pEnergy += be.getEnergies(bondP);
                this.bondFormedMap.put(bondP, BondChangeCalculator.getMoleculeID(bondP, reaction.getProducts()));
                bondP.getAtom(0).setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_FORMED);
                bondP.getAtom(1).setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_FORMED);
                IAtomContainer moleculeP2 = BondChangeCalculator.getAtomContainer(bondP, reaction.getProducts());
                if (moleculeP2.getAtomCount() > 1) {
                    IAtom atomP12 = bondP.getAtom(0);
                    IAtom atomP2 = bondP.getAtom(1);
                    if (!atomP12.getSymbol().equals("H")) {
                        this.reactionCenterFragmentList.addAll(BondChangeCalculator.getCircularReactionPatternFingerprints(moleculeP2, atomP12, EnumSubstrateProduct.PRODUCT));
                        BondChangeCalculator.setCircularFingerprints(reaction.getID(), moleculeP2, atomP12, this.reactionCenterFormedCleavedFingerprint);
                    }
                    if (!atomP2.getSymbol().equals("H")) {
                        this.reactionCenterFragmentList.addAll(BondChangeCalculator.getCircularReactionPatternFingerprints(moleculeP2, atomP2, EnumSubstrateProduct.PRODUCT));
                        BondChangeCalculator.setCircularFingerprints(reaction.getID(), moleculeP2, atomP2, this.reactionCenterFormedCleavedFingerprint);
                    }
                }
                IAtomContainer product = BondChangeCalculator.getAtomContainer(bondP, reaction.getProducts());
                IAtomContainer cloneProduct = product.getBuilder().newInstance(IAtomContainer.class, product);
                chippedBondIndex = product.getBondNumber(bondP);
                this.totalSmallestFragmentSize += this.chipTheBondCountSmallestFragmentSize(cloneProduct, chippedBondIndex);
                this.formedCleavedWFingerprint.add(new Feature(BondChangeCalculator.getCanonicalisedBondChangePattern(bondP), 1.0));
            }
            if (iBond == null || !iBond.getProperties().get((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION).equals((Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_CLEAVED) && !iBond.getProperties().get((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION).equals((Object)ECBLAST_BOND_CHANGE_FLAGS.PSEUDO_BOND) || iBond.getAtom(0).getSymbol().equals("PsH") || iBond.getAtom(1).getSymbol().equals("PsH")) continue;
            this.energySum += be.getEnergies(iBond);
            pEnergy += be.getEnergies(iBond);
            this.bondCleavedMap.put(iBond, BondChangeCalculator.getMoleculeID(iBond, reaction.getReactants()));
            iBond.getAtom(0).setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_CLEAVED);
            iBond.getAtom(1).setProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION, (Object)ECBLAST_BOND_CHANGE_FLAGS.BOND_CLEAVED);
            IAtomContainer moleculeE = BondChangeCalculator.getAtomContainer(iBond, reaction.getReactants());
            if (moleculeE.getAtomCount() > 1) {
                IAtom atomE1 = iBond.getAtom(0);
                IAtom atomE2 = iBond.getAtom(1);
                if (!atomE1.getSymbol().equals("H")) {
                    this.reactionCenterFragmentList.addAll(BondChangeCalculator.getCircularReactionPatternFingerprints(moleculeE, atomE1, EnumSubstrateProduct.REACTANT));
                    BondChangeCalculator.setCircularFingerprints(reaction.getID(), moleculeE, atomE1, this.reactionCenterFormedCleavedFingerprint);
                }
                if (!atomE2.getSymbol().equals("H")) {
                    this.reactionCenterFragmentList.addAll(BondChangeCalculator.getCircularReactionPatternFingerprints(moleculeE, atomE2, EnumSubstrateProduct.REACTANT));
                    BondChangeCalculator.setCircularFingerprints(reaction.getID(), moleculeE, atomE2, this.reactionCenterFormedCleavedFingerprint);
                }
            }
            IAtomContainer reactant = BondChangeCalculator.getAtomContainer(iBond, reaction.getReactants());
            IAtomContainer cloneReactant = reactant.getBuilder().newInstance(IAtomContainer.class, reactant);
            chippedBondIndex = reactant.getBondNumber(iBond);
            this.totalSmallestFragmentSize += this.chipTheBondCountSmallestFragmentSize(cloneReactant, chippedBondIndex);
            this.formedCleavedWFingerprint.add(new Feature(BondChangeCalculator.getCanonicalisedBondChangePattern(iBond), 1.0));
        }
        HashMap<IAtom, IAtom> reactionCenterMap = new HashMap<IAtom, IAtom>();
        for (IAtom iAtom : this.bondChangeAnnotator.getReactionCenterSet()) {
            if (iAtom.getSymbol().equals("H")) continue;
            reactionCenterMap.put(iAtom, this.bondChangeAnnotator.getMappingMap().get(iAtom));
        }
        for (IAtom iAtom : this.bondChangeAnnotator.getReactionCenterSet()) {
            if (iAtom.getSymbol().equals("H")) continue;
            IAtomContainer relevantAtomContainer2 = ReactionManipulator.getRelevantAtomContainer(reaction, iAtom);
            IAtomContainer relevantAtomContainer1 = AtomContainerSetManipulator.getRelevantAtomContainer(reactants, iAtom);
            IAtomContainer relevantAtomContainer22 = AtomContainerSetManipulator.getRelevantAtomContainer(products, iAtom);
            if (relevantAtomContainer2 == null || relevantAtomContainer2.getAtomCount() != 1) continue;
            EnumSubstrateProduct esp = null;
            if (relevantAtomContainer1 != null) {
                esp = EnumSubstrateProduct.REACTANT;
            } else if (relevantAtomContainer22 != null) {
                esp = EnumSubstrateProduct.PRODUCT;
            }
            if (iAtom.getSymbol().equals("H")) continue;
            this.reactionCenterFragmentList.addAll(BondChangeCalculator.getCircularReactionPatternFingerprints(relevantAtomContainer2, iAtom, esp));
            BondChangeCalculator.setCircularFingerprints(reaction.getID(), relevantAtomContainer2, iAtom, this.reactionCenterFormedCleavedFingerprint);
        }
        for (Map.Entry entry : reactionCenterMap.entrySet()) {
            String circularSMILES;
            IAtom sourceAtom = (IAtom)entry.getKey();
            IAtom sinkAtom = (IAtom)entry.getValue();
            IAtomContainer relevantAtomContainer1 = AtomContainerSetManipulator.getRelevantAtomContainer(reaction.getReactants(), sourceAtom);
            IAtomContainer relevantAtomContainer2 = AtomContainerSetManipulator.getRelevantAtomContainer(reaction.getProducts(), sinkAtom);
            if (relevantAtomContainer1 != null) {
                for (int i = 0; i < 3; ++i) {
                    circularSMILES = BondChangeCalculator.getCircularSMILES(relevantAtomContainer1, sourceAtom, i, true);
                    this.reactionCenterWFingerprint.add(new Feature(circularSMILES, 1.0));
                }
            }
            if (relevantAtomContainer2 != null) {
                for (int i = 0; i < 3; ++i) {
                    circularSMILES = BondChangeCalculator.getCircularSMILES(relevantAtomContainer2, sinkAtom, i, true);
                    this.reactionCenterWFingerprint.add(new Feature(circularSMILES, 1.0));
                }
            }
            if (relevantAtomContainer1 == null || relevantAtomContainer2 == null) continue;
            for (int i = 1; i < 4; ++i) {
                String circularSMILESSource = BondChangeCalculator.getCircularSMILES(relevantAtomContainer1, sourceAtom, i, true);
                String circularSMILESSink = BondChangeCalculator.getCircularSMILES(relevantAtomContainer2, sinkAtom, i, true);
                StringBuilder level = new StringBuilder();
                level.append(circularSMILESSource).append(">>").append(circularSMILESSink);
                this.reactionCenterWFingerprint.add(new Feature(level.toString(), 1.0));
            }
            MoleculeMoleculePair molMolPair = BondChangeCalculator.getMolMolPair(sourceAtom, sinkAtom, relevantAtomContainer1, relevantAtomContainer2);
            this.reactionMoleculeMoleculePairList.add(molMolPair);
        }
        this.setEnergyDelta(rEnergy - pEnergy);
    }

    @Override
    public synchronized BEMatrix getEductBEMatrix() {
        return this.bondChangeAnnotator.getEductBEMatrix();
    }

    @Override
    public synchronized BEMatrix getProductBEMatrix() {
        return this.bondChangeAnnotator.getProductBEMatrix();
    }

    @Override
    public synchronized RMatrix getRMatrix() {
        return this.bondChangeAnnotator.getRMatrix();
    }

    @Override
    public synchronized void printBMatrix() {
        this.bondChangeAnnotator.printBMatrix();
    }

    @Override
    public synchronized void printEMatrix() {
        this.bondChangeAnnotator.printEMatrix();
    }

    @Override
    public synchronized void printRMatrix() {
        this.bondChangeAnnotator.printRMatrix();
    }

    @Override
    public synchronized void writeBMatrix(File outputFile) {
        this.bondChangeAnnotator.writeBMatrix(outputFile);
    }

    @Override
    public synchronized void writeEMatrix(File outputFile) {
        this.bondChangeAnnotator.writeEMatrix(outputFile);
    }

    @Override
    public synchronized void writeRMatrix(File outputFile) {
        this.bondChangeAnnotator.writeRMatrix(outputFile);
    }

    @Override
    public synchronized boolean hasRMatrix() {
        return this.bondChangeAnnotator.hasRMatrix();
    }

    @Override
    public synchronized Map<IAtom, IAtom> getMappingMap() {
        return Collections.synchronizedMap(this.bondChangeAnnotator.getMappingMap());
    }

    @Override
    public synchronized List<BondChange> getBondChangeList() {
        return this.bondChangeAnnotator.getBondChangeList();
    }

    @Override
    public synchronized IPatternFingerprinter getOrderChangesWFingerprint() throws CDKException {
        return this.orderChangesWFingerprint;
    }

    @Override
    public synchronized IPatternFingerprinter getStereoChangesWFingerprint() throws CDKException {
        return this.stereoChangesWFingerprint;
    }

    @Override
    public synchronized IPatternFingerprinter getFormedCleavedWFingerprint() throws CDKException {
        return this.formedCleavedWFingerprint;
    }

    @Override
    public synchronized IPatternFingerprinter getReactionCenterWFingerprint() throws CDKException {
        return this.reactionCenterWFingerprint;
    }

    public synchronized String toString() {
        IAtom atom;
        String symbol2;
        String symbol1;
        String id2;
        String id1;
        String molID;
        IBond bond;
        StringBuilder result = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        result.append(NEW_LINE).append(this.getLicenseHeader());
        result.append(NEW_LINE).append(NEW_LINE).append("//DATA START//");
        result.append(NEW_LINE).append(NEW_LINE);
        result.append("Cleaved FingerPrint (Reactant)");
        for (Map.Entry<IBond, String> entry : this.bondCleavedMap.entrySet()) {
            bond = entry.getKey();
            molID = entry.getValue();
            result.append(NEW_LINE);
            id1 = "";
            id2 = "";
            symbol1 = "";
            symbol2 = "";
            if (bond.getAtom(0).getID() != null) {
                id1 = bond.getAtom(0).getID();
                symbol1 = bond.getAtom(0).getSymbol();
            }
            if (bond.getAtom(1).getID() != null) {
                id2 = bond.getAtom(1).getID();
                symbol2 = bond.getAtom(1).getSymbol();
            }
            if (!symbol1.isEmpty() && !symbol2.isEmpty()) {
                result.append(symbol1);
                result.append("(").append(id1).append(")");
                result.append(BondChangeCalculator.getBondOrderSign(bond)).append(symbol2);
                result.append("(").append(id2).append(")\t").append(molID);
                continue;
            }
            if (!symbol1.isEmpty() && symbol2.isEmpty()) {
                result.append(symbol1);
                result.append("(").append(id1).append(")\t").append(molID);
                continue;
            }
            if (!symbol1.isEmpty() || symbol2.isEmpty()) continue;
            result.append(symbol2);
            result.append("(").append(id2).append(")\t").append(molID);
        }
        result.append(NEW_LINE).append(NEW_LINE);
        result.append("Formed FingerPrint (Product)");
        for (Map.Entry<IBond, String> entry : this.bondFormedMap.entrySet()) {
            bond = entry.getKey();
            molID = entry.getValue();
            result.append(NEW_LINE);
            id1 = "";
            id2 = "";
            symbol1 = "";
            symbol2 = "";
            if (bond.getAtom(0).getID() != null) {
                id1 = bond.getAtom(0).getID();
                symbol1 = bond.getAtom(0).getSymbol();
            }
            if (bond.getAtom(1).getID() != null) {
                id2 = bond.getAtom(1).getID();
                symbol2 = bond.getAtom(1).getSymbol();
            }
            if (!symbol1.isEmpty() && !symbol2.isEmpty()) {
                result.append(symbol1);
                result.append("(").append(id1).append(")");
                result.append(BondChangeCalculator.getBondOrderSign(bond)).append(symbol2);
                result.append("(").append(id2).append(")\t").append(molID);
                continue;
            }
            if (!symbol1.isEmpty() && symbol2.isEmpty()) {
                result.append(symbol1);
                result.append("(").append(id1).append(")\t").append(molID);
                continue;
            }
            if (!symbol1.isEmpty() || symbol2.isEmpty()) continue;
            result.append(symbol2);
            result.append("(").append(id2).append(")\t").append(molID);
        }
        result.append(NEW_LINE).append(NEW_LINE);
        result.append("Order Change FingerPrint (Reactant)");
        for (Map.Entry<IBond, String> entry : this.bondOrderRMap.entrySet()) {
            bond = entry.getKey();
            molID = entry.getValue();
            result.append(NEW_LINE);
            id1 = "";
            id2 = "";
            symbol1 = "";
            symbol2 = "";
            if (bond.getAtom(0).getID() != null) {
                id1 = bond.getAtom(0).getID();
                symbol1 = bond.getAtom(0).getSymbol();
            }
            if (bond.getAtom(1).getID() != null) {
                id2 = bond.getAtom(1).getID();
                symbol2 = bond.getAtom(1).getSymbol();
            }
            if (!symbol1.isEmpty() && !symbol2.isEmpty()) {
                result.append(symbol1);
                result.append("(").append(id1).append(")");
                result.append(BondChangeCalculator.getBondOrderSign(bond)).append(symbol2);
                result.append("(").append(id2).append(")\t").append(molID);
                continue;
            }
            if (!symbol1.isEmpty() && symbol2.isEmpty()) {
                result.append(symbol1);
                result.append("(").append(id1).append(")\t").append(molID);
                continue;
            }
            if (!symbol1.isEmpty() || symbol2.isEmpty()) continue;
            result.append(symbol2);
            result.append("(").append(id2).append(")\t").append(molID);
        }
        result.append(NEW_LINE).append(NEW_LINE);
        result.append("Order Change FingerPrint (Product)");
        for (Map.Entry<IBond, String> entry : this.bondOrderPMap.entrySet()) {
            bond = entry.getKey();
            molID = entry.getValue();
            result.append(NEW_LINE);
            id1 = "";
            id2 = "";
            symbol1 = "";
            symbol2 = "";
            if (bond.getAtom(0).getID() != null) {
                id1 = bond.getAtom(0).getID();
                symbol1 = bond.getAtom(0).getSymbol();
            }
            if (bond.getAtom(1).getID() != null) {
                id2 = bond.getAtom(1).getID();
                symbol2 = bond.getAtom(1).getSymbol();
            }
            if (!symbol1.isEmpty() && !symbol2.isEmpty()) {
                result.append(symbol1);
                result.append("(").append(id1).append(")");
                result.append(BondChangeCalculator.getBondOrderSign(bond)).append(symbol2);
                result.append("(").append(id2).append(")\t").append(molID);
                continue;
            }
            if (!symbol1.isEmpty() && symbol2.isEmpty()) {
                result.append(symbol1);
                result.append("(").append(id1).append(")\t").append(molID);
                continue;
            }
            if (!symbol1.isEmpty() || symbol2.isEmpty()) continue;
            result.append(symbol2);
            result.append("(").append(id2).append(")\t").append(molID);
        }
        result.append(NEW_LINE).append(NEW_LINE);
        result.append("Stereo Change FingerPrint (Reactant)");
        for (Map.Entry<IChemObject, String> entry : this.AtomStereoRMap.entrySet()) {
            atom = (IAtom)entry.getKey();
            molID = entry.getValue();
            result.append(NEW_LINE);
            id1 = "";
            id2 = "";
            symbol1 = "";
            symbol2 = "";
            if (atom.getID() != null) {
                id1 = atom.getID();
                symbol1 = atom.getSymbol();
            }
            result.append(symbol1).append("(").append(id1).append(")(R/S)\t").append(molID);
        }
        result.append(NEW_LINE).append(NEW_LINE);
        result.append("Stereo Change FingerPrint (Product)");
        for (Map.Entry<IChemObject, String> entry : this.AtomStereoPMap.entrySet()) {
            atom = (IAtom)entry.getKey();
            molID = entry.getValue();
            result.append(NEW_LINE);
            id1 = "";
            id2 = "";
            symbol1 = "";
            symbol2 = "";
            if (atom.getID() != null) {
                id1 = atom.getID();
                symbol1 = atom.getSymbol();
            }
            result.append(symbol1).append("(").append(id1).append(")(R/S)\t").append(molID);
        }
        result.append(NEW_LINE).append(NEW_LINE);
        result.append("//DATA END//").append(NEW_LINE);
        result.append(NEW_LINE).append(this.getLicenseFooter());
        result.append(NEW_LINE).append(NEW_LINE);
        return result.toString();
    }

    @Override
    public synchronized void writeBondChanges(File bondChangeInfoFile) throws IOException {
        FileWriter bcFW = new FileWriter(bondChangeInfoFile + ".txt");
        try (BufferedWriter bfw = new BufferedWriter(bcFW);){
            IAtom atom;
            String symbol2;
            String symbol1;
            String id2;
            String id1;
            String molID;
            IBond bond;
            bfw.newLine();
            bfw.write(this.getLicenseHeader());
            bfw.newLine();
            bfw.write("//DATA START//");
            bfw.newLine();
            bfw.newLine();
            bfw.write("Cleaved FingerPrint (Reactant)");
            for (Map.Entry<IBond, String> entry : this.bondCleavedMap.entrySet()) {
                bond = entry.getKey();
                molID = entry.getValue();
                bfw.newLine();
                id1 = "";
                id2 = "";
                symbol1 = "";
                symbol2 = "";
                if (bond.getAtom(0).getID() != null) {
                    id1 = bond.getAtom(0).getID();
                    symbol1 = bond.getAtom(0).getSymbol();
                }
                if (bond.getAtom(1).getID() != null) {
                    id2 = bond.getAtom(1).getID();
                    symbol2 = bond.getAtom(1).getSymbol();
                }
                if (!symbol1.isEmpty() && !symbol2.isEmpty()) {
                    bfw.write(symbol1 + "(" + id1 + ")" + BondChangeCalculator.getBondOrderSign(bond) + symbol2 + "(" + id2 + ")" + "\t" + molID);
                    continue;
                }
                if (!symbol1.isEmpty() && symbol2.isEmpty()) {
                    bfw.write(symbol1 + "(" + id1 + ")" + "\t" + molID);
                    continue;
                }
                if (!symbol1.isEmpty() || symbol2.isEmpty()) continue;
                bfw.write(symbol2 + "(" + id2 + ")" + "\t" + molID);
            }
            bfw.newLine();
            bfw.newLine();
            bfw.write("Formed FingerPrint (Product)");
            for (Map.Entry<IBond, String> entry : this.bondFormedMap.entrySet()) {
                bond = entry.getKey();
                molID = entry.getValue();
                bfw.newLine();
                id1 = "";
                id2 = "";
                symbol1 = "";
                symbol2 = "";
                if (bond.getAtom(0).getID() != null) {
                    id1 = bond.getAtom(0).getID();
                    symbol1 = bond.getAtom(0).getSymbol();
                }
                if (bond.getAtom(1).getID() != null) {
                    id2 = bond.getAtom(1).getID();
                    symbol2 = bond.getAtom(1).getSymbol();
                }
                if (!symbol1.isEmpty() && !symbol2.isEmpty()) {
                    bfw.write(symbol1 + "(" + id1 + ")" + BondChangeCalculator.getBondOrderSign(bond) + symbol2 + "(" + id2 + ")" + "\t" + molID);
                    continue;
                }
                if (!symbol1.isEmpty() && symbol2.isEmpty()) {
                    bfw.write(symbol1 + "(" + id1 + ")" + "\t" + molID);
                    continue;
                }
                if (!symbol1.isEmpty() || symbol2.isEmpty()) continue;
                bfw.write(symbol2 + "(" + id2 + ")" + "\t" + molID);
            }
            bfw.newLine();
            bfw.newLine();
            bfw.write("Order Change FingerPrint (Reactant)");
            for (Map.Entry<IBond, String> entry : this.bondOrderRMap.entrySet()) {
                bond = entry.getKey();
                molID = entry.getValue();
                bfw.newLine();
                id1 = "";
                id2 = "";
                symbol1 = "";
                symbol2 = "";
                if (bond.getAtom(0).getID() != null) {
                    id1 = bond.getAtom(0).getID();
                    symbol1 = bond.getAtom(0).getSymbol();
                }
                if (bond.getAtom(1).getID() != null) {
                    id2 = bond.getAtom(1).getID();
                    symbol2 = bond.getAtom(1).getSymbol();
                }
                if (!symbol1.isEmpty() && !symbol2.isEmpty()) {
                    bfw.write(symbol1 + "(" + id1 + ")" + BondChangeCalculator.getBondOrderSign(bond) + symbol2 + "(" + id2 + ")" + "\t" + molID);
                    continue;
                }
                if (!symbol1.isEmpty() && symbol2.isEmpty()) {
                    bfw.write(symbol1 + "(" + id1 + ")" + "\t" + molID);
                    continue;
                }
                if (!symbol1.isEmpty() || symbol2.isEmpty()) continue;
                bfw.write(symbol2 + "(" + id2 + ")" + "\t" + molID);
            }
            bfw.newLine();
            bfw.newLine();
            bfw.write("Order Change FingerPrint (Product)");
            for (Map.Entry<IBond, String> entry : this.bondOrderPMap.entrySet()) {
                bond = entry.getKey();
                molID = entry.getValue();
                bfw.newLine();
                id1 = "";
                id2 = "";
                symbol1 = "";
                symbol2 = "";
                if (bond.getAtom(0).getID() != null) {
                    id1 = bond.getAtom(0).getID();
                    symbol1 = bond.getAtom(0).getSymbol();
                }
                if (bond.getAtom(1).getID() != null) {
                    id2 = bond.getAtom(1).getID();
                    symbol2 = bond.getAtom(1).getSymbol();
                }
                if (!symbol1.isEmpty() && !symbol2.isEmpty()) {
                    bfw.write(symbol1 + "(" + id1 + ")" + BondChangeCalculator.getBondOrderSign(bond) + symbol2 + "(" + id2 + ")" + "\t" + molID);
                    continue;
                }
                if (!symbol1.isEmpty() && symbol2.isEmpty()) {
                    bfw.write(symbol1 + "(" + id1 + ")" + "\t" + molID);
                    continue;
                }
                if (!symbol1.isEmpty() || symbol2.isEmpty()) continue;
                bfw.write(symbol2 + "(" + id2 + ")" + "\t" + molID);
            }
            bfw.newLine();
            bfw.newLine();
            bfw.write("Stereo Change FingerPrint (Reactant)");
            for (Map.Entry<IChemObject, String> entry : this.AtomStereoRMap.entrySet()) {
                atom = (IAtom)entry.getKey();
                molID = entry.getValue();
                bfw.newLine();
                id1 = "";
                id2 = "";
                symbol1 = "";
                symbol2 = "";
                if (atom.getID() != null) {
                    id1 = atom.getID();
                    symbol1 = atom.getSymbol();
                }
                if (atom.getID() != null) {
                    id2 = atom.getID();
                    symbol2 = atom.getSymbol();
                }
                bfw.write(symbol1 + "(" + id1 + ")" + "(R/S)" + "\t" + molID);
            }
            bfw.newLine();
            bfw.newLine();
            bfw.write("Stereo Change FingerPrint (Product)");
            for (Map.Entry<IChemObject, String> entry : this.AtomStereoPMap.entrySet()) {
                atom = (IAtom)entry.getKey();
                molID = entry.getValue();
                bfw.newLine();
                id1 = "";
                id2 = "";
                symbol1 = "";
                symbol2 = "";
                if (atom.getID() != null) {
                    id1 = atom.getID();
                    symbol1 = atom.getSymbol();
                }
                bfw.write(symbol1 + "(" + id1 + ")" + "(R/S)" + "\t" + molID);
            }
            bfw.newLine();
            bfw.newLine();
            bfw.write("//DATA END//");
            bfw.flush();
            bfw.newLine();
            bfw.newLine();
            bfw.write(this.getLicenseFooter());
            bfw.newLine();
            bfw.newLine();
            bfw.flush();
        }
    }

    @Override
    public synchronized Map<IBond, String> getBondFormedProduct() {
        return Collections.synchronizedMap(this.bondFormedMap);
    }

    @Override
    public synchronized Map<IBond, String> getBondCleavedReactant() {
        return Collections.synchronizedMap(this.bondCleavedMap);
    }

    @Override
    public synchronized Map<IBond, String> getBondOrderReactant() {
        return Collections.synchronizedMap(this.bondOrderRMap);
    }

    @Override
    public synchronized Map<IBond, String> getBondOrderProduct() {
        return Collections.synchronizedMap(this.bondOrderPMap);
    }

    @Override
    public synchronized Map<IAtom, String> getStereoCenterAtomsReactant() {
        return Collections.synchronizedMap(this.AtomStereoRMap);
    }

    @Override
    public synchronized Map<IAtom, String> getStereoCenterAtomsProduct() {
        return Collections.synchronizedMap(this.AtomStereoPMap);
    }

    @Override
    public synchronized IReaction getReactionWithCompressUnChangedHydrogens() {
        IReaction compressedReaction = null;
        try {
            List<IAtom> atoms;
            compressedReaction = ExtReactionManipulatorTool.deepClone(this.mappedReaction);
            compressedReaction.setProperties(this.mappedReaction.getProperties());
            HashMap<IAtom, IAtom> mappings = new HashMap<IAtom, IAtom>();
            for (IMapping iMapping : compressedReaction.mappings()) {
                mappings.put((IAtom)iMapping.getChemObject(0), (IAtom)iMapping.getChemObject(1));
            }
            for (IAtomContainer iAtomContainer : compressedReaction.getReactants().atomContainers()) {
                atoms = BondChangeCalculator.getAtoms(iAtomContainer);
                if (atoms.size() <= 1) continue;
                for (IAtom atom : atoms) {
                    if (!atom.getSymbol().equalsIgnoreCase("H") || !mappings.containsKey(atom) || atom.getProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION) != null) continue;
                    iAtomContainer.removeAtomAndConnectedElectronContainers(atom);
                }
                CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance(iAtomContainer.getBuilder());
                try {
                    hAdder.addImplicitHydrogens(iAtomContainer);
                    Kekulization.kekulize(iAtomContainer);
                }
                catch (CDKException atom) {}
            }
            for (IAtomContainer iAtomContainer : compressedReaction.getProducts().atomContainers()) {
                atoms = BondChangeCalculator.getAtoms(iAtomContainer);
                if (atoms.size() <= 1) continue;
                for (IAtom atom : atoms) {
                    if (!atom.getSymbol().equalsIgnoreCase("H") || !mappings.containsValue(atom) || atom.getProperty((Object)ECBLAST_FLAGS.BOND_CHANGE_INFORMATION) != null) continue;
                    iAtomContainer.removeAtomAndConnectedElectronContainers(atom);
                }
                CDKHydrogenAdder cdkHAdder = CDKHydrogenAdder.getInstance(iAtomContainer.getBuilder());
                try {
                    cdkHAdder.addImplicitHydrogens(iAtomContainer);
                    Kekulization.kekulize(iAtomContainer);
                }
                catch (CDKException cDKException) {}
            }
            this.cleanMapping(compressedReaction);
            for (Map.Entry entry : mappings.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                ((IAtom)entry.getKey()).setFlag(128, true);
                ((IAtom)entry.getValue()).setFlag(128, true);
                compressedReaction.addMapping(new Mapping((IChemObject)entry.getKey(), (IChemObject)entry.getValue()));
            }
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(BondChangeCalculator.class.getName()).log(Level.SEVERE, null, ex);
        }
        return compressedReaction;
    }

    private synchronized void cleanMapping(IReaction MappedReaction) {
        int count;
        for (int i = count = MappedReaction.getMappingCount(); i > 0; --i) {
            MappedReaction.removeMapping(i);
        }
        for (int eMol = 0; eMol < MappedReaction.getReactantCount(); ++eMol) {
            IAtomContainer eMolecule = MappedReaction.getReactants().getAtomContainer(eMol);
            for (int eAtom = 0; eAtom < eMolecule.getAtomCount(); ++eAtom) {
                IAtom atomEMap = MappedReaction.getReactants().getAtomContainer(eMol).getAtom(eAtom);
                atomEMap.setFlag(128, false);
            }
        }
        for (int pMol = 0; pMol < MappedReaction.getProductCount(); ++pMol) {
            IAtomContainer pMolecule = MappedReaction.getProducts().getAtomContainer(pMol);
            for (int pAtom = 0; pAtom < pMolecule.getAtomCount(); ++pAtom) {
                IAtom atomPMap = MappedReaction.getProducts().getAtomContainer(pMol).getAtom(pAtom);
                atomPMap.setFlag(128, false);
            }
        }
    }

    @Override
    public synchronized IReaction getReaction() throws Exception {
        IReaction mappedReactionWithBondChanges = this.mappedReaction;
        return mappedReactionWithBondChanges;
    }

    @Override
    public synchronized Map<IAtom, IAtom> getAtomAtomMappings() {
        return this.bondChangeAnnotator.getMappingMap();
    }

    @Override
    public synchronized AtomAtomMappingContainer getMappingContainer() {
        return this.bondChangeAnnotator.getMappingContainer();
    }

    public synchronized int getTotalBondBreakingEnergy() throws CDKException {
        return this.energySum;
    }

    public synchronized int getEnergyDelta() {
        return Math.abs(this.energyDelta);
    }

    private void setEnergyDelta(int energyDelta) {
        this.energyDelta = energyDelta;
    }

    @Override
    public List<AtomStereoChangeInformation> getStereoChangeList() {
        return this.bondChangeAnnotator.getStereoChangeList();
    }

    @Override
    public Iterable<AtomStereoChangeInformation> getConformationChangeList() {
        return this.bondChangeAnnotator.getConformationChangeList();
    }

    private String getLicenseHeader() {
        StringBuilder result = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        result.append(NEW_LINE).append("++++++++++++++++++++++++++++++++++++++++++++++").append(NEW_LINE);
        result.append(NEW_LINE).append("ecBLAST (Enzymatic Reaction BLAST)");
        result.append(NEW_LINE).append("++++++++++++++++++++++++++++++++++++++++++++++").append(NEW_LINE);
        result.append(NEW_LINE).append("Contact: Syed Asad Rahman,");
        result.append(NEW_LINE).append("\t EMBL-EBI, Hinxton ");
        result.append(NEW_LINE).append("\t Cambridge CB10 1SD");
        result.append(NEW_LINE).append("\t United Kingdom ");
        result.append(NEW_LINE).append("e-mail: asad@ebi.ac.uk, thornton@ebi.ac.uk");
        result.append(NEW_LINE).append("++++++++++++++++++++++++++++++++++++++++++++++").append(NEW_LINE);
        result.append(NEW_LINE).append("ecBLAST software can perform atom-atom mapping,");
        result.append(NEW_LINE).append("marks bond changes between reactions, calculate");
        result.append(NEW_LINE).append("similarity between small molecules, reactions");
        result.append(NEW_LINE).append("using in-house algorithm developed at EMBL-EBI.");
        result.append(NEW_LINE).append("++++++++++++++++++++++++++++++++++++++++++++++").append(NEW_LINE);
        result.append(NEW_LINE).append("Acknowledgment: Many thanks to Franz Fenninger,");
        result.append(NEW_LINE).append("Gilleain Torrance, Lorenzo Baldacci and Gemma L.");
        result.append(NEW_LINE).append("Holliday for their contributions/inputs.").append(NEW_LINE);
        result.append(NEW_LINE).append("The open source tools i.e. the SMSD, CDK and InChI");
        result.append(NEW_LINE).append("were used in this project. The licensed version of");
        result.append(NEW_LINE).append("the Chemaxon was used for 3D model building,");
        result.append(NEW_LINE).append("cleaning and hydrogen handling.");
        result.append(NEW_LINE).append("");
        result.append(NEW_LINE).append("++++++++++++++++++++++++++++++++++++++++++++++").append(NEW_LINE);
        return result.toString();
    }

    private String getLicenseFooter() {
        StringBuilder result = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        result.append(NEW_LINE).append("++++++++++++++++++++++++++++++++++++++++++++++").append(NEW_LINE);
        result.append(NEW_LINE).append("NOTE: You can't distribute this tool or it's");
        result.append(NEW_LINE).append("components, including the output without prior");
        result.append(NEW_LINE).append("written approval from the authors. *Copyright");
        result.append(NEW_LINE).append("and limitations* of use except where indicated,");
        result.append(NEW_LINE).append("all content on this tool, including programs,");
        result.append(NEW_LINE).append("code, concept, text and collectively the \"content\"");
        result.append(NEW_LINE).append("is the property of authors and is protected by");
        result.append(NEW_LINE).append("copyright and other intellectual property laws.").append(NEW_LINE);
        result.append(NEW_LINE).append("Certain content might be licensed on a non-exclusive");
        result.append(NEW_LINE).append("basis from 3rd Parties. This is a beta version;");
        result.append(NEW_LINE).append("suggestions to improve this tool are welcome.");
        result.append(NEW_LINE).append("++++++++++++++++++++++++++++++++++++++++++++++").append(NEW_LINE);
        return result.toString();
    }

    public Map<Integer, IPatternFingerprinter> getReactionCenterFormedCleavedFingerprint() {
        return Collections.synchronizedMap(this.reactionCenterFormedCleavedFingerprint);
    }

    public Map<Integer, IPatternFingerprinter> getReactionCenterOrderChangeFingerprint() {
        return Collections.synchronizedMap(this.reactionCenterOrderChangeFingerprint);
    }

    public Map<Integer, IPatternFingerprinter> getReactionCenterStereoChangeFingerprint() {
        return Collections.synchronizedMap(this.reactionCenterStereoChangeFingerprint);
    }

    @Override
    public Collection<IAtom> getReactionCenterSet() {
        return this.bondChangeAnnotator.getReactionCenterSet();
    }

    @Override
    public Collection<ReactionCenterFragment> getReactionCenterFragmentList() {
        return Collections.unmodifiableCollection(this.reactionCenterFragmentList);
    }

    @Override
    public Collection<MoleculeMoleculePair> getReactionCentreTransformationPairs() {
        return Collections.unmodifiableCollection(this.reactionMoleculeMoleculePairList);
    }

    @Override
    public Map<String, Collection<String>> getMoleculeMoleculeTransformationPairs() {
        TreeMap<String, Collection<String>> uniqueRPAIRS = new TreeMap<String, Collection<String>>();
        for (MoleculeMoleculePair m : this.getReactionCentreTransformationPairs()) {
            if (!uniqueRPAIRS.containsKey(m.getName().toString())) {
                LinkedList l = new LinkedList();
                uniqueRPAIRS.put(m.getName().toString(), l);
            }
            ((Collection)uniqueRPAIRS.get(m.getName().toString())).add(m.getSmirks());
        }
        return uniqueRPAIRS;
    }

    private int chipTheBondCountSmallestFragmentSize(IAtomContainer cloneContainer, int chippedBondIndex) {
        int size = cloneContainer.getAtomCount();
        cloneContainer.removeBond(chippedBondIndex);
        boolean fragmentFlag = ConnectivityChecker.isConnected(cloneContainer);
        if (!fragmentFlag) {
            IAtomContainerSet partitionIntoMolecules = ConnectivityChecker.partitionIntoMolecules(cloneContainer);
            for (IAtomContainer ac : partitionIntoMolecules.atomContainers()) {
                if (size <= ac.getAtomCount()) continue;
                size = ac.getAtomCount();
            }
        }
        return size;
    }

    public int getTotalSmallestFragmentSize() {
        return this.totalSmallestFragmentSize;
    }
}

