/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;
import org.openscience.smsd.tools.BondEnergies;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IFeature;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IPatternFingerprinter;
import uk.ac.ebi.reactionblast.interfaces.IStandardizer;
import uk.ac.ebi.reactionblast.mapping.CallableAtomMappingTool;
import uk.ac.ebi.reactionblast.mapping.Reactor;
import uk.ac.ebi.reactionblast.mapping.interfaces.IMappingAlgorithm;
import uk.ac.ebi.reactionblast.mechanism.BondChangeCalculator;
import uk.ac.ebi.reactionblast.mechanism.MappingSolution;
import uk.ac.ebi.reactionblast.tools.StandardizeReaction;

public class ReactionMechanismTool
implements Serializable {
    private static final boolean DEBUG = false;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(ReactionMechanismTool.class);
    private static final long serialVersionUID = 998977861L;
    private static final Logger LOG = Logger.getLogger(ReactionMechanismTool.class.getName());
    private MappingSolution selectedMapping = null;
    private Collection<MappingSolution> allSolutions = Collections.synchronizedList(new ArrayList());

    public ReactionMechanismTool(IReaction reaction, boolean forcedMapping, boolean generate2D, boolean generate3D) throws Exception {
        this(reaction, forcedMapping, generate2D, generate3D, new StandardizeReaction());
    }

    public ReactionMechanismTool(IReaction reaction, boolean forcedMapping, boolean generate2D, boolean generate3D, IStandardizer standardizer) throws CDKException, AssertionError, Exception {
        if (!this.isBalanced(reaction)) {
            logger.info("Atoms not balanced in the input reaction: {0}; unbalanced reaction may result in erroneous bond change assumptions!", reaction.getID());
            if (!forcedMapping) {
                return;
            }
        }
        if (!forcedMapping && reaction.getFlag(128) && AtomContainerSetManipulator.getAtomCount(reaction.getReactants()) == reaction.getMappingCount()) {
            try {
                logger.info("Using user defined mappings!");
                for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
                    for (IAtom a : ac.atoms()) {
                        a.setID(a.getProperty("cdk:AtomAtomMapping") + "");
                    }
                }
                for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
                    for (IAtom a : ac.atoms()) {
                        a.setID(a.getProperty("cdk:AtomAtomMapping") + "");
                    }
                }
                for (IMapping map : reaction.mappings()) {
                    if (map.getChemObject(0) == null || map.getChemObject(1) == null) continue;
                    map.getChemObject(0).setFlag(128, true);
                    map.getChemObject(1).setFlag(128, true);
                }
                boolean selected = this.isMappingSolutionAcceptable(null, IMappingAlgorithm.USER_DEFINED, reaction, generate2D, generate3D);
                logger.info("is solution: " + (Object)((Object)IMappingAlgorithm.USER_DEFINED) + " selected: " + selected);
            }
            catch (Exception e) {
                String ls = System.getProperty("line.separator");
                throw new CDKException(ls + "ERROR: Unable to calculate bond changes: " + e.getMessage());
            }
        }
        try {
            boolean onlyCoreMappingByMCS = true;
            CallableAtomMappingTool amt = new CallableAtomMappingTool(reaction, standardizer, onlyCoreMappingByMCS);
            Map<IMappingAlgorithm, Reactor> solutions = amt.getSolutions();
            logger.info("!!!!Calculating Best Mapping Model!!!!");
            for (IMappingAlgorithm algorithm : solutions.keySet()) {
                int atomCountP;
                Reactor reactor = solutions.get((Object)algorithm);
                int atomCountR = this.getNonHydrogenMappingAtomCount(reactor.getReactionWithAtomAtomMapping().getReactants());
                if (atomCountR != (atomCountP = this.getNonHydrogenMappingAtomCount(reactor.getReactionWithAtomAtomMapping().getProducts()))) {
                    logger.warn("ERROR in Mapping " + reactor.toString());
                    String newline = System.getProperty("line.separator");
                    logger.warn("Unmapped atoms present in this reaction(" + (Object)((Object)algorithm) + ") algorithm.");
                }
                boolean selected = this.isMappingSolutionAcceptable(solutions.get((Object)algorithm), algorithm, reactor.getReactionWithAtomAtomMapping(), generate2D, generate3D);
                logger.info("is solution: " + (Object)((Object)algorithm) + " selected: " + selected);
            }
            System.gc();
        }
        catch (Exception e) {
            String ls = System.getProperty("line.separator");
            throw new CDKException(ls + "ERROR: Unable to calculate bond changes: " + e.getMessage());
        }
    }

    private boolean isBalanced(IReaction r) {
        TreeMap<String, Integer> atomUniqueCounter1 = new TreeMap<String, Integer>();
        TreeMap<String, Integer> atomUniqueCounter2 = new TreeMap<String, Integer>();
        int leftHandAtomCount = 0;
        for (IAtomContainer q : r.getReactants().atomContainers()) {
            for (IAtom a : q.atoms()) {
                if (a.getSymbol().equals("H")) continue;
                if (!atomUniqueCounter1.containsKey(a.getSymbol())) {
                    atomUniqueCounter1.put(a.getSymbol(), 1);
                } else {
                    int counter = (Integer)atomUniqueCounter1.get(a.getSymbol()) + 1;
                    atomUniqueCounter1.put(a.getSymbol(), counter);
                }
                ++leftHandAtomCount;
            }
        }
        int rightHandAtomCount = 0;
        for (IAtomContainer t : r.getProducts().atomContainers()) {
            for (IAtom b : t.atoms()) {
                if (b.getSymbol().equals("H")) continue;
                if (!atomUniqueCounter2.containsKey(b.getSymbol())) {
                    atomUniqueCounter2.put(b.getSymbol(), 1);
                } else {
                    int counter = (Integer)atomUniqueCounter2.get(b.getSymbol()) + 1;
                    atomUniqueCounter2.put(b.getSymbol(), counter);
                }
                ++rightHandAtomCount;
            }
        }
        if (leftHandAtomCount != rightHandAtomCount) {
            System.err.println();
            System.err.println("Number of atom(s) on the Left side " + leftHandAtomCount + " =/= Number of atom(s) on the Right side " + rightHandAtomCount);
            System.err.println(atomUniqueCounter1 + " =/= " + atomUniqueCounter2);
            return false;
        }
        if (!atomUniqueCounter1.keySet().equals(atomUniqueCounter2.keySet())) {
            System.err.println();
            System.err.println("Number of atom(s) on the Left side " + leftHandAtomCount + " =/= Number of atom(s) on the Right side " + rightHandAtomCount);
            System.err.println(atomUniqueCounter1 + " =/= " + atomUniqueCounter2);
            return false;
        }
        return atomUniqueCounter1.keySet().equals(atomUniqueCounter2.keySet());
    }

    private synchronized boolean isMappingSolutionAcceptable(Reactor reactor, IMappingAlgorithm ma, IReaction reaction, boolean generate2D, boolean generate3D) throws Exception {
        boolean chosen = false;
        try {
            if (reactor == null && ma.equals((Object)IMappingAlgorithm.USER_DEFINED)) {
                BondChangeCalculator bcc = new BondChangeCalculator(reaction, generate2D, generate3D);
                int fragmentDeltaChanges = 0;
                int bondChange = (int)this.getTotalBondChange(bcc.getFormedCleavedWFingerprint());
                bondChange = (int)((double)bondChange + this.getTotalBondChange(bcc.getOrderChangesWFingerprint()));
                int stereoChanges = (int)this.getTotalBondChange(bcc.getStereoChangesWFingerprint());
                boolean skipHydrogenRealtedBondChanges = true;
                int bondBreakingEnergy = this.getTotalBondChangeEnergy(bcc.getFormedCleavedWFingerprint(), skipHydrogenRealtedBondChanges);
                int totalSmallestFragmentCount = bcc.getTotalSmallestFragmentSize();
                int totalCarbonBondChanges = this.getTotalCarbonBondChange(bcc.getFormedCleavedWFingerprint());
                int localScore = bondChange + fragmentDeltaChanges;
                MappingSolution mappingSolution = new MappingSolution(bcc, ma, bcc.getReaction(), reactor, bondBreakingEnergy, totalCarbonBondChanges, bondChange, fragmentDeltaChanges, stereoChanges, totalSmallestFragmentCount, localScore, bcc.getEnergyDelta());
                chosen = true;
                mappingSolution.setChosen(chosen);
                this.selectedMapping = mappingSolution;
                this.allSolutions.add(mappingSolution);
            } else {
                int bondCleavedFormed;
                if (reactor == null) {
                    throw new CDKException("Reactor is NULL");
                }
                BondChangeCalculator bcc = new BondChangeCalculator(reactor.getReactionWithAtomAtomMapping(), generate2D, generate3D);
                int fragmentDeltaChanges = reactor.getDelta();
                int bondChange = bondCleavedFormed = (int)this.getTotalBondChange(bcc.getFormedCleavedWFingerprint());
                bondChange = (int)((double)bondChange + this.getTotalBondChange(bcc.getOrderChangesWFingerprint()));
                int stereoChanges = (int)this.getTotalBondChange(bcc.getStereoChangesWFingerprint());
                boolean skipHydrogenRealtedBondChanges = true;
                int bondBreakingEnergy = this.getTotalBondChangeEnergy(bcc.getFormedCleavedWFingerprint(), skipHydrogenRealtedBondChanges);
                int totalSmallestFragmentCount = bcc.getTotalSmallestFragmentSize();
                int totalCarbonBondChanges = this.getTotalCarbonBondChange(bcc.getFormedCleavedWFingerprint());
                logger.info("Score: " + fragmentDeltaChanges + " : " + bondChange);
                logger.info(", Energy Barrier: " + bondBreakingEnergy);
                logger.info(", Energy Delta: " + bcc.getEnergyDelta());
                int localScore = bondChange + fragmentDeltaChanges;
                bcc.getReaction().setFlag(128, true);
                MappingSolution mappingSolution = new MappingSolution(bcc, ma, bcc.getReaction(), reactor, bondBreakingEnergy, totalCarbonBondChanges, bondChange, fragmentDeltaChanges, stereoChanges, totalSmallestFragmentCount, localScore, bcc.getEnergyDelta());
                if (ma == null) {
                    throw new CDKException("Model is pointing to NULL");
                }
                logger.info("MA: " + ma.description());
                if (this.isChangeFeasible(mappingSolution)) {
                    chosen = true;
                    mappingSolution.setChosen(chosen);
                    this.selectedMapping = mappingSolution;
                }
                this.allSolutions.add(mappingSolution);
            }
        }
        catch (Exception e) {
            String ls = System.getProperty("line.separator");
            throw new CDKException(ls + "ERROR: Unable to calculate bond changes: " + e.getMessage());
        }
        return chosen;
    }

    private synchronized boolean isChangeFeasible(MappingSolution ms) {
        if (this.selectedMapping != null && ms.getTotalBondChanges() == 0 && ms.getTotalStereoChanges() == 0) {
            return false;
        }
        if (this.selectedMapping == null) {
            logger.info("Condition Default " + ms.getAlgorithmID().description());
            return true;
        }
        if (ms.getBondEnergySum() == 0.0 && ms.getTotalFragmentChanges() == 0 && ms.getTotalBondChanges() == 0 && this.selectedMapping.getTotalStereoChanges() >= ms.getTotalStereoChanges()) {
            logger.info("Condition 1 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() > ms.getTotalBondChanges() && this.selectedMapping.getTotalCarbonBondChanges() > 0 && this.selectedMapping.getTotalCarbonBondChanges() > ms.getTotalCarbonBondChanges() && (this.selectedMapping.getTotalFragmentChanges() > ms.getTotalFragmentChanges() || this.selectedMapping.getBondEnergySum() > ms.getBondEnergySum())) {
            logger.info("Condition 2 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() > ms.getTotalBondChanges() && this.selectedMapping.getTotalFragmentChanges() > 0 && ms.getTotalFragmentChanges() > 0) {
            logger.info("Condition 3 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalFragmentChanges() >= ms.getTotalFragmentChanges() && this.selectedMapping.getSmallestFragmentCount() >= ms.getSmallestFragmentCount() && this.selectedMapping.getBondEnergySum() > ms.getBondEnergySum() && this.selectedMapping.getTotalCarbonBondChanges() >= ms.getTotalCarbonBondChanges()) {
            logger.info("Condition 4 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalFragmentChanges() > ms.getTotalFragmentChanges() && this.selectedMapping.getSmallestFragmentCount() > ms.getSmallestFragmentCount()) {
            logger.info("Condition 5 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalFragmentChanges() == ms.getTotalFragmentChanges() && this.selectedMapping.getSmallestFragmentCount() == ms.getSmallestFragmentCount() && this.selectedMapping.getBondEnergySum() > ms.getBondEnergySum() && this.selectedMapping.getTotalCarbonBondChanges() >= ms.getTotalCarbonBondChanges()) {
            logger.info("Condition 6 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalFragmentChanges() > ms.getTotalFragmentChanges() && this.selectedMapping.getBondEnergySum() > ms.getBondEnergySum()) {
            logger.info("Condition 7 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() == ms.getTotalBondChanges() && this.selectedMapping.getTotalFragmentChanges() > ms.getTotalFragmentChanges()) {
            logger.info("Condition 8 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalFragmentChanges() == ms.getTotalFragmentChanges() && this.selectedMapping.getBondEnergySum() == ms.getBondEnergySum() && this.selectedMapping.getTotalBondChanges() > ms.getTotalBondChanges()) {
            logger.info("Condition 9 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getBondEnergySum() == ms.getBondEnergySum() && this.selectedMapping.getTotalBondChanges() == ms.getTotalBondChanges() && this.selectedMapping.getTotalStereoChanges() > ms.getTotalStereoChanges()) {
            logger.info("Condition 10 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getBondEnergySum() > ms.getBondEnergySum() && this.selectedMapping.getTotalCarbonBondChanges() > ms.getTotalCarbonBondChanges()) {
            logger.info("Condition 11 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() < ms.getTotalBondChanges() && this.selectedMapping.getBondEnergySum() < ms.getBondEnergySum() && this.selectedMapping.getTotalCarbonBondChanges() > 0 && this.selectedMapping.getTotalCarbonBondChanges() > ms.getTotalCarbonBondChanges() && this.selectedMapping.getSmallestFragmentCount() > ms.getSmallestFragmentCount()) {
            logger.info("Condition 12 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() > ms.getTotalBondChanges() && this.selectedMapping.getTotalCarbonBondChanges() > ms.getTotalCarbonBondChanges() && this.selectedMapping.getSmallestFragmentCount() > ms.getSmallestFragmentCount()) {
            logger.info("Condition 13 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() == ms.getTotalBondChanges() && this.selectedMapping.getTotalCarbonBondChanges() == ms.getTotalCarbonBondChanges() && this.selectedMapping.getSmallestFragmentCount() > ms.getSmallestFragmentCount()) {
            logger.info("Condition 14 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() == ms.getTotalBondChanges() && this.selectedMapping.getTotalCarbonBondChanges() == ms.getTotalCarbonBondChanges() && this.selectedMapping.getBondEnergySum() > ms.getBondEnergySum()) {
            logger.info("Condition 15 " + ms.getAlgorithmID().description());
            return true;
        }
        return false;
    }

    private synchronized double getTotalBondChange(IPatternFingerprinter fingerprint) throws CDKException {
        double total = 0.0;
        for (IFeature key : fingerprint.getFeatures()) {
            double val = key.getWeight();
            if (!(val > 0.0)) continue;
            total += val;
        }
        return total;
    }

    private synchronized int getTotalCarbonBondChange(IPatternFingerprinter fingerprint) throws CDKException {
        double total = 0.0;
        for (IFeature key : fingerprint.getFeatures()) {
            double val;
            if (!key.getPattern().contains("C-C") && !key.getPattern().contains("C=C") && !key.getPattern().contains("C#C") && !key.getPattern().contains("C%C") && !key.getPattern().contains("C@C") || !((val = key.getWeight()) > 0.0)) continue;
            total += val;
        }
        return (int)total;
    }

    private synchronized int getTotalBondChangeEnergy(IPatternFingerprinter fingerprint, boolean skipHydrogen) {
        int total = 0;
        try {
            BondEnergies be = BondEnergies.getInstance();
            for (IFeature feature : fingerprint.getFeatures()) {
                int energy;
                String[] temp;
                double val = feature.getWeight();
                String key = feature.getPattern();
                if (!(val > 0.0)) continue;
                if (key.contains("-") || key.contains("%") || key.contains("@")) {
                    temp = null;
                    if (key.contains("-")) {
                        temp = key.split("-");
                    } else if (key.contains("%")) {
                        temp = key.split("%");
                    } else if (key.contains("@")) {
                        temp = key.split("@");
                    }
                    if (skipHydrogen && (temp[0].equals("H") || temp[1].equals("H")) || (energy = be.getEnergies(temp[0], temp[1], IBond.Order.SINGLE)) <= 0) continue;
                    if (key.contains("%")) {
                        total = (int)((double)total + val * ((double)energy - 5.0));
                        continue;
                    }
                    total = (int)((double)total + val * (double)energy);
                    continue;
                }
                if (key.contains("=")) {
                    temp = key.split("=");
                    if (skipHydrogen && (temp[0].equals("H") || temp[1].equals("H")) || (energy = be.getEnergies(temp[0], temp[1], IBond.Order.DOUBLE)) <= 0) continue;
                    total = (int)((double)total + val * (double)energy);
                    continue;
                }
                if (key.contains("#")) {
                    temp = key.split("#");
                    energy = be.getEnergies(temp[0], temp[1], IBond.Order.TRIPLE);
                    if (skipHydrogen && (temp[0].equals("H") || temp[1].equals("H")) || energy <= 0) continue;
                    total = (int)((double)total + val * (double)energy);
                    continue;
                }
                if (!key.contains("$")) continue;
                temp = key.split("$");
                if (skipHydrogen && (temp[0].equals("H") || temp[1].equals("H")) || (energy = be.getEnergies(temp[0], temp[1], IBond.Order.QUADRUPLE)) <= 0) continue;
                total = (int)((double)total + val * (double)energy);
            }
        }
        catch (CDKException ex) {
            Logger.getLogger(ReactionMechanismTool.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Math.abs(total);
    }

    public String getMappingDescription() {
        return this.selectedMapping.toString();
    }

    public MappingSolution getSelectedSolution() {
        return this.selectedMapping;
    }

    public Collection<MappingSolution> getAllSolutions() {
        return Collections.unmodifiableCollection(this.allSolutions);
    }

    private int getNonHydrogenMappingAtomCount(IAtomContainerSet mol) {
        int count = Integer.MIN_VALUE;
        List<IAtomContainer> allAtomContainers = AtomContainerSetManipulator.getAllAtomContainers(mol);
        for (IAtomContainer ac : allAtomContainers) {
            IAtom[] atomArray;
            for (IAtom atom : atomArray = AtomContainerManipulator.getAtomArray(ac)) {
                if (atom.getSymbol().equalsIgnoreCase("H") || atom.getID() == null || Integer.parseInt(atom.getID()) <= count) continue;
                count = Integer.parseInt(atom.getID());
            }
        }
        return count;
    }
}

