/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism.helper;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.smiles.smarts.parser.SMARTSParser;
import org.openscience.smsd.algorithm.vflib.substructure.VF2;
import org.openscience.smsd.helper.MoleculeInitializer;
import uk.ac.ebi.reactionblast.tools.ExtAtomContainerManipulator;

class CountSubstructures
extends MoleculeInitializer
implements Serializable {
    private static final long serialVersionUID = 12343289751445148L;
    private static final Logger LOG = Logger.getLogger(CountSubstructures.class.getName());
    private SmilesParser sp = new SmilesParser(DefaultChemObjectBuilder.getInstance());
    private IAtomContainer mol;

    CountSubstructures(IAtomContainer atomContainer) throws CloneNotSupportedException {
        try {
            this.mol = null;
            this.mol = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(atomContainer);
            CountSubstructures.initializeMolecule(this.mol);
        }
        catch (CDKException ex) {
            Logger.getLogger(CountSubstructures.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int substructureSize(String smiles) throws CDKException {
        try {
            IAtomContainer parseSmiles = this.sp.parseSmiles(smiles);
            VF2 vf = new VF2(parseSmiles, this.mol, true, true, true);
            return vf.isSubgraph() ? vf.getFirstAtomMapping().getCount() : 0;
        }
        catch (InvalidSmilesException ex) {
            VF2 vf = new VF2(SMARTSParser.parse(smiles, this.mol.getBuilder()), this.mol);
            return vf.isSubgraph() ? vf.getFirstAtomMapping().getCount() : 0;
        }
    }
}

