/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism.helper;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.logging.Logger;

public class ReactantProductPair
implements Serializable,
Comparable<ReactantProductPair>,
Comparator<ReactantProductPair> {
    private static final long serialVersionUID = 19876565735478L;
    private static final Logger LOG = Logger.getLogger(ReactantProductPair.class.getName());
    private final String query;
    private final String target;

    public ReactantProductPair(String query2, String target) {
        this.query = query2;
        this.target = target;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.query);
        hash = 97 * hash + Objects.hashCode(this.target);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReactantProductPair other = (ReactantProductPair)obj;
        if (!Objects.equals(this.query, other.query)) {
            return false;
        }
        return Objects.equals(this.target, other.target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("R:").append(this.getQuery());
        sb.append(", P:").append(this.getTarget());
        return sb.toString();
    }

    public String getQuery() {
        return this.query;
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    public int compareTo(ReactantProductPair o) {
        String local = this.query + this.target;
        String object = o.getQuery() + o.getTarget();
        return local.compareTo(object);
    }

    @Override
    public int compare(ReactantProductPair o1, ReactantProductPair o2) {
        return o1.compareTo(o2);
    }
}

