/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism.interfaces;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IPatternFingerprinter;
import uk.ac.ebi.reactionblast.mechanism.helper.MoleculeMoleculePair;
import uk.ac.ebi.reactionblast.mechanism.helper.ReactantProductPair;
import uk.ac.ebi.reactionblast.mechanism.helper.ReactionCenterFragment;
import uk.ac.ebi.reactionblast.mechanism.helper.Utility;

public abstract class AbstractChangeCalculator
extends Utility {
    private static final long serialVersionUID = 1523522323512L;

    public abstract Map<String, Collection<String>> getMoleculeMoleculeTransformationPairs();

    public abstract Map<IBond, String> getBondCleavedReactant();

    public abstract Map<IBond, String> getBondFormedProduct();

    public abstract Map<IBond, String> getBondOrderProduct();

    public abstract Map<IBond, String> getBondOrderReactant();

    public abstract Map<IAtom, String> getStereoCenterAtomsProduct();

    public abstract Map<IAtom, String> getStereoCenterAtomsReactant();

    public abstract IPatternFingerprinter getFormedCleavedWFingerprint() throws CDKException;

    public abstract IPatternFingerprinter getOrderChangesWFingerprint() throws CDKException;

    public abstract IPatternFingerprinter getReactionCenterWFingerprint() throws CDKException;

    public abstract Collection<ReactionCenterFragment> getReactionCenterFragmentList();

    public abstract IReaction getReaction() throws Exception;

    public abstract IReaction getReactionWithCompressUnChangedHydrogens() throws Exception;

    public abstract IPatternFingerprinter getStereoChangesWFingerprint() throws CDKException;

    public abstract Map<IAtom, IAtom> getAtomAtomMappings();

    public abstract void writeBondChanges(File var1) throws IOException;

    public abstract Collection<MoleculeMoleculePair> getReactionCentreTransformationPairs();

    protected static MoleculeMoleculePair getMolMolPair(IAtom reactantAtom, IAtom productAtom, IAtomContainer atomContainerR, IAtomContainer atomContainerP) throws Exception {
        int atomIndexR = AbstractChangeCalculator.getAtomIndexByID(atomContainerR, reactantAtom);
        String signatureR1 = AbstractChangeCalculator.getSignature(atomContainerR, reactantAtom, 1);
        String signatureR2 = AbstractChangeCalculator.getSignature(atomContainerR, reactantAtom, 2);
        String signatureR3 = AbstractChangeCalculator.getSignature(atomContainerR, reactantAtom, 3);
        String signatureR = AbstractChangeCalculator.getSignature(atomContainerR, reactantAtom, -1);
        IAtomContainer fragR1 = AbstractChangeCalculator.getCircularFragment(atomContainerR, atomIndexR, 1);
        IAtomContainer fragR2 = AbstractChangeCalculator.getCircularFragment(atomContainerR, atomIndexR, 2);
        IAtomContainer fragR3 = AbstractChangeCalculator.getCircularFragment(atomContainerR, atomIndexR, 3);
        IAtomContainer fragR = AbstractChangeCalculator.getCircularFragment(atomContainerR, atomIndexR, -1);
        String signatureP1 = AbstractChangeCalculator.getSignature(atomContainerP, productAtom, 1);
        String signatureP2 = AbstractChangeCalculator.getSignature(atomContainerP, productAtom, 2);
        String signatureP3 = AbstractChangeCalculator.getSignature(atomContainerP, productAtom, 3);
        String signatureP = AbstractChangeCalculator.getSignature(atomContainerP, productAtom, -1);
        int atomIndexP = AbstractChangeCalculator.getAtomIndexByID(atomContainerP, productAtom);
        IAtomContainer fragP1 = AbstractChangeCalculator.getCircularFragment(atomContainerP, atomIndexP, 1);
        IAtomContainer fragP2 = AbstractChangeCalculator.getCircularFragment(atomContainerP, atomIndexP, 2);
        IAtomContainer fragP3 = AbstractChangeCalculator.getCircularFragment(atomContainerP, atomIndexP, 3);
        IAtomContainer fragP = AbstractChangeCalculator.getCircularFragment(atomContainerP, atomIndexP, -1);
        Reaction reaction1 = new Reaction();
        reaction1.addReactant(fragR1, 1.0);
        reaction1.addProduct(fragP1, 1.0);
        Reaction reaction2 = new Reaction();
        reaction2.addReactant(fragR2, 1.0);
        reaction2.addProduct(fragP2, 1.0);
        Reaction reaction3 = new Reaction();
        reaction3.addReactant(fragR3, 1.0);
        reaction3.addProduct(fragP3, 1.0);
        Reaction reaction = new Reaction();
        reaction.addReactant(fragR, 1.0);
        reaction.addProduct(fragP, 1.0);
        String smirks = AbstractChangeCalculator.getSMILES(reaction, true);
        String smirks1 = AbstractChangeCalculator.getSMILES(reaction1, true);
        String smirks2 = AbstractChangeCalculator.getSMILES(reaction2, true);
        String smirks3 = AbstractChangeCalculator.getSMILES(reaction3, true);
        String smartsR = AbstractChangeCalculator.getSMILES(fragR, true);
        String smartsR1 = AbstractChangeCalculator.getSMILES(fragR1, true);
        String smartsR2 = AbstractChangeCalculator.getSMILES(fragR2, true);
        String smartsR3 = AbstractChangeCalculator.getSMILES(fragR3, true);
        String smartsP = AbstractChangeCalculator.getSMILES(fragP, true);
        String smartsP1 = AbstractChangeCalculator.getSMILES(fragP1, true);
        String smartsP2 = AbstractChangeCalculator.getSMILES(fragP2, true);
        String smartsP3 = AbstractChangeCalculator.getSMILES(fragP3, true);
        ReactantProductPair rrpName = new ReactantProductPair(atomContainerR.getID(), atomContainerP.getID());
        ReactantProductPair rrpSMARTS = new ReactantProductPair(smartsR, smartsP);
        ReactantProductPair rrpSignature = new ReactantProductPair(signatureR, signatureP);
        MoleculeMoleculePair mmp = new MoleculeMoleculePair(rrpName, rrpSMARTS, rrpSignature, smirks);
        mmp.setSignature1(new ReactantProductPair(signatureR1, signatureP1));
        mmp.setSignature2(new ReactantProductPair(signatureR2, signatureP2));
        mmp.setSignature3(new ReactantProductPair(signatureR3, signatureP3));
        mmp.setSmarts1(new ReactantProductPair(smartsR1, smartsP1));
        mmp.setSmarts2(new ReactantProductPair(smartsR2, smartsP2));
        mmp.setSmarts3(new ReactantProductPair(smartsR3, smartsP3));
        mmp.setSmirks1(smirks1);
        mmp.setSmirks2(smirks2);
        mmp.setSmirks3(smirks3);
        return mmp;
    }
}

